---
license: Licensed to the Apache Software Foundation (ASF) under one
         or more contributor license agreements.  See the NOTICE file
         distributed with this work for additional information
         regarding copyright ownership.  The ASF licenses this file
         to you under the Apache License, Version 2.0 (the
         "License"); you may not use this file except in compliance
         with the License.  You may obtain a copy of the License at
         
           http://www.apache.org/licenses/LICENSE-2.0
         
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
         under the License.
---

# Platform Guides

Before developing for any of the platforms listed below, install
cordova's command-line interface (CLI).
(For details, see The Command-line Interface.)

To develop Cordova applications, you must install SDKs for each mobile
platform you are targeting. This installation is necessary regardless
of whether you do the majority of your work in the SDK or use the CLI
for your build cycle.

Each _Platform Guide_ listed below tells you what you need to know to
set up each platform's development environment: where to obtain the
SDK, how to set up device emulators, how to connect devices for direct
testing, and how to manage signing key requirements.  Additional
guides provide information on each platform's unique set of
configuration options, instructions to add plugins, how to upgrade
each platform, and platform-specific command-line tools that serve as
a lower-level alternative to the `cordova` command-line utility.

## Android

* Android Platform Guide
* Android Configuration
* Android WebViews
* Android Plugins
* Android Command-line Tools
* Upgrading Android

## BlackBerry

* BlackBerry Platform Guide
* BlackBerry Configuration
* BlackBerry Command-line Tools
* Upgrading BlackBerry

## BlackBerry 10

* BlackBerry 10 Platform Guide
* BlackBerry 10 Configuration
* BlackBerry 10 Plugins
* BlackBerry 10 Command-line Tools

## iOS

* iOS Platform Guide
* iOS Configuration
* iOS WebViews
* iOS Plugins
* iOS Command-line Tools
* Upgrading iOS

## Windows Phone

* Windows Phone 8 Platform Guide
* Windows Phone 7 Platform Guide
* Windows Phone Command-line Tools
* Upgrading Windows Phone

## Windows 8

* Windows 8 Platform Guide
* Windows 8 Command-line Tools
* Upgrading Windows 8

## Tizen

* Tizen Platform Guide

<!--
## FirefoxOS

* FirefoxOS Configuration
-->
