---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# ブラックベリー 10 コマンド ライン ツール

`cordova`コマンド ライン ユーティリティは、一度にいくつかのプラットフォームでアプリケーションをビルドすることができます高度なツールです。 コルドバ フレームワークの古いバージョンをそれぞれのプラットフォームに固有のコマンド ライン ツールのセットを提供します。 CLI に代わるものとしてそれらを使用するには[cordova.apache.org][1]からコルドバのこのバージョンをダウンロードする必要があります。 ダウンロードには、プラットフォームごとに別々 のアーカイブが含まれています。 ターゲットにするプラットフォームを展開します。 ここで説明したツールは、最上位レベルでふつう利用できる `bin` ディレクトリ、それ以外の場合より詳細な方向の**README**ファイルを参照してください。

 [1]: http://cordova.apache.org

以下に示すコマンドのヘルプを使用する場合は、コマンドを入力、に沿って、 `-h` または `-help` の引数をすべてのコマンドでサポートされている使用可能な引数のそれぞれの説明を提供します。

## 作成します。

`create`コマンドは、新しいプロジェクトを作成します。

    bin/< パス-する-プロジェクトを作成する >< プロジェクト パッケージ >< プロジェクト名 >
    

どこ

*   `<path-to-project>`プロジェクト内に作成しディレクトリを指定します。

*   `<project-package>`逆引きドメイン スタイルの識別子を指定します

*   `<project-name>`アプリケーションの表示名を指定します。

**注：** 、 `create` コマンドによる依存関係のインストールをブートス トラップ、 `npm install` コマンド。 インストール ディレクトリとシステム権限に応じて、管理者特権が必要です。 Osx 版/Linux 上に問題がある場合実行 `sudo npm install` を使用する前に、 `create` コマンド。 Windows では、実行 `npm install` 管理者特権で開いたコマンド ライン ユーティリティです。

## ターゲット

`target`コマンドでは、エミュレーターまたはアプリのテストに使用するブラックベリー装置を管理することができます。追加または、ターゲットを削除または既定のターゲットとして、ターゲットを設定できます。

### ターゲットを追加します。

    < プロジェクトへのパス >/コルドバ/ターゲット < 名前 >< ip アドレス > を追加 [-t |--タイプ < デバイス | シミュレータ >] [-p |-< パスワード >] [--ピン < デバイス ピン >]
    

どこ

*   `<name>`ターゲットの一意の名前を指定します。

*   `<ip-address>`BlackBerry デバイスまたはシミュレータの ip アドレスを指定します。

*   `-p | --password <password>`デバイスまたはエミュレーターのパスワードを指定します。デバイスまたはエミュレーターがパスワード保護されている場合にのみ必要です。

*   `--pin <device-pin>`デバッグ トークンの有効なホストとしてそのデバイスを識別して、BlackBerry デバイスの PIN を指定します。 デバッグ トークンを作成している場合にのみ、この引数が必要です。

### ターゲットを削除します。

    < プロジェクトへのパス >/コルドバ/削除 < 名前 > のターゲットします。
    

### ターゲットを既定として設定します。

    コルドバ/< プロジェクトへのパス > < 名前 > の既定をターゲットします。
    

## ビルド

`build`コマンド .bar ファイルとしてプロジェクトをビルドします。 どちらかリリース モード （符号付き .bar ファイルを生成します) または (符号なしの .bar ファイルで作り出す) デバッグ モードでアプリをビルドすることができます。

### リリース モードでプロジェクトをビルドします。

    < プロジェクトへのパス >/コルドバ/リリースをビルド [-k |--keystorepass < パスワード >] [-b |--buildId < 番号 >] [-p |--params < params JSON ファイル >]
    

どこ

*   `-k | --keystorepass <password>`アプリケーションに署名するお使いのコンピューターを構成したときに定義されたパスワードを指定します。

*   `-b | --buildId <number>`アプリケーションのビルド バージョン番号を指定します。 通常は、署名付きの以前のバージョンからこの数字をインクリメントする必要があります。 この引数は省略可能です。

*   `-p | --params <params-JSON-file>`下流ツールに渡す追加のパラメーターを含む JSON ファイルを指定します。この引数は省略可能です。

### デバッグ モードでプロジェクトをビルドします。

    < プロジェクトへのパス >/コルドバ/ビルド デバッグ [< ターゲット >] [-k |--keystorepass < パスワード >] [-p |--params < params JSON ファイル >] [-ll |--loglevel < error|warn|verbose >]
    

どこ

*   `<target>`以前に追加したターゲットの名前を指定します。 場合 `<target>` が指定されていない、既定のターゲットを使用すると、1 つが作成されている場合。 この引数はのみ必要な BlackBerry デバイスにアプリを展開するスクリプトが必要なまたはエミュレーターとする、既定のターゲットを作成していないかどうか。 さらに場合、 `<target>` 、デバイスがそのデバイス USB 接続でお使いのコンピューターに接続する必要がありますまたはお使いのコンピューターと同じ Wi-Fi ネットワークに接続されています。

*   `-k | --keystorepass <password>`アプリケーションに署名するお使いのコンピューターを構成したときに定義されたパスワードを指定します。 このパスワードはデバッグ トークンの作成にも使用されます。 この引数はのみスクリプトを作成し、あなたのためのデバッグ トークンをインストールするかどうかに必要です。

*   `-p | --params <params-JSON-file>`下流ツールに渡す追加のパラメーターを含む JSON ファイルを指定します。

*   `-ll | --loglevel <level>`ログ レベルを指定します。ログ レベルのいずれか可能性があります `error` 、 `warn` 、または`verbose`.

ある場合、既定のターゲットに定義した (以前のインストール済みデバッグ トークンを対象が BlackBerry デバイスの場合)、引数なしでスクリプトを実行して、スクリプトにアプリのパッケージを既定のターゲットを展開します。 たとえば。

    < プロジェクトへのパス >/コルドバ/ビルドのデバッグ
    

## 実行

`run`コマンドは指定された BlackBerry デバイスまたはエミュレーターでアプリケーションをデプロイします。 アプリを展開する前に、デバイスまたはエミュレーターを使用して、ターゲット ・ スクリプトにアプリを配置するターゲットを作成する必要があります。 配置スクリプトは、アプリの最新のビルドを展開します。

    コルドバ/< プロジェクトへのパス > < ターゲット > を実行します。
    

どこ

*   `<target>`以前に追加したターゲットの名前を指定します。 場合 `<target>` 、デバイスがそのデバイス USB 接続でお使いのコンピューターに接続する必要がありますまたはお使いのコンピューターと同じ Wi-Fi ネットワークに接続されています。

## プラグイン

`target`コマンドの追加し、プラグインを削除することができます

### ローカルでホストされているプラグインをフェッチします。

    < プロジェクトへのパス > コルドバ/プラグイン フェッチ < パス-プラグイン >
    

### インストールされているプラグインの一覧を表示します。

    < プロジェクトへのパス > コルドバ/プラグイン ls
    

### プラグインを追加します。

    < プロジェクトへのパス > < 名前 > を追加/コルドバ/プラグイン
    

### プラグインを削除します。

    < プロジェクトへのパス > コルドバ/プラグイン rm < 名前 >