---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# BlackBerry 10 средства командной строки

`cordova`Утилиты командной строки является высокого уровня инструмент, который позволяет вам создавать приложения сразу на нескольких платформах. Старые версии структуры Cordova предоставляет наборы средств командной строки для каждой платформы. Чтобы использовать их в качестве альтернативы для CLI, вам нужно скачать эту версию Cordova с [cordova.apache.org][1]. Загружаемый файл содержит отдельные архивы для каждой платформы. Разверните узел платформы, которую вы хотите цели. Инструменты, описанные здесь обычно доступны в профиле верхнего уровня `bin` каталог, в противном случае консультироваться с файлом **README** для получения более подробной направлениях.

 [1]: http://cordova.apache.org

Если вам нужна помощь с любой команды, перечисленные ниже, введите команду вместе с `-h` или `-help` аргументы, которые поддерживаются все команды и которые обеспечивают описания для каждого из доступных аргументов.

## создать

`create`Команда создает новый проект:

    bin/создайте < путь к проекта >< пакета проекта >< имя проекта >
    

где

*   `<path-to-project>`Указывает каталог проект, созданный в

*   `<project-package>`Указывает идентификатор стиля обратного домена

*   `<project-name>`Задает отображаемое имя приложения

**Примечание:** `create` команда загружает зависимость установки через `npm install` команды. В зависимости от разрешения системы и каталог установки это может потребовать права администратора. Если есть проблема на OSX/Linux, запустите `sudo npm install` перед использованием `create` команды. В Windows, запустить `npm install` в утилита командной строки, открытой с правами администратора.

## Целевой

`target`Команда позволяет вам управлять эмулятора или устройства BlackBerry, которые используются для тестирования вашего приложения. Можно добавить или удалить целевую папку или задать целевой объект как объект по умолчанию.

### Добавьте целевой объект

    <path-to-project>/cordova/target add <name> <ip-address> [-t | --type <device | simulator>] [-p | --password <password>] [--pin <device-pin>]
    

где

*   `<name>`Указывает уникальное имя для целевого объекта.

*   `<ip-address>`Указывает IP-адрес устройства BlackBerry или симулятор.

*   `-p | --password <password>`Указывает пароль для устройства или эмулятора. Это необходимо, только если устройство или эмулятор защищен паролем.

*   `--pin <device-pin>`Указывает PIN устройства BlackBerry, который идентифицирует устройство как допустимый хост для отладки маркера. Этот аргумент является обязательным, только если вы создаете маркер отладки.

### Удалить целевую папку

    <path-to-project>/cordova/target remove <name>
    

### Задать целевой объект по умолчанию

    <path-to-project>/cordova/target default <name>
    

## построить

`build`Команда строит проект как .bar файл. Вы можете построить ваше приложение в режиме выпуска, (которая производит подписанный .bar файл) или в режиме отладки (которая производит неподписанные .bar файл).

### Создайте свой проект в режиме выпуска

    <path-to-project>/cordova/build release [-k | --keystorepass <password>] [-b | --buildId <number>] [-p | --params <params-JSON-file>]
    

где

*   `-k | --keystorepass <password>`Указывает пароль, который вы определили, когда вы настроили ваш компьютер для подписи приложений.

*   `-b | --buildId <number>`Задает номер версии сборки приложения. Как правило это число должно увеличивается от предыдущей версии подписанных. Этот аргумент является необязательным.

*   `-p | --params <params-JSON-file>`Определяет JSON файл, содержащий дополнительные параметры для передачи вниз по течению инструменты. Этот аргумент является необязательным.

### Создайте свой проект в режиме отладки

    <path-to-project>/cordova/build debug [<target>] [-k | --keystorepass <password>] [-p | --params <params-JSON-file>]  [-ll | --loglevel <error|warn|verbose>]
    

где

*   `<target>`Указывает имя ранее добавленный целевого объекта. Если `<target>` не указан, используется объект по умолчанию, если он был создан. Этот аргумент является только если вы хотите, чтобы скрипт для развертывания вашего приложения на устройстве BlackBerry или эмулятор и вы еще не создали целевой объект по умолчанию. Кроме того если `<target>` – это устройство, то это устройство должно быть подключено к компьютеру с USB-соединения или должен быть подключен к той же сети Wi-Fi, как ваш компьютер.

*   `-k | --keystorepass <password>`Указывает пароль, который вы определили, когда вы настроили ваш компьютер для подписи приложений. Этот пароль используется также для создания маркера отладки. Этот аргумент является только требуется, если вы хотите сценарий для создания и установки отладки маркер для вас.

*   `-p | --params <params-JSON-file>`Определяет JSON файл, содержащий дополнительные параметры для передачи вниз по течению инструменты.

*   `-ll | --loglevel <level>`Задает уровень ведения журнала. Уровень ведения журнала может быть одним из `error` , `warn` , или`verbose`.

Если вы ранее определены цели по умолчанию (и ранее установили маркер отладки, если эта цель является устройством BlackBerry), сценарий можно запустить без аргументов, и сценарий будет упаковать приложение и развернуть его в целевой объект по умолчанию. Например:

    <path-to-project>/cordova/build debug
    

## Запуск

`run`Команда развертывает приложение на указанном BlackBerry устройства или эмулятора. Перед развертыванием приложения, необходимо сначала создать мишенью для устройства или эмулятора, вы хотите развернуть приложение с помощью целевого сценария. Сценарий развертывания будет развертывание последнего построения приложения.

    <path-to-project>/cordova/run <target>
    

где

*   `<target>`Указывает имя ранее добавленный целевого объекта. Если `<target>` – это устройство, то это устройство должно быть подключено к компьютеру с USB-соединения или должен быть подключен к той же сети Wi-Fi, как ваш компьютер.

## плагин

`target`Команда позволяет добавлять и удалять плагины

### Загрузить локально расположенного плагин

    <path-to-project>/cordova/plugin fetch <path-to-plugin>
    

### Просмотреть список установленных плагинов

    <path-to-project>/cordova/plugin ls
    

### Добавить плагин

    <path-to-project>/cordova/plugin add <name>
    

### Удалить плагин

    <path-to-project>/cordova/plugin rm <name>