---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Модернизация BlackBerry

В этом руководстве показано, как изменить BlackBerry проекты для обновления старых версий Cordova. Большинство этих инструкций применимы для проектов, созданных с старого набора средств командной строки, которые предшествуют `cordova` утилиты CLI. Увидеть интерфейс командной строки для информации как обновить версию инфраструктуры CLI.

Пожалуйста, обратите внимание, что CLI исключительно поддерживает платформу BlackBerry10. Для PlayBook и BBOS, смотрите Cordova версии 2.9.0 и ниже.

## Обновление к CLI (3.0.0) с 2.9.0

1.  Создайте новый проект Apache Cordova 3.0.0, используя cordova CLI, как описано в интерфейс командной строки.

2.  Добавить ваши платформы cordova проекта, например:`cordova
platform add blackberry10`.

3.  Скопируйте содержимое исходного проекта `www` каталог `www` директорию в корне проекта cordova, вы только что создали.

4.  Копирование или перезаписать любые родной активы от вашего первоначального проекта ( `Resources` , и т.д.)

5.  Копия вашего `config.xml` в `www` каталог и удалять любые определения, плагин. Необходимо изменить настройки здесь, а не каталог платформы.

6.  Используйте средство CLI cordova для установки плагинов, что вам нужно. Обратите внимание, что CLI обрабатывает все основные API плагинов, так что они могут и должны быть добавлены. Только 3.0.0 плагины совместимы с CLI.

7.  Построение и тестирование.

## Проекты модернизации 2.8.0 2.9.0

Ежевика 10:

1.  Скачайте и распакуйте Cordova 2.9.0 Источник постоянного каталог на жестком диске, например`~/Cordova-2.9.0`.

2.  Закройте все запущенные инструментов SDK: Eclipse, Momentics и тому подобное.

3.  Перейдите в каталог, где вы положили загруженных исходных выше, используя unix как терминал: Terminal.app, Баш, Cygwin и т.д.

4.  Создайте новый проект, как описано в BlackBerry утилиты командной строки. Это становится дома обновленный проект.

5.  Скопируйте ваш источник проектов из старого проекта `/www` каталог нового проекта `/www` каталог.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

### BlackberryOS обеспечение/Playbook

1.  Скачайте и распакуйте Cordova 2.9.0 Источник постоянного каталог на жестком диске, например`~/Cordova-2.9.0`.

2.  Закройте все запущенные инструментов SDK: Eclipse, Momentics и тому подобное.

3.  Перейдите в каталог, где вы положили загруженных исходных выше, используя unix как терминал: Terminal.app, Баш, Cygwin и т.д.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

7.  Копия `native` каталог из нового проекта в существующий проект, перезаписывая старый `native` каталог.

8.  Копия `lib` каталог из нового проекта в существующий проект, перезаписывая старый `lib` каталог.

9.  Копия `cordova` каталог из нового проекта в существующий проект, перезаписывая старый `cordova` каталог.

## Проекты модернизации 2.7.0 2.8.0

Ежевика 10:

BlackBerry 10 использует новый инструмент CLI и управляет основные API как плагины. Инструкции по миграции проекта в новый проект, а не обновление существующего проекта, из-за сложности обновления старого проекта. Также обратите внимание, что cordova js скрипт файл теперь называется «cordova.js» и больше не содержит строку версии.

1.  Скачайте и распакуйте Cordova 2.8.0 Источник постоянного каталог на жестком диске, например`~/Cordova-2.8.0`.

2.  Закройте все запущенные инструментов SDK: Eclipse, Momentics и тому подобное.

3.  Перейдите в каталог, где вы положили загруженных исходных выше, используя unix как терминал: Terminal.app, Баш, Cygwin и т.д.

4.  Создайте новый проект, как описано в BlackBerry утилиты командной строки. Это становится дома обновленный проект.

5.  Скопируйте ваш источник проектов из старого проекта `/www` каталог нового проекта `/www` каталог.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

BlackberryOS обеспечение/пьес:

1.  Скачайте и распакуйте Cordova 2.8.0 Источник постоянного каталог на жестком диске, например`~/Cordova-2.8.0`.

2.  Закройте все запущенные инструментов SDK: Eclipse, Momentics и тому подобное.

3.  Перейдите в каталог, где вы положили загруженных исходных выше, используя unix как терминал: Terminal.app, Баш, Cygwin и т.д.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

7.  Копия `native` каталог из нового проекта в существующий проект, перезаписывая старый `native` каталог.

8.  Копия `lib` каталог из нового проекта в существующий проект, перезаписывая старый `lib` каталог.

9.  Копия `cordova` каталог из нового проекта в существующий проект, перезаписывая старый `cordova` каталог.

## Проекты модернизации 2.6.0 2.7.0

1.  Скачайте и распакуйте Cordova 2.7.0 Источник постоянного каталог на жестком диске, например`~/Cordova-2.7.0`.

2.  Закройте все запущенные инструментов SDK: Eclipse, Momentics и тому подобное.

3.  Перейдите в каталог, где вы положили загруженных исходных выше, используя unix как терминал: Terminal.app, Баш, Cygwin и т.д.

4.  Создайте новый проект, как описано в BlackBerry утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.7.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.6.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.7.0.js` файл.

7.  Копия `native` каталог из нового проекта в существующий проект, перезаписывая старый `native` каталог.

8.  Копия `lib` каталог из нового проекта в существующий проект, перезаписывая старый `lib` каталог.

9.  Копия `cordova` каталог из нового проекта в существующий проект, перезаписывая старый `cordova` каталог.

## Обновление до 2.6.0 с 2.5.0

Обновления в каталог загрузки PhoneGap:

Рекомендуется, что вы скачать свежую копию всего каталога.

Однако вот новые детали, необходимые для частичного обновления:

1.  Обновить файл cordova.blackberry.js в `Phonegap-2.6.0/lib/blackberry/javascript` каталог.

2.  Обновление `ext` , `ext-air` , и `ext-qnx` в `Phonegap-2.6.0/lib/blackberry/framework` каталог.

3.  Обновление `build.xml` файл в `Phonegap-2.6.0/lib/blackberry` каталог.

4.  Обновление `Phonegap-2.6.0/lib/blackberry/bin` каталог.

5.  Обновление `VERSION` файл в `Phonegap-2.6.0/lib/blackberry` каталог.

Обновление в примере / каталог или перенос существующего проекта:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Обновить содержимое `ext-qnx/` каталог.

5.  Скопируйте новый `cordova-2.6.0.js` в ваш проект.

6.  Обновить ваш HTML, чтобы использовать новый `cordova-2.6.0.js` файл.

## Обновление до 2.5.0 с 2.4.0

Обновления в каталог загрузки PhoneGap:

Рекомендуется, что вы скачать свежую копию всего каталога.

Однако вот новые детали, необходимые для частичного обновления:

1.  Обновить файл cordova.blackberry.js в `Phonegap-2.5.0/lib/blackberry/javascript` каталог.

2.  Обновление `ext` , `ext-air` , и `ext-qnx` в `Phonegap-2.5.0/lib/blackberry/framework` каталог.

3.  Обновление `build.xml` файл в `Phonegap-2.5.0/lib/blackberry` каталог.

4.  Обновление `Phonegap-2.5.0/lib/blackberry/bin` каталог.

5.  Обновление `VERSION` файл в `Phonegap-2.5.0/lib/blackberry` каталог.

Обновление в примере / каталог или перенос существующего проекта:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Обновить содержимое `ext-qnx/` каталог.

5.  Скопируйте новый `cordova-2.5.0.js` в ваш проект.

6.  Обновить ваш HTML, чтобы использовать новый `cordova-2.5.0.js` файл.

## Обновление 2.4.0 с 2.3.0

Обновление только `www` каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-2.4.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.
    *   Если BlackBerry 10, затем обновить файл JS в `qnx/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-2.4.0.js` файл.

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.2.3.0/ext/` каталог.

3.  Обновить содержимое `cordova.2.3.0/ext-air/` каталог.

4.  Обновить содержимое `cordova.2.3.0/ext-qnx/` каталог.

5.  Обновить файл .js в `cordova.2.3.0/javascript/` каталог.

6.  Открытые `sample/lib/` каталог и переименовать `cordova.2.3.0/` Каталог`cordova.2.4.0/`.

7.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

8.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-2.4.0.js` файл.

## Обновления 2.3.0 из 2.2.0

Обновление только `www` каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-2.3.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.
    *   Если BlackBerry 10, затем обновить файл JS в `qnx/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-2.3.0.js` файл.

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.2.2.0/ext/` каталог.

3.  Обновить содержимое `cordova.2.2.0/ext-air/` каталог.

4.  Обновить содержимое `cordova.2.2.0/ext-qnx/` каталог.

5.  Обновить файл .js в `cordova.2.2.0/javascript/` каталог.

6.  Открытые `sample/lib/` каталог и переименовать `cordova.2.2.0/` Каталог`cordova.2.3.0/`.

7.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

8.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-2.3.0.js` файл.

## Обновление до 2.2.0 из 2.1.0

Обновление только www каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-2.2.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.
    *   Если BlackBerry 10, затем обновить файл JS в `qnx/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-2.2.0.js` файл.

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.2.1.0/ext/` каталог.

3.  Обновить содержимое `cordova.2.1.0/ext-air/` каталог.

4.  Обновить содержимое `cordova.2.1.0/ext-qnx/` каталог.

5.  Обновить файл .js в `cordova.2.1.0/javascript/` каталог.

6.  Открытые `sample/lib/` каталог и переименовать `cordova.2.1.0/` Каталог`cordova.2.2.0/`.

7.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

8.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-2.2.0.js` файл.

## Обновление 2.1.0 от 2.0.0

Обновление только `www` каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-2.1.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-2.1.0.js` файл.

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.2.0.0/ext/` каталог.

3.  Обновить содержимое `cordova.2.0.0/ext-air/` каталог.

4.  Обновить файл .js в `cordova.2.0.0/javascript/` каталог.

5.  Открытые `sample/lib/` каталог и переименовать `cordova.2.0.0/` Каталог`cordova.2.1.0/`.

6.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

7.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-2.1.0.js` файл.

## Обновление до 2.0.0 от 1.9.0

Обновление только `www` каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-2.0.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-2.0.0.js` файл.

6.  Обновление вашего `www/plugins.xml` файл. Два плагины изменил их лейблом служба имен. Измените старые записи для захвата и контакт плагины от:
    
        <plugin name="Capture" value="org.apache.cordova.media.MediaCapture"/>
        <plugin name="Contact" value="org.apache.cordova.pim.Contact"/>
        
    
    Кому:
    
        <plugin name="Capture" value="org.apache.cordova.capture.MediaCapture"/>
        <plugin name="Contacts" value="org.apache.cordova.pim.Contact"/>
        

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.1.9.0/ext/` каталог.

3.  Обновить содержимое `cordova.1.9.0/ext-air/` каталог.

4.  Обновить файл .js в `cordova.1.9.0/javascript/` каталог.

5.  Открытые `sample/lib/` каталог и переименовать `cordova.1.9.0/` Каталог`cordova.2.0.0/`.

6.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

7.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-2.0.0.js` файл.

8.  Открытые `www/` каталог и обновление `plugins.xml` файл. Два плагины изменил их лейблом служба имен. Измените старые записи для захвата и контакт плагины от:
    
         <plugin name="Capture" value="org.apache.cordova.media.MediaCapture"/>
         <plugin name="Contact" value="org.apache.cordova.pim.Contact"/>
        
    
    Кому:
    
         <plugin name="Capture" value="org.apache.cordova.capture.MediaCapture"/>
         <plugin name="Contacts" value="org.apache.cordova.pim.Contact"/>
        

*   Чтобы обновить до 1.8.0, пожалуйста идет от 1.7.0

## Обновление до 1.8.0 от 1.7.0

Обновление только `www` каталога:

1.  Открыть ваш `www/` каталог, который содержит приложение.

2.  Удалить и обновить файл .jar в `ext/` каталог.

3.  Обновить содержимое `ext-air/` каталог.

4.  Скопируйте новый `cordova-1.8.0.js` в ваш проект.
    
    *   Если пьес, а затем обновление .js файл в `playbook/` каталог.

5.  Обновить ваш HTML, чтобы использовать новый `cordova-1.8.0.js` файл.

6.  Обновление вашего `www/plugins.xml` файл. Два плагины изменил их лейблом служба имен. Измените старые записи для захвата и контакт плагины от:
    
        <plugin name="Capture" value="org.apache.cordova.media.MediaCapture"/>
        <plugin name="Contact" value="org.apache.cordova.pim.Contact"/>
        
    
    Кому:
    
        <plugin name="Capture" value="org.apache.cordova.capture.MediaCapture"/>
        <plugin name="Contacts" value="org.apache.cordova.pim.Contact"/>
        

Обновление каталога образцов (например, обновления через инструменты муравей):

1.  Открытые `sample/lib/` каталог.

2.  Обновление файла .jar в `cordova.1.7.0/ext/` каталог.

3.  Обновить содержимое `cordova.1.7.0/ext-air/` каталог.

4.  Обновить файл .js в `cordova.1.7.0/javascript/` каталог.

5.  Открытые `sample/lib/` каталог и переименовать `cordova.1.7.0/` Каталог`cordova.1.8.0/`.

6.  Тип `ant blackberry build` или `ant playbook build` для обновления `www/` каталог с обновленный Cordova.

7.  Открытые `www/` каталог и обновить ваш HTML, чтобы использовать новый `cordova-1.8.0.js` файл.

8.  Открытые `www/` каталог и обновление `plugins.xml` файл. Два плагины изменил их лейблом служба имен. Измените старые записи для захвата и контакт плагины от:
    
         <plugin name="Capture" value="org.apache.cordova.media.MediaCapture"/>
         <plugin name="Contact" value="org.apache.cordova.pim.Contact"/>
        
    
    Кому:
    
         <plugin name="Capture" value="org.apache.cordova.capture.MediaCapture"/>
         <plugin name="Contacts" value="org.apache.cordova.pim.Contact"/>