/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Threading;

/*
 * Blatanly stolen from
 * http://www.yoda.arachsys.com/csharp/threads/threadpool.shtml
 */
namespace Cowbell.Base
{
	public class Dispatcher
	{
		/**
		 * Delegate to wrap another delegate and its arguments
		 */
		public delegate void DelegateWrapper (Delegate d, object[] args);

		/**
		 * An instance of DelegateWrapper which calls InvokeWrappedDelegate,
		 * which in turn calls the DynamicInvoke method of the wrapped
		 * delegate.
		 */
		public static DelegateWrapper wrapperInstance = new DelegateWrapper (InvokeWrappedDelegate);
		    
		/**
		 * Callback used to call EndInvoke on the asynchronously
		 * invoked DelegateWrapper.
		 */
		static AsyncCallback callback = new AsyncCallback (EndWrapperInvoke);

		/**
		 * Executes the specified delegate with the specified arguments
		 * asynchronously on a thread pool thread.
		 */
		public static void FireAndForget (Delegate d, params object[] args)
		{
			/*
			 * Invoke the wrapper asynchronously, which will then execute the
			 * wrapped delegate synchronously (in the thread pool thread)
			 */
			wrapperInstance.BeginInvoke (d, args, callback, null);
		}
		
		public static void FireWithCallback (Delegate d, AsyncCallback c, params object[] args)
		{
			wrapperInstance.BeginInvoke (d, args, c, null);
		}

		/**
		 * Invokes the wrapped delegate synchronously
		 */
		static void InvokeWrappedDelegate (Delegate d, object[] args)
		{
			d.DynamicInvoke (args);
		}

		/**
		 * Calls EndInvoke on the wrapper to prevent resource leaks.
		 */
		static void EndWrapperInvoke (IAsyncResult ar)
		{
			wrapperInstance.EndInvoke (ar);
		}
	}
}
