/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using Gtk;
using System;
using Cowbell.Base;

namespace Cowbell.Gui
{
	public class SaveChangesDialog : GladeWindow
	{
		/* public methods */
		public SaveChangesDialog () : this (Runtime.MainWindow.Window)
		{
		}

		public SaveChangesDialog (Window p) : base ("SaveChangesDialog.glade", "window")
		{
			parent = p;
			window.TransientFor = parent;	

			label.Markup = Catalog.GetString ("<span weight='bold' size='large'>"
			                                  + "Save changes before closing?</span>\n\n"
			                                  + "If you don't save, all changes you made "
			                                  + "will be lost.");		
		}

		public SaveChangesDialog (string album) : this (Runtime.MainWindow.Window, album)
		{
		}

		public SaveChangesDialog (Window p, string album) : base ("SaveChangesDialog.glade", "window")
		{
			parent = p;
			window.TransientFor = parent;	

			label.Markup = String.Format (Catalog.GetString ("<span weight='bold' size='large'>"
			                                                 + "Save changes to the album "
			                                                 + "\"{0}\" before closing?</span>\n\n"
			                                                 + "If you don't save, all changes you made "
			                                                 + "will be lost."),
			                              GLib.Markup.EscapeText (album));		
		}

		public int Run ()
		{
			return window.Run ();
		}

		public void Hide ()
		{
			window.Hide ();
		}

		/* private fields */
		[Glade.Widget] Dialog window; 
		[Glade.Widget] Label label; 

		Window parent;
	}
}
