#!/usr/bin/perl -pi
#
# tocn.pl, a Perl script for translating computer terms from
#          zh_HK/zh_TW -> zh_CN, customized for CPanel.
# Copyright 2000 Anthony Fok <foka@debian.org>
# This is free software; see the source for copying conditions. There is NO
# warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# Note: This script uses GB2312-encoded Chinese characters.

# ȰȫתΪš
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);

# ȻʵĴѡšתء
#	ߡء
#	
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*(?:|||))/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)(?=|||||)/$1/);

s/׼//g;
s/(?:|)(?:|Ƭ)//g;
s///g;
s/(?:Ԯ|)(?:|Ƭ)//g;
s/ȫѶ/ά/g;
s/(|·)//g;
s/ʹ/û/g;
s/ü/û/g;
s/ԭʼ(ʽ)?/Դ/g;
s/ԭʽ/Դ/g;
s/ӳվ(̨)?//g;

1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)(?<!)׼/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ģ/$1ģ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)֧Ԯ/$1֧/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*(|Ӳ))/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*(|Ӳ|||Zip ))/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)̫(?=)/$1̫/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)բ/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)վ̨/$1վ/);

# file vs. doc
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ļ/$1ĵ/);
s/޲/ļ/g;
s/()?ֵ()?/ıļ/g;
s/Ա/ļ/g;
s/ϵͳ/ļϵͳ/g;
s/趨(?:)?/ļ/g;
s//ļ/g;
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)()?/$1ļ/);

1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ָ/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1¼/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);

1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)Ѷ/$1Ϣ/);

1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)өĻ/$1Ļ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)α/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);

1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)(?=|ϵ)/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)·/$1/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ƻ/$1ƻ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)͸/$1ͨ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)Ԥ/$1ȱʡ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ӡ/$1ӡ/);

s/ʽ//g;
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)ʽԱ/$1ʦ/);
1 while (s/^((?:[\x00-\x7F]|[\x80-\xFF].)*)(?<!)ʽ/$1/);

s/̳ͨ/ʼб/g;
s/鱨/Ϣ/g;
s/ҵϵͳ/ϵͳ/g;
s/Ӵϵͳ/ϵͳ/g;
s/ӴԱ/ڹ/g;
s/ŷ//g;
s/(?=ģʽ|༭|)/ı/g;
s/(?:|ӡ)/ӡ/g;
s//ڴ/g;
s/Ԫʾ/ʾ/g;
s/ʽ//g;
s/Ͽ/ݿ/g;
