/* $Id: visir_spc_optmod.h,v 1.13 2007/03/12 09:58:51 llundin Exp $
 *
 * This file is part of the VISIR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: llundin $
 * $Date: 2007/03/12 09:58:51 $
 * $Revision: 1.13 $
 * $Name: visir-3_5_1 $
 */

#ifndef VISIR_SPC_OPTMOD_H
#define VISIR_SPC_OPTMOD_H

/*-----------------------------------------------------------------------------
                                Defines
 -----------------------------------------------------------------------------*/

/* The size of the VISIR Optical Model object */
#define VISIR_SPC_OPTMOD_SIZEOF (4*sizeof(int) + 14 * sizeof(double))

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

enum visir_spc_resol_ {
    VISIR_SPC_R_ERR = 0,
    VISIR_SPC_R_LR,
    VISIR_SPC_R_MR,
    VISIR_SPC_R_HR,
    VISIR_SPC_R_GHR
};

typedef enum visir_spc_resol_ visir_spc_resol;

struct visir_optmod_ {
    /* For this struct only the size is public */
    /* The first member ensures proper alignment of this and its
       corresponding private struct, the second member ensures that
       the two structs have identical sizes */

    /* Any access to the below two members leads to undefined behaviour! */

    double ensure_alignment;
    char contents[VISIR_SPC_OPTMOD_SIZEOF - sizeof(double)];
};

typedef struct visir_optmod_ visir_optmod;

#undef VISIR_SPC_OPTMOD_SIZEOF

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

int    visir_spc_optmod_init(visir_spc_resol, double, visir_optmod *);
double visir_spc_optmod_wlen(const visir_optmod *, double *, double *);
double visir_spc_optmod_cross_dispersion(const visir_optmod *, double);
double visir_spc_optmod_echelle(const visir_optmod *, double, int);
double visir_spc_optmod_resolution(const visir_optmod *);
double visir_spc_optmod_dispersion(const visir_optmod *);
int    visir_spc_optmod_side_is_A(const visir_optmod *);
int    visir_spc_optmod_get_echelle_order(const visir_optmod *);

#endif
