/* $Id: visir_spc_photom.h,v 1.18 2009/03/05 16:07:27 llundin Exp $
 *
 * This file is part of the VISIR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: llundin $
 * $Date: 2009/03/05 16:07:27 $
 * $Revision: 1.18 $
 * $Name: visir-3_5_1 $
 */

#ifndef VISIR_SPC_PHOTOM_H
#define VISIR_SPC_PHOTOM_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#include "visir_spectro.h"
#include "visir_pfits.h"
#include "visir_utils.h"

/*-----------------------------------------------------------------------------
                            Static variables
 -----------------------------------------------------------------------------*/

/* FIXME: Add checks against undefined usage of optional parameters */
struct visir_spc_phot_config_ {
    /* Inputs */
    int         plot;
    double      phi;
    double      ksi;
    double      eps;
    double      delta;
    double      emis_tol;

    int         orderoffset;
    cpl_boolean do_fixcombi;

};

typedef struct visir_spc_phot_config_ visir_spc_phot_config;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

cpl_table * visir_spc_phot_sensit(cpl_image **, const irplib_framelist *,
                                  const char *,
                                  const cpl_parameterlist *,
                                  const visir_spc_phot_config *, const char *,
                                  const char *, const char *, cpl_image **,
                                  cpl_propertylist * qclist,
                                  cpl_boolean, double , double, double, double,
                                  const visir_spc_resol);

#endif
