/* $Id: visir_spectro.h,v 1.65 2009/03/06 13:42:03 llundin Exp $
 *
 * This file is part of the VISIR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: llundin $
 * $Date: 2009/03/06 13:42:03 $
 * $Revision: 1.65 $
 * $Name: visir-3_5_1 $
 */

#ifndef VISIR_SPECTRO_H
#define VISIR_SPECTRO_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#include "irplib_framelist.h"
#include "visir_spc_optmod.h"

visir_spc_resol visir_spc_get_res_wl(const irplib_framelist *, double *,
                                     double *, double *, double *);
cpl_error_code visir_vector_resample(cpl_vector *, const cpl_vector *,
                                        const cpl_bivector *);
cpl_error_code visir_spc_extract_wcal(const cpl_image *, const cpl_image *,
                                      double, double, double, double,
                                      visir_spc_resol, int,
                                      const char*, const char *,
                                      cpl_table **,
                                      cpl_image **,
                                      cpl_propertylist *, int);

cpl_error_code visir_spc_wavecal(const cpl_image *,
                                 cpl_propertylist *,
                                 double, double, double,
                                 double, visir_spc_resol, int, const char *,
                                 const char *,
                                 cpl_table **, int);

cpl_error_code visir_spectro_qc(cpl_propertylist *, cpl_propertylist *,
                                cpl_boolean, const irplib_framelist *,
                                const char *, const char *);

cpl_error_code visir_spc_echelle_limit(int *, int *, double, int, int, int);
cpl_image * visir_spc_column_extract(const cpl_image *, int, int, int);

#endif
