/* $Id: visir_utils.h,v 1.77 2012/02/02 10:25:41 jtaylor Exp $
 *
 * This file is part of the VISIR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2012/02/02 10:25:41 $
 * $Revision: 1.77 $
 * $Name: visir-3_5_1 $
 */

#ifndef VISIR_UTILS_H
#define VISIR_UTILS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#include "irplib_utils.h"
#include "irplib_tools.h"

#include "irplib_plugin.h"

#include "visir_spectro.h"

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#ifndef VISIR_STAR_MAX_RADIUS
   /* 2 arcminutes in degrees */
#  define VISIR_STAR_MAX_RADIUS (2.0/60.0)
#endif

/* Plotting errors will be ignored */
#define visir_vector_plot(ARG1, ARG2, ARG3, ARG4)                       \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_vector(ARG1, ARG2, ARG3, ARG4))                    \
            irplib_error_recover(prestate, "Could not plot vector");    \
    } while (0)

#define visir_bivector_plot(ARG1, ARG2, ARG3, ARG4)                     \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_bivector(ARG1, ARG2, ARG3, ARG4))                  \
            irplib_error_recover(prestate, "Could not plot bivector");  \
    } while (0)

#define visir_table_plot(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6)            \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_column(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6))        \
            irplib_error_recover(prestate, "Could not plot table");     \
    } while (0)

#define visir_image_plot(ARG1, ARG2, ARG3, ARG4)                        \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_image(ARG1, ARG2, ARG3, ARG4))                     \
            irplib_error_recover(prestate, "Could not plot image");     \
    } while (0)

#define visir_image_col_plot(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7)  \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_image_col(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7)) \
            irplib_error_recover(prestate, "Could not plot image columns"); \
    } while (0)

#define visir_image_row_plot(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7)  \
    do {                                                                \
        cpl_errorstate prestate = cpl_errorstate_get();                 \
        if (cpl_plot_image_row(ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7)) \
            irplib_error_recover(prestate, "Could not plot image raws"); \
    } while (0)


#define visir_error_set(ERRCODE) cpl_error_set(cpl_func, ERRCODE)

/* FIXME: Copy to visir_error_reset() */
#define visir_error_reset(...)                                                \
 irplib_error_recover(cleanstate, __VA_ARGS__)

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

double * visir_utils_get_wls(const irplib_framelist *);
cpl_image * visir_create_disk_intimage(int, int, int, int, int);
cpl_image * visir_create_ring_intimage(int, int, int, int, int, int);
double visir_image_sigma_clip(const cpl_image *, double *);
double visir_img_phot_sigma_clip(const cpl_image *);
cpl_error_code visir_get_subpixel_maxpos(const cpl_image *,
                                         cpl_size, cpl_size,
                                         double *, double *);
cpl_error_code visir_fftxcorrelate(const cpl_image *, const cpl_image *,
                                   cpl_boolean, double *, double *);

int visir_star_find(const cpl_vector *, const cpl_vector *, double, double,
                    double, double *);

cpl_error_code visir_star_convert(const char *, int, int, double, char, int,
                                  int, double, const double *, int, double *,
                                  double *);

double visir_star_dist_min(const double *, const double *, int, int *, int *);

cpl_table * visir_table_new_xypos(const cpl_imagelist * images, const char *);

int visir_vector_minpos(const cpl_vector *);

cpl_error_code visir_bivector_load(cpl_bivector *, FILE *);

const char ** visir_framelist_set_tag(irplib_framelist *,
                                      char * (*)(const cpl_frame *,
                                                 const cpl_propertylist *, int),
                                      int *);

cpl_error_code visir_qc_append_background(cpl_propertylist *,
                                          const irplib_framelist *, int, int);

cpl_error_code visir_qc_append_capa(cpl_propertylist *,
                                    const irplib_framelist *);

cpl_error_code visir_qc_append_filter(cpl_propertylist *,
                                      const irplib_framelist *);
cpl_error_code visir_qc_append_exptime(cpl_propertylist *,
                                       const irplib_framelist *);
#endif
