/* $Id: cpl_imagelist_basic_body.h,v 1.35 2010/11/11 09:23:18 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* Type dependent macros */
#if defined CPL_CLASS && CPL_CLASS == CPL_CLASS_DOUBLE
#define CPL_TYPE double
#define CPL_TYPE_T CPL_TYPE_DOUBLE
#define CPL_IMAGE_GET_DATA cpl_image_get_data_double
#define CPL_IMAGE_GET_DATA_CONST cpl_image_get_data_double_const
#define CPL_IMAGE_WRAP cpl_image_wrap_double
#define CPL_IMAGE_GET_MEDIAN cpl_tools_get_median_double
#define CPL_TOOLS_GET_KTH cpl_tools_get_kth_double

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_FLOAT
#define CPL_TYPE float
#define CPL_TYPE_T CPL_TYPE_FLOAT
#define CPL_IMAGE_GET_DATA cpl_image_get_data_float
#define CPL_IMAGE_GET_DATA_CONST cpl_image_get_data_float_const
#define CPL_IMAGE_WRAP cpl_image_wrap_float
#define CPL_IMAGE_GET_MEDIAN cpl_tools_get_median_float
#define CPL_TOOLS_GET_KTH cpl_tools_get_kth_float

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_INT
#define CPL_TYPE int
#define CPL_TYPE_T CPL_TYPE_INT
#define CPL_IMAGE_GET_DATA cpl_image_get_data_int
#define CPL_IMAGE_GET_DATA_CONST cpl_image_get_data_int_const
#define CPL_IMAGE_WRAP cpl_image_wrap_int
#define CPL_IMAGE_GET_MEDIAN cpl_tools_get_median_int
#define CPL_TOOLS_GET_KTH cpl_tools_get_kth_int

#else
#undef CPL_TYPE
#undef CPL_TYPE_T
#undef CPL_IMAGE_GET_DATA
#undef CPL_IMAGE_GET_DATA_CONST
#undef CPL_IMAGE_WRAP
#undef CPL_IMAGE_GET_MEDIAN
#undef CPL_TOOLS_GET_KTH
#endif

#if CPL_OPERATION == CPL_IMLIST_BASIC_OPER

    int i ;

    /* Check input image sets */
    cpl_ensure_code(in1, CPL_ERROR_NULL_INPUT);
    cpl_ensure_code(in2, CPL_ERROR_NULL_INPUT) ;

    /* Check image sets compatibility     */
    cpl_ensure_code( in1->ni == in2->ni, CPL_ERROR_ILLEGAL_INPUT);

    /* Loop on the planes and apply the operation */
    for (i=0 ; i<in1->ni ; i++) {
        const cpl_error_code error = 
            CPL_OPERATOR(in1->images[i], in2->images[i]);
        cpl_ensure_code(!error, error);
    }

    return CPL_ERROR_NONE ;

#elif CPL_OPERATION == CPL_IMLIST_BASIC_IMAGE_LOCAL

    int i ;

    /* Check input image sets */
    cpl_ensure_code(imlist, CPL_ERROR_NULL_INPUT);
    cpl_ensure_code(img,    CPL_ERROR_NULL_INPUT) ;

    /* Loop on the planes and apply the operation */
    for (i=0 ; i<imlist->ni ; i++) {
        const cpl_error_code error = CPL_OPERATOR(imlist->images[i], img);
        cpl_ensure_code(!error, error);
    }

    return CPL_ERROR_NONE ;

#elif CPL_OPERATION == CPL_IMLIST_BASIC_TIME_MEDIAN
#ifndef L2_CACHE_BYTES
#ifdef CPL_CPU_CACHE
#define L2_CACHE_BYTES CPL_CPU_CACHE
#else
/* The size in bytes of the cache level, with most importance 
   (probably related to size times penalty for a miss) */
/* FIXME: Assume 256kB (L2) Cache. Many CPUs have more (e.g. 512kB),
          but the performance on those does not seem to suffer much */
#define L2_CACHE_BYTES 262144
#endif
#endif
    case CPL_TYPE_T:
    {
        const int nz = imlist->ni;
        CPL_TYPE ** pi = cpl_malloc(nz * sizeof(CPL_TYPE*));
        CPL_TYPE *  po = CPL_IMAGE_GET_DATA(median);
        CPL_TYPE *  timeline = NULL;

        for (k=0; k < nz; k++)
            pi[k] = CPL_IMAGE_GET_DATA(imlist->images[k]);

#if L2_CACHE_BYTES > 0
        if (L2_CACHE_BYTES > 0 &&
            sizeof(CPL_TYPE) * nz * (1 + nx * ny) > L2_CACHE_BYTES) {
            /* There is a cache available, and the entire imagelist does not
               fit inside it */

            /* Heuristics: When there are just a few planes, remapping does not
               pay off. It seems that break-even is at nz = nx / 15. */
            const int max_aspect = 15;

            /* The largest number of pixels that can be handled by the cache */
            const int mxl2 = (L2_CACHE_BYTES - sizeof(CPL_TYPE *) * nz)
                / (sizeof(CPL_TYPE) * (1 + 2 * nz));
            const int mxmax = mxl2 < nz * max_aspect ? mxl2 : nz * max_aspect;
            int mx = nx;
            int my = ny;


            while ((mx & 1) == 0 && mx > mxmax) {
                /* Make mx smaller, until it fits */
                mx >>= 1;
                my <<= 1;
            }

            if (mx == nx ) {
                /* Did not yet change mx, try to make it larger while it fits */
                while ((mx<<1) < mxmax && (my & 1) == 0) {
                    mx <<=1;
                    my >>=1;
                }
            }


            if (sizeof(CPL_TYPE *) * nz + sizeof(CPL_TYPE) * mx * (1 + 2 * nz)
              > L2_CACHE_BYTES/2) {
                /* Heuristics: Too few planes may cause only a fraction of the
                   cache to be usable, in this case fall back on the simple
                   method. It seems that the break-even is about 50% cache
                   usage */
                timeline = cpl_malloc(mx * nz * sizeof(CPL_TYPE));

                /* For each time line */
                for (j=0; j < my; j++) {
                    /* Get the pixels on the current time line  */
                    for (k=0; k < nz; k++)
                        for (i=0; i < mx; i++)
                            timeline[k + i * nz] = pi[k][i + j * mx];

                    for (i=0; i < mx; i++)
                        /* Compute the median */
                        po[i + j * mx] = CPL_IMAGE_GET_MEDIAN(timeline + i * nz,
                                                              nz);
                }
            }
        }
#endif
        if (timeline == NULL)  {
            /* Remap one pixel at a time */
            timeline = cpl_malloc(nz * sizeof(CPL_TYPE));
            /* For each time line */
            for (i=0; i < nx * ny; i++) {
                /* Get the pixels on the current time line  */
                for (k=0; k < nz; k++)
                    timeline[k] = pi[k][i];

                /* Compute the median */
                po[i] = CPL_IMAGE_GET_MEDIAN(timeline, nz);
            }
        }

        cpl_free(pi);
        cpl_free(timeline);
        break;
    }

#elif CPL_OPERATION == CPL_IMLIST_BASIC_TIME_MINMAX

    case CPL_TYPE_T:
    {
        /* Pointers to the ni pixel buffers */
        const CPL_TYPE ** pin = cpl_malloc((size_t)ni * sizeof(CPL_TYPE *));

        /* Output pixel buffer */
        CPL_TYPE       *  pavg
            = cpl_malloc((size_t)nx * (size_t)ny * sizeof(*pavg));

        /* A single timeline */
        CPL_TYPE       *  ptime = cpl_malloc((size_t)ni * sizeof(*ptime));
        int i, k;


        for (k = 0; k < ni; k++) {
            pin[k] = CPL_IMAGE_GET_DATA_CONST(cpl_imagelist_get_const(self, k));
        }

        /* Loop on the pixels */
        for (i = 0; i < nx * ny; i++) {
            double mean = 0.0;

            /* Fill the timeline */
            for (k = 0; k < ni; k++) {
                ptime[k] = pin[k][i];
            }

            /* Place nlow and nhigh samples at the ends */
            if (nlow  > 0) (void)CPL_TOOLS_GET_KTH(ptime, ni, nlow-1);
            if (nhigh > 0) (void)CPL_TOOLS_GET_KTH(ptime + nlow, ni-nlow, nuse);

            /* Compute the average */
            /* - using the recurrence relation from cpl_vector_get_mean() */
            for (k = 0; k < nuse; k++)
                mean += ((double)ptime[nlow + k] - mean) / (k + 1);

            pavg[i] = (CPL_TYPE)mean;
        }

        cpl_free(pin);
        cpl_free(ptime);

        avg = CPL_IMAGE_WRAP(nx, ny, pavg);

        cpl_tools_add_flops(3 * nx * ny * nuse);

        break;
    }

#elif CPL_OPERATION == CPL_IMLIST_BASIC_TIME_SIGCLIP

    case CPL_TYPE_T:
    {
        CPL_TYPE       * pout_ima;
        const CPL_TYPE * pcur_ima;
        int              i, j, k; 
     
    cpl_vector      *   time_line ;
    double          *   ptime_line ;

        out_ima  = cpl_image_new(nx, ny, CPL_TYPE_T);
        pout_ima = CPL_IMAGE_GET_DATA(out_ima);

    /* Create the vector */
    time_line  = cpl_vector_new(ni);
    ptime_line = cpl_vector_get_data(time_line);

        /* Loop on the pixels */
        for (j = 0; j < ny; j++) {
            for (i = 0; i < nx; i++) {
        double center, stdev ;
        double low_thresh, high_thresh ;
        int    nb_val = ni ;
        int    old_nb_val = nb_val + 1; /* Only for the purpose of
                           meeting the condition of
                           the while the 1. time */

        cpl_vector *  itimeline;
        double     * pitimeline;
        double mean = 0.0;
        
                /* Fill the vector */
                for (k = 0 ; k < ni ; k++) {
                    cur_ima = cpl_imagelist_get_const(imlist, k);
                    pcur_ima = CPL_IMAGE_GET_DATA_CONST(cur_ima);
                    ptime_line[k] = (double)pcur_ima[i + j * nx];
                }

        itimeline  = cpl_vector_duplicate(time_line);
        pitimeline = cpl_vector_get_data(itimeline);

        /* FIXME: Ensure that we always get inside this while loop */
        while ((double)nb_val / (double)ni > keep &&
               nb_val < old_nb_val) {
            int * rejected = cpl_calloc(sizeof(int), nb_val);
            int nrejected = 0;

                    double median;

            mean    = cpl_vector_get_mean(itimeline);
            median  = cpl_vector_get_median(itimeline);

            /* Get the mean and stdev */
            center  = mode & CPL_COLLAPSE_MEAN ? mean : median;
            stdev   = cpl_vector_get_stdev(itimeline);

            low_thresh  = center - kappalow  * stdev;
            high_thresh = center + kappahigh * stdev;

            for (k = 0; k < nb_val; k++) {
            if (pitimeline[k] > high_thresh && 
                pitimeline[k] < low_thresh) {
                rejected[k] = -1;
                nrejected++;
            } 
            }

            k = 0;
            while (k < nb_val) {
            if (rejected[k] < 0)
                pitimeline[k] = pitimeline[k + 1];
            else
                k++;
            }

            old_nb_val = nb_val;
            nb_val -= nrejected;
            cpl_vector_set_size(itimeline, nb_val);

            cpl_free(rejected);

            if (nb_val <= 2) break;
        }

                /* Set the output image pixel value */
                pout_ima[i + j * nx] = (CPL_TYPE)mean;

        if (kept) 
            pkept[i + j * nx] = old_nb_val;

        cpl_vector_delete(itimeline);
            }
        }

    cpl_vector_delete(time_line);

        break ;
    }

#elif CPL_OPERATION == CPL_IMLIST_BASIC_SWAP_AXIS 

    case CPL_TYPE_T:
    {
        CPL_TYPE       * pcur_ima ;
        const CPL_TYPE * pold_ima ;

        /* SWAP X <-> Z */
        if (mode == CPL_SWAP_AXIS_XZ) {
            for (i=0 ; i<nx ; i++) {
                cur_ima=cpl_image_new(ni, ny, CPL_TYPE_T) ;
                pcur_ima = CPL_IMAGE_GET_DATA(cur_ima) ;
                for (j=0 ; j<ni ; j++) {
                    old_ima = cpl_imagelist_get_const(ilist, j) ;
                    pold_ima = CPL_IMAGE_GET_DATA_CONST(old_ima) ;
                    for (k=0 ; k<ny ; k++) {
                        pcur_ima[j+k*ni] = pold_ima[i+k*nx] ;
                    }
                }
                cpl_imagelist_set(swapped, cur_ima, i) ;
            }
        } else {
        /* SWAP Y <-> Z */
            for (i=0 ; i<ny ; i++) {
                cur_ima=cpl_image_new(nx, ni, CPL_TYPE_T) ;
                pcur_ima = CPL_IMAGE_GET_DATA(cur_ima) ;
                for (j=0 ; j<ni ; j++) {
                    old_ima = cpl_imagelist_get_const(ilist, j) ;
                    pold_ima = CPL_IMAGE_GET_DATA_CONST(old_ima) ;
                    for (k=0 ; k<nx ; k++) {
                        pcur_ima[k+j*nx] = pold_ima[k+i*nx] ;
                    }
                }
                cpl_imagelist_set(swapped, cur_ima, i) ;
            }
        }
        break ;
    }

#endif

#undef CPL_TYPE
#undef CPL_TYPE_T
#undef CPL_IMAGE_GET_DATA
#undef CPL_IMAGE_GET_DATA_CONST
#undef CPL_IMAGE_WRAP
#undef CPL_IMAGE_GET_MEDIAN
#undef CPL_TOOLS_GET_KTH
