// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// event.h
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_EVENT_H
#define _INCLUDE_EVENT_H

#include "SDL.h"

#include "game.h"
#include "textbox.h"

class Event : public Node {
public:
  Event( SDL_RWops *file, Player **players );
  int Save( SDL_RWops *file ) const;

  short Check( void );
  void Execute( class MessageWindow *msgwin );

  unsigned char ID( void ) const { return e_id; }

private:
  bool Disabled( void ) const { return (e_flags & EFLAG_DISABLED) != 0; }
  void SetFlags( unsigned short flags ) { e_flags |= flags; }
  void UnsetFlags( unsigned short flags ) { e_flags &= (~flags); }
  void ToggleFlags( unsigned short flags ) { e_flags ^= flags; }

  void DisplayMessage( class MessageWindow *win, const char *title,
                       const char *body ) const;

  short CheckTrigger( void );
  bool CheckDependencies( TLWList &deps );

  unsigned char e_id;
  unsigned char e_type;
  unsigned char e_trigger;
  signed char e_depend;

  short e_tdata[3];             // trigger data
  short e_data[3];              // event data

  short e_title;
  short e_message;
  unsigned short e_flags;

  Player *e_player;
};

#endif	/* _INCLUDE_EVENT_H */

