// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// initwindow.h
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_INITWINDOW_H
#define _INCLUDE_INITWINDOW_H

#include <string>
using namespace std;

#include "window.h"
#include "textbox.h"
#include "button.h"
#include "mapview.h"

class LevListWidget : public TextListWidget {
public:
  LevListWidget( short id, short x, short y, unsigned short w,
    unsigned short h, List *list, short selected,
    unsigned short flags, const char *title, Window *window ) :
    TextListWidget( id, x, y, w, h, list, selected, flags, title, window ) {};

  void PrintItem( const TLWNode *item, Surface *dest,
                  short x, short y, const Rect &clip ) const;
};


class TitleWindow : public Window {
public:
  TitleWindow( View *view );

  GUI_Status HandleEvent( const SDL_Event &event );
  void Draw( void ) {}
};

class InitWindow : public Window, public WidgetHook {
public:
  InitWindow( View *view, Window *title );
  ~InitWindow( void );

  void Draw( void );
  void Close( void ) { Window::Close(); view->CloseWindow(title); }
  GUI_Status WidgetActivated( Widget *button, Window *win );

private:
  void CompleteFilesList( TLWList &list ) const;

  TextListWidget *levwidget;
  ButtonWidget *startwidget;
  ButtonWidget *listctrlwidget;
  ButtonWidget *videowidget;
  CheckboxWidget *pbemwidget;
  CheckboxWidget *aiwidget;

  TLWList levels;
  TLWList saves;

  Window *title;
};

class GenericOptionsWindow : public Window, public WidgetHook {
public:
  GenericOptionsWindow( unsigned short w, unsigned short h,
                        const char *title, View *view );

  virtual void Draw( void );

protected:
  virtual GUI_Status WidgetActivated( Widget *widget, Window *win ) = 0;

  const Rect &GetBounds( void ) const { return clientarea; }

  static const short B_ID_OK;

private:
  const Rect clientarea;  // the part subclasses may draw into
  const char *title;
};

class GeneralOptionsWindow : public GenericOptionsWindow {
public:
  GeneralOptionsWindow( MapView &mv, View *view );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );

  CheckboxWidget *diwidget;  // damage indicators
  CheckboxWidget *repwidget; // turn replays
  CheckboxWidget *qrepwidget; // quick turn replays
  MapView &mv;
};

class VideoOptionsWindow : public GenericOptionsWindow {
public:
  VideoOptionsWindow( View *view );
  ~VideoOptionsWindow( void );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );
  short AddMode( SDL_Rect *res );

  TextListWidget *modewidget;
  CheckboxWidget *fswidget;

  List modes;
};

# ifndef DISABLE_SOUND
class SoundOptionsWindow : public GenericOptionsWindow {
public:
  SoundOptionsWindow( View *view );
  void Draw( void );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );

  static const short B_ID_SFX;
  static const short B_ID_MUSIC;
  static const short S_ID_VOL_SFX;
  static const short S_ID_VOL_MUSIC;

  SliderWidget *sfxvol;
  SliderWidget *musicvol;

  Image volgfx;
};
# endif

#endif	/* _INCLUDE_INITWINDOW_H */

