// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

/////////////////////////////////////////////////////////////////////
// player.h
/////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_PLAYER_H
#define _INCLUDE_PLAYER_H

#include "SDL.h"

#include "color.h"

#define P1_COLOR_LIGHT	0x00FEA604		// yellow
#define P1_COLOR_SHADOW	0x0056360C		// brown
#define P2_COLOR_LIGHT	0x0000AAFF		// light blue
#define P2_COLOR_SHADOW	0x0002265C		// dark blue

#define MODE_IDLE	1   // no unit selected
#define MODE_BUSY	2   // unit selected
#define MODE_DIG	3   // for pioneers
#define MODE_CONSTRUCTION	4   // for depot builders
#define MODE_SWEEP	5   // for mine-sweepers


class Player {
public:
  Player( SDL_RWops *file, unsigned char type );
  int Save( SDL_RWops *file ) const;

  signed char Briefing( void ) const { return p_briefing; }
  unsigned char ID( void ) const { return p_id; }
  unsigned char Level( void ) const { return p_level; }
  unsigned char Mode( void ) const { return p_mode; }
  const char *Name( void ) const { return p_name; }
  const char *Password( void ) const;
  unsigned char Type( void ) const { return p_type; }

  void SetMode( unsigned char mode ) { p_mode = mode; }
  void SetPassword( const char *password );

  unsigned char Success( signed char success ) { p_success += success; return p_success; }
  unsigned short Units( short delta );

  const Color &LightColor( void ) const { return p_col_light; }
  const Color &DarkColor( void ) const { return p_col_dark; }

private:
  unsigned char p_id;
  unsigned char p_mode;
  unsigned char p_type;       // COMPUTER or HUMAN
  unsigned char p_level;
  unsigned short p_units;

  unsigned char p_success;    // if p_success == 100 the level is completed
  signed char p_briefing;

  char p_name[16];
  char p_password[8];

  Color p_col_light;
  Color p_col_dark;
};

#endif	/* _INCLUDE_PLAYER_H */

