// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

////////////////////////////////////////////////////////////////////////
// fileio.h
////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_FILEIO_H
#define _INCLUDE_FILEIO_H

#if HAVE_DIRENT_H
# include <dirent.h>
#elif HAVE_SYS_NDIR_H
# include <sys/ndir.h>
#elif HAVE_SYS_DIR_H
# include <sys/dir.h>
#elif HAVE_NDIR_H
# include <ndir.h>
#elif defined WIN32
# include <windows.h>
#endif

#include <string>
using namespace std;

#include "textbox.h"	// for TLWNode and TLWList

#ifdef WIN32
#define PATHDELIM	'\\'
#define CRIMSONRC	"crimson.ini"
#else
#define PATHDELIM	'/'
#define CRIMSONRC	"crimsonrc"
#endif

#define CURRENTDIR	"."

class Directory {
public:
  Directory( const char *dir );
  ~Directory( void );

  bool IsValid( void ) const
#ifdef WIN32
    { return m_Dir != INVALID_HANDLE_VALUE; }
#else
    { return m_Dir != NULL; }
#endif

  const char *GetFileName( void ) const;
  size_t GetFileNameLen() const;
  bool IsFileHidden( void ) const;
  bool NextFile( void );

private:
#ifdef WIN32
  HANDLE           m_Dir;
  WIN32_FIND_DATA  m_Entry;
# ifdef UNICODE
  char             m_AsciiDir[MAX_PATH];
# endif
#elif HAVE_DIRENT_H
  DIR    *m_Dir;
  dirent *m_Entry;
#else
  DIR    *m_Dir;
  direct *m_Entry;
#endif
};

string get_config_dir( void );
string get_home_dir( void );
string get_save_dir( void );
string get_data_dir( void );
string get_sounds_dir( void );
string get_levels_dir( void );
string get_home_levels_dir( void );
void create_config_dir( void );
short create_files_list( const char *dirname,
                         const char *suffix, TLWList &list );

string file_part( string path );
void append_path_delim( string &path );
void make_dir( const char *dir );
bool exists( const char *file );

#endif	/* _INCLUDE_FILEIO_H */
