/* mktileset -- create a terrain set for Crimson Fields
   Copyright (C) 2000-2003 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/* create a data set for CF, containing graphics and definitions
   for terrain

   currently, all data (except the graphics) is hardcoded into
   the program

   level designers can specify custom data files to adjust the
   graphics and/or terrain characteristics to their likes
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SDL.h"

#include "editor.h"

#define FID_SET			MakeID('T','S','E','T')

extern const unsigned short NUM_TERRAIN_TYPES;
extern const struct TerrainType TModels[];

extern int save_image_data( const char *filename, int trans, SDL_RWops *out );

struct DatHeader {
  unsigned long fid;
  unsigned short terrains;
};

/* terrain classes currently used by CF (7) are:
   plains, forest, mountains, trenches, rails, shallow water, deep water

   reserved for future expansion (2): water, roads

   the final ID: trenches
   This denotes the first trenches hex in the tileset. Trenches need to
   appear in exactly the same order as in the default set if the set
   should be usable with pioneers! */
unsigned short classids[10] = { 30, 81, 117, 150, 250, 360, 362, 361, 178, 148 };


int main( int argc, char *argv[] ) {
  int status, i;
  SDL_RWops *out;
  struct DatHeader dhead = { FID_SET, NUM_TERRAIN_TYPES };

  if ( argc < 3 ) {
    fprintf(stderr, "Too few of arguments\n"
                    "Usage: %s <graphics.bmp> <outfile>\n",
                    argv[0] );
    exit(-1);
  }


  if ( SDL_Init(0) < 0 ) {
    fprintf(stderr, "Couldn't init SDL: %s\n", SDL_GetError());
    exit(-1);
  }
  atexit(SDL_Quit);

  out = SDL_RWFromFile( argv[argc-1], "wb" );
  if ( !out ) {
    fprintf(stderr, "Couldn't open output file %s\n", argv[argc-1] );
    exit(-1);
  }

  status = 0;

  /* write data file header */
  SDL_WriteLE32( out, dhead.fid );
  SDL_WriteLE16( out, dhead.terrains );

  for ( i = 0; i < 10; ++i ) SDL_WriteLE16( out, classids[i] );

  /* write terrain data */
  for ( i = 0; i < NUM_TERRAIN_TYPES; ++i ) {
    SDL_WriteLE16( out, TModels[i].tt_type );
    SDL_WriteLE16( out, TModels[i].tt_image );
    SDL_RWwrite( out, &TModels[i].tt_att_mod, 1, 3 );
    SDL_WriteLE32( out, TModels[i].tt_color );
  }

  /* load graphics */
  status = save_image_data( argv[1], 1, out );

  SDL_RWclose( out );
  return status;
}

