/* Crimson Fields - a game of tactical warfare
   Copyright (C) 2000-2004 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* ccompat.h */

#define MakeID(a,b,c,d)		((a)|((b)<<8)|((c)<<16)|((d)<<24))
#define FID_UNITSET		MakeID('U','S','E','T')
#define FID_TILESET		MakeID('T','S','E','T')

struct UnitType {
  unsigned short ut_terrain;		/* wherever it may roam... */
  unsigned short ut_image;
  unsigned short ut_flags;
  unsigned char ut_moves;
  unsigned char ut_weight;		/* used by transports */
  unsigned char ut_defence;		/* defensive strength */
  unsigned char ut_pow_ground;		/* offensive strengths */
  unsigned char ut_pow_ship;
  unsigned char ut_pow_air;
  unsigned char ut_min_range_ground;
  unsigned char ut_max_range_ground;
  unsigned char ut_min_range_ship;
  unsigned char ut_max_range_ship;
  unsigned char ut_min_range_air;
  unsigned char ut_max_range_air;
  unsigned char ut_build;		/* resources needed to build this unit type */
  unsigned char ut_snd_move;		/* movement sound (255 == none) */
  unsigned char ut_snd_fire;		/* shoot sound (255 == none) */
  unsigned char ut_trans_slots;		/* number of transport slots */
  unsigned char ut_trans_min_weight;	/* min weight the transport can carry */
  unsigned char ut_trans_max_weight;	/* max weight the transport can carry */
  unsigned char ut_typeid;
  signed char ut_portrait;		/* unit image index for the unit info dialog (-1 == none) */
};

struct TerrainType {
  unsigned short tt_type;       /* one (or more) of the TT_ defined above */
  unsigned short tt_image;
  signed char tt_att_mod;       /* attack modifier (percent) */
  signed char tt_def_mod;       /* defence modifier (percent) */
  signed char tt_move;          /* cost to cross hex type */
  char reserved;
  unsigned long tt_color;       /* color shown on the overview map display */
};

