// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2006 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

////////////////////////////////////////////////////////////////////////
// options.cpp
////////////////////////////////////////////////////////////////////////

#include "options.h"
#include "lang.h"

////////////////////////////////////////////////////////////////////////
// NAME       : Options::Options
// DESCRIPTION: Initialize default options.
// PARAMETERS : -
// RETURNS    : -
////////////////////////////////////////////////////////////////////////

Options::Options( void ) : gametype(GTYPE_AI), show_damage(true), replay(true),
         quick_replay(false), campaign(false), language(CF_LANG_DEFAULT) {
  for (int i = 0; i < KEYBIND_COUNT; ++i)
    keymap[i] = SDLK_UNKNOWN;

#ifdef V43
  keymap[KEYBIND_GAME_MENU] = SDLK_TAB;
  keymap[KEYBIND_UNIT_MENU] = SLK_SPACE;
  keymap[KEYBIND_UNIT_SELECT] = SDLK_RETURN;
#else
  // some default keys
  keymap[KEYBIND_GAME_MENU] = SDLK_F1;
  keymap[KEYBIND_UNIT_NEXT] = SDLK_F2;
  keymap[KEYBIND_UNIT_SELECT] = SDLK_SPACE;
#endif
}

