
First a small introduction for whose asking themselves
'what is location management' ?

[para] By default critcl embeds [term #line] directives into the
generated C code so that any errors, warnings and notes found by the C
compiler during compilation will refer to the [file .critcl] file the
faulty code comes from, instead of the generated [file .c] file.

[include rq_cline.inc]

[para] Most users will not care about this feature beyond simply
wanting it to work and getting proper code references when reading
compiler output.

[para] Developers of higher-level packages generating their own C code
however should care about this, to ensure that their generated code
contains proper references as well. Especially as this is key to
separating bugs concerning code generated by the package itself and
bug in the user's code going into the package, if any.

[para] Examples of such packages come with critcl itself, see the
implementation of packages [package critcl::iassoc] and
[package critcl::class].

[para] To help such developers eight commands are provided to manage
such [term location] information. These are listed below.

[para] A main concept is that they all operate on a single
[term {stored location}], setting, returning and clearing it.

Note that this location information is completely independent of the
generation of [term #line] directives within critcl itself.

[list_begin definitions]
[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::caller]]

This command stores the location of the caller of the current
procedure as a tuple of file name and linenumber. Any previously
stored location is overwritten.

The result of the command is the empty string.

[call [cmd ::critcl::at::caller] [arg offset]]

As above, the stored line number is modified by the specified
offset. In essence an implicit call of [cmd critcl::at::incr].

[call [cmd ::critcl::at::caller] [arg offset] [arg level]]

As above, but the level the location information is taken from is
modified as well. Level [const 0] is the caller, [const -1] its
caller, etc.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::here]]

This command stores the current location in the current procedure as a
tuple of file name and linenumber. Any previously stored location is
overwritten.

The result of the command is the empty string.

[para] In terms of [cmd ::critcl::at::caller] this is equivalent to
[example {
	critcl::at::caller 0 1
}]

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::get*]]

This command takes the stored location and returns a formatted
[term #line] directive ready for embedding into some C code. The
stored location is left untouched.

Note that the directive contains its own closing newline.

[para] For proper nesting and use it is recommended that such
directives are always added to the beginning of a code fragment. This
way, should deeper layers add their own directives these will come
before ours and thus be inactive. End result is that the outermost
layer generating a directive will 'win', i.e. have its directive
used. As it should be.

[call [cmd ::critcl::at::get]]

This command is like the above, except that it also clears the stored
location.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::=] [arg file] [arg line]]

This command allows the caller to set the stored location to anything
they want, outside of critcl's control.

The result of the command is the empty string.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::incr] [arg n]...]
[call [cmd ::critcl::at::incrt] [arg str]...]

These commands allow the user to modify the line number of the stored
location, changing it incrementally. The increment is specified as
either a series of integer numbers ([cmd incr]), or a series of
strings to consider ([cmd incrt]). In case of the latter the delta is
the number of lines endings found in the strings.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::at::caller!]]
[call [cmd ::critcl::at::caller!] [arg offset]]
[call [cmd ::critcl::at::caller!] [arg offset] [arg level]]
[call [cmd ::critcl::at::here!]]

These are convenience commands combining [cmd caller] and [cmd here]
with [cmd get]. I.e. they store the location and immediately return it
formatted as proper [term #line] directive. Also note that after their
use the stored location is cleared.

[list_end]
