#!/bin/sh

VERSION=0.9.11

mkdir -p CriticalMass.app/Contents/MacOS
mkdir -p CriticalMass.app/Contents/Resources
mkdir -p CriticalMass.app/Contents/Frameworks

cp game/Info.plist CriticalMass.app/Contents/

cp game/critter CriticalMass.app/Contents/MacOS

cp game/resource.dat CriticalMass.app/Contents/Resources
cp game/critter.icns CriticalMass.app/Contents/Resources
cp data/music/lg-criti.xm CriticalMass.app/Contents/Resources

cp /usr/local/lib/libpng.3.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL-1.2.0.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL_image-1.2.0.dylib CriticalMass.app/Contents/Frameworks
cp /usr/local/lib/libSDL_mixer-1.2.0.dylib CriticalMass.app/Contents/Frameworks

install_name_tool -change /usr/local/lib/libpng.3.dylib @executable_path/../Frameworks/libpng.3.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL-1.2.0.dylib @executable_path/../Frameworks/libSDL-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL_image-1.2.0.dylib @executable_path/../Frameworks/libSDL_image-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter
install_name_tool -change /usr/local/lib/libSDL_mixer-1.2.0.dylib @executable_path/../Frameworks/libSDL_mixer-1.2.0.dylib CriticalMass.app/Contents/MacOS/critter

install_name_tool -id @executable_path/../Frameworks/libSDL-1.2.0.dylib CriticalMass.app/Contents/Frameworks/libSDL-1.2.0.dylib

install_name_tool -id @executable_path/../Frameworks/libSDL_image-1.2.0.dylib CriticalMass.app/Contents/Frameworks/libSDL_image-1.2.0.dylib
install_name_tool -change /usr/local/lib/libSDL-1.2.0.dylib @executable_path/../Frameworks/libSDL-1.2.0.dylib CriticalMass.app/Contents/Frameworks/libSDL_image-1.2.0.dylib
install_name_tool -change /usr/local/lib/libpng.3.dylib @executable_path/../Frameworks/libpng.3.dylib CriticalMass.app/Contents/Frameworks/libSDL_image-1.2.0.dylib

install_name_tool -id @executable_path/../Frameworks/libSDL_mixer-1.2.0.dylib CriticalMass.app/Contents/Frameworks/libSDL_mixer-1.2.0.dylib
install_name_tool -change /usr/local/lib/libSDL-1.2.0.dylib @executable_path/../Frameworks/libSDL-1.2.0.dylib CriticalMass.app/Contents/Frameworks/libSDL_mixer-1.2.0.dylib

install_name_tool -id @executable_path/../Frameworks/libpng.3.dylib CriticalMass.app/Contents/Frameworks/libpng.3.dylib

rm -rf CriticalMass-$VERSION.dmg

mkdir CriticalMass-$VERSION
mv CriticalMass.app CriticalMass-$VERSION
cp Readme.html CriticalMass-$VERSION
cp COPYING CriticalMass-$VERSION

hdiutil create -ov -srcfolder CriticalMass-$VERSION -format UDZO CriticalMass-$VERSION.dmg

rm -rf CriticalMass-$VERSION
