char *rcsid_gtk2_menubar_c =
    "$Id: menubar.c,v 1.1 2005/03/02 07:52:04 mwedel Exp $";
/*
    Crossfire client, a client program for the crossfire program.

    Copyright (C) 2005 Mark Wedel & Crossfire Development Team

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to crossfire@metalforge.org
*/

/* This file is here to cover the core selections from the top
 * menubar.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "client.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "p_cmd.h"

/* Few quick notes on the menubar:
 * 1) Using the stock Quit menu item for some reason causes it to
 *    take several seconds of 100% cpu utilization to show the menu.
 *    So I don't use the stock item.
 */

void
menu_quit_program                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef WIN32
    script_killall();
#endif

    LOG(LOG_INFO,"gtk::client_exit","Exiting with return value 0.");
    exit(0);

}

void
menu_quit_character                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    extended_command("quit");

}


void
menu_about                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

