#include "config"

void Config::setwebinterface (string str) {
    vector<string> parts = str2parts (str, ':');
    if (parts.size() < 2 || parts.size() > 3)
	throw Error("Bad webinterface specifier in '-W" +
		    str + "', expected: IP:PORT");

    use_webinterface = true;
    webinterface_ip = parts[0];
    webinterface_port = setinteger(parts[1]);
    if (parts.size() == 3)
	webinterface_name = parts[2];
}
