/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "Utils.hh"

#include "AuthoritiesDB.hh"


/**
 * Authorities Database
 */



namespace Cryptonit
{

    AuthoritiesDB::AuthoritiesDB()
    {
	authorities = new DirectoryService();
    } 
    
    
    AuthoritiesDB::AuthoritiesDB( const std::string uri )
    {
	authorities = authorities->factory( uri );

	std::string params[] = {"", ""};
	std::string filename = "";

	if( ! authorities->read( params ) ) {
#ifdef DEBUG
 	    std::cerr << "Cannot load configuration file '"<< uri <<"'."<<std::endl;
 	    std::cerr << "Retry with default filename" << std::endl;
#endif 

	    filename = appendDir( uri, AUTHORITIESDB_DEFAULT_FILENAME );

	    if( ! authorities->read( params ) ) {
#ifdef DEBUG
 		std::cerr << "Cannot load configuration file '"<< uri <<"'."<<std::endl;
#endif 
		delete authorities;
		authorities = NULL;
		return;
	    }
	}
	
#ifdef DEBUG
 	std::cerr << "Authorities database loaded from '" << (filename == "" ? uri : filename) << "'." << std::endl;
 	std::cerr << authorities->getNbEntry() << " CA added." << std::endl;
#endif 
    } 


    AuthoritiesDB::~AuthoritiesDB()
    {
	if( authorities )
	    delete authorities;
    }

    
    bool AuthoritiesDB::save( const std::string fileName )
    {
	std::string params[] = { fileName, ""};
	return authorities->commit( params );
    }


    bool AuthoritiesDB::addAuthority( std::string name, std::string certFilename )
    {
	Entry* authority = new Entry( "certificate", certFilename );
	return authorities->append( name, authority );
    }


    bool AuthoritiesDB::removeAuthority( const std::string name )
    {
	return authorities->erase( name );
    }


    Entry* AuthoritiesDB::getAuthority( const std::string name )
    {
	return authorities->getEntry( name );
    }


    std::vector<std::string>* AuthoritiesDB::getAllAuhtorityName()
    {
	std::vector<std::string>* result = new std::vector<std::string>();

	if( authorities != NULL ) {
	    DirectoryService::iterator itr = authorities->begin();

	    while( itr != authorities->end() ) {
		result->push_back( itr.first() );
		itr++;
	    }
	    return result;
	}
	else return NULL;
    }

    std::string AuthoritiesDB::getAuthorityInfo( const std::string name, const std::string infoName )
    {
	if( authorities != NULL && name != "") {

	    Entry* entry = authorities->getEntry( name );

	    if( entry != NULL )
		return( entry->getAttributeFirstValue( infoName ) );
	}
	return( std::string("") );
    }
    
    std::vector<std::string> AuthoritiesDB::getAuthorityInfos( const std::string name, const std::string infoName )
    {
	if( authorities != NULL && name != "" ) {

	    Entry* entry = authorities->getEntry( name );
	    
	    if( entry != NULL )
		return( entry->getAttributeValues( name ) );
	}
	return std::vector<std::string>(0);
    }

    bool AuthoritiesDB::setInfo( const std::string name, const std::string infoName, const std::string value )
    {
	if(authorities->getEntry( name ))
	    return authorities->getEntry( name )->appendAttributeValue( infoName, value );
	return false;
    }

    bool AuthoritiesDB::setInfos( const std::string name, const std::string infoName, const std::vector<std::string> values )
    {
	if(authorities->getEntry( name ) && values.size() > 0)
	    return authorities->getEntry( name )->append( infoName, new Attribute( values ) );
	else if( authorities->getEntry( name  )  && values.size() == 0 ){
	    return authorities->getEntry( name )->erase( infoName );
	}
	return false;
    }

}
