/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).
 
 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
 
 
// IMPORTANT :
//
// This is a modified version of P11KeyStore, designed to use P11Manager,
// the PKCS#11 wrapper class introduced with libP11cryptonit.
//



#include "Certificate.hh"
#include "P11KeyStore.hh"
#include "P11Slot.hh"
#include "P11Key.hh"
#include "pkcs8.hh"

namespace Cryptonit {

P11KeyStore::P11KeyStore(std::string library, P11Error * errorManager, PasswordManager * passwordManager) :
		lib(library), logged(false), successfullyLoaded(false)
{
	p11manager = new P11Manager(errorManager, passwordManager, library.c_str());
	if(p11manager->live() == true)
    {
		successfullyLoaded = true;
	    }
	else
    {
		successfullyLoaded = false;
    }
}


P11KeyStore::~P11KeyStore()
{
	delete p11manager;
}

void P11KeyStore::restart()
{
#ifdef DEBUG
 	std::cout << "P11KeyStore::restart()" << std::endl;
#endif 
	successfullyLoaded = false;
	p11manager->restart();
}


P11KeyStore::P11KeyStore( const P11KeyStore &s ) :
	lib(s.lib), logged(false)
{
	// TODO:revoir le NULL
	p11manager = new P11Manager(NULL, NULL, lib.c_str());
	if(p11manager->live() == true)
    {
		successfullyLoaded = true;
    }
	else
    {
		successfullyLoaded = false;
    }
}

std::vector<Certificate> P11KeyStore::listCertificates()
{
	return p11manager->listCertificates();
}

int P11KeyStore::getKey(Certificate c, Key **k)
{
	if(p11manager->getKey(c, k) == gkrSUCCESS) return GETKEY_SUCCESS;
	else return GETKEY_CANCELED;
}

void P11KeyStore::logout()
{
}


bool P11KeyStore::getInfos( int &cryptokiVersionMajor,
				int &cryptokiVersionMinor,
				std::string &manufacturerID,
				std::string &libraryDescription,
				int &libraryVersionMajor,
				int &libraryVersionMinor )
{
	return p11manager->getInfos(cryptokiVersionMajor,
			cryptokiVersionMinor,
			manufacturerID,
			libraryDescription,
			libraryVersionMajor,
			libraryVersionMinor);
}

} // namespace Cryptonit
