/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
 
 
// IMPORTANT :
//
// This is a modified version of P11KeyStore, designed to use P11Manager,
// the PKCS#11 wrapper class introduced with libP11cryptonit.
//


#ifndef _P11_KEY_STORE_HH_
#define _P11_KEY_STORE_HH_

#include "config.h"

/*
 In the future, remove this dependency on the hash_map STL extension
*/

#if defined(HAVE_EXT_HASH_MAP)
#include <ext/hash_map>
using namespace __gnu_cxx;
#define HASH_MAP(w,x,y,z) hash_map<w,x,y,z>
#else
#if defined(HAVE_HASH_MAP)
#include <hash_map>
#define HASH_MAP(w,x,y,z) hash_map<w,x,y,z>
#else
//if the hash_map STL extension is not supported, use std::map instead
#include <map>
#define HASH_MAP(w,x,y,z) std::map<w,x,z>
#endif
#endif

#include "P11Manager.hh"
#include "pkcs8.hh"
#include "KeyStore.hh"
#include "P11Slot.hh"


namespace Cryptonit {

	/** A PKCS#11 KeyStore class.
	 *
	 */
  class P11KeyStore : public KeyStore
  {
  private:
		
      std::string lib;
      bool logged;
      bool successfullyLoaded;
		// add-ins related to the use of libP11cryptonit :
		P11Manager * p11manager;


  public:
		P11KeyStore(std::string library, P11Error * errorManager, PasswordManager * passwordManager);
      P11KeyStore( const P11KeyStore &s );
      virtual ~P11KeyStore();

		//! Returns the value of successfullyLoaded
		bool isValid() {return successfullyLoaded;}

		int getType() {return PKCS11_KEYSTORE;}

		/** Get the list of certificates
       * @return a vector of Certificate
       */
      virtual std::vector<Certificate> listCertificates();

      virtual int getKey(Certificate c, Key **k);

		std::string getLib() {return lib;}

      void logout();

		void restart();
	
		bool isLogged() {return logged;}

      bool getInfos( int &cryptokiVersionMajor,
		     int &cryptokiVersionMinor,
		     std::string &manufacturerID,
		     std::string &libraryDescription,
		     int &libraryVersionMajor,
		     int &libraryVersionMinor );

		P11Manager * getP11ManagerHandle() {return p11manager;} // provided for more control if you need it
  };
}

#endif
