/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
//#include <unistd.h>

#include <wx/wx.h>
#include <wx/stattext.h>
#include <wx/string.h>
#include <wx/dir.h>
#include <wx/notebook.h>
#include <wx/filename.h>
#include <wx/listctrl.h>
#include <wx/url.h>
//<wx/protocol/http.h>
#include <wx/stream.h>
#include <wx/ffile.h>

#include "../env.hh"
#include "../Crl.hh"

#include "CertificateViewer.hh"
#include "AddCrlDlg.hh"
#include "Common.hh"

#ifndef __WXMSW__ 
#include "pics/cert.xpm"
#endif



using namespace Cryptonit;

BEGIN_EVENT_TABLE (CertificateViewer, CryptonitDlg)
  EVT_BUTTON(CV_VIEW_BTN_ID, CertificateViewer::viewCert)
  EVT_TREE_ITEM_ACTIVATED(CV_CERT_TREE_ID,  CertificateViewer::viewCert2)
  EVT_TREE_SEL_CHANGED(CV_CERT_TREE_ID, CertificateViewer::checkCert)
  EVT_BUTTON(CV_CRLADD_ID , CertificateViewer::onAddCrl)
  EVT_BUTTON(CV_CRLDEL_ID , CertificateViewer::onDelCrl)
  EVT_LIST_ITEM_SELECTED(CV_CRLLIST_ID, CertificateViewer::onSelectCrl)
  EVT_BUTTON(CV_URI_BTN_ID , CertificateViewer::onUpdateCrl)
END_EVENT_TABLE();


CertificateViewer::CertificateViewer(wxWindow* parent, 
				     wxWindowID id, 
				     const wxString& title, 
				     const bool dislayCRL)
  : CryptonitDlg(parent, id, title)
{
  certif = NULL;
  Centre();
  tab = new wxNotebook(this, -1);
  wxBoxSizer *mainBox = new wxBoxSizer(wxVERTICAL);
  wxPanel *panel = (wxPanel *) NULL;
  
  createGeneralPage(tab, &panel);
  tab->AddPage(panel, _("General"));

  if(certif != NULL)
    {
      printf("cert non NULL\n");
    }
  
  printf("Insertion des Page Certificate Path\n");
  
  tab->SetSelection(0);
  
  //mainBox->Add(tab,1,wxEXPAND);
  
  SetSizer(mainBox);
  Centre();
  
  //wxPanel* pan = new wxPanel(this, -1);
  //wxStaticText* wst = new  wxStaticText(pan, -1, "hello world");
  printf("Sortie de la fonction CertificateViewer\n");

  this->Show();
}

#define DISPLAY_CRL_IN_CA_TAB

CertificateViewer::CertificateViewer(const Certificate &_certif,
				     User *u, wxWindow* parent, 
				     wxWindowID id, 
				     const wxString& title, 
				     const bool displayCRL)
  : CryptonitDlg(parent, id, title)
{
  crlList = NULL;
  user = u;
  this->SetSize(400,600);
  certif = new Certificate(_certif);
  Centre();  
  tab = new wxNotebook(this, -1);

  wxPanel *panel = (wxPanel *) NULL;
  createGeneralPage(tab, &panel);
  tab->AddPage(panel,_("General"));

  wxPanel *panel2 = (wxPanel *) NULL;
  createDetailsPage(tab, &panel2);
  tab->AddPage(panel2,_("Details"));

  wxPanel *panel3 = (wxPanel *) NULL;
  createCertificationPathPage(tab, &panel3);
  tab->AddPage(panel3,_("Certificates chain"));

#ifdef DISPLAY_CRL_IN_CA_TAB
  if(certif->isCA()){
      wxPanel *crlPanel = createCRLPage();
      tab->AddPage(crlPanel , _("CRL"));
  }
#else
  if(displayCRL || certif->isIssued( *certif) != X509_V_OK){
      wxPanel *crlPanel = createCRLPage();
      tab->AddPage(crlPanel , _("CRL"));
  }
#endif
    
  tab->SetSelection(0);
  mainSizer->Add(tab,1,wxEXPAND);
  Centre();
}
  

/** 
 * General Panel displaying basic information about the certificate  
 * 
 */
void CertificateViewer::createGeneralPage(wxWindow* parent,
					  wxPanel** panel)
{
  wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
  (*panel) = new wxPanel(parent);
  int proportion = 0; 		// for the sizer->Add method
  int border = 3;		// for the sizer->Add method

  // Display of the usage of the  certificate
  wxString usage;
  //   wxString signingStr = "- Signing Certificate\n";
  //   wxString cryptingStr = "- Crypting Certificate\n";

  wxStaticBox *usageBox = new wxStaticBox(*panel,-1,_("Certificate usage"));
  wxStaticBoxSizer *usageSizer = new wxStaticBoxSizer(usageBox, wxVERTICAL);
   
  if(certif->isCA()) {
			usage = _T(" - ");
    usage += _("CA");
    usage += _T("\n");
  }

  if(certif->isForSigningAndEncrypting()) {
			usage += _T(" - ");
			usage += _("Signing");
			usage += _T("\n");
			usage += _T(" - ");
			usage += _("Encrypting");
  } else if(certif->isForSigning()) {
			usage = _T(" - ");
			usage += _("Signing");
  } else if(certif->isForEncrypting()) {
			usage = _T(" - ");
			usage += _("Encrypting");
  }

  usageSizer->Add(new wxStaticText((*panel), -1, usage), 
		  proportion, wxEXPAND | wxALL,  border );

  sizer->Add(usageSizer , 0  , wxEXPAND | wxALL, 3);
   
  //Subject infos
  wxStaticBox *subjectBox = new wxStaticBox(*panel,-1,_("Subject"));
  wxStaticBoxSizer *subjectSizer = new wxStaticBoxSizer(subjectBox, wxVERTICAL);
  std::vector<std::string> subject_info;
  dn dn_subject = certif->getSubjectName();

  subject_info = dn_subject.getValuesVect();
  wxString sinfo = _T("");
   
  for(std::vector<std::string>::iterator it = subject_info.begin(); it != subject_info.end() ; it++){
			sinfo += _T(" - ");
			sinfo += std2wx(*it).c_str();
			sinfo += _T("\n");
  }
   
  subjectSizer->Add(new wxStaticText((*panel), -1, sinfo), proportion,  wxEXPAND | wxALL, border);
  sizer->Add(subjectSizer , 0  , wxEXPAND | wxALL, 3);

  //Issuer infos
  wxStaticBox *issuerBox = new wxStaticBox(*panel,-1,_("Issuer"));
  wxStaticBoxSizer *issuerSizer = new wxStaticBoxSizer(issuerBox, wxVERTICAL);
  std::vector<std::string> issuer_info;
  dn dn_issuer = certif->getIssuerName();
  issuer_info = dn_issuer.getValuesVect();
  wxString iinfo = _T("");
   
  for(std::vector<std::string>::iterator it = issuer_info.begin();
      it != issuer_info.end() ; it++){
			iinfo += _T(" - ");
			iinfo += std2wx(*it).c_str();
			iinfo += _T("\n");
  }

  issuerSizer->Add
    (new wxStaticText((*panel), -1, iinfo), proportion,
     wxEXPAND | wxALL, border);
  sizer->Add(issuerSizer , 0  , wxEXPAND | wxALL, 3);

  // Display of the date of issue and expiration

  wxStaticBox *validityBox = new wxStaticBox(*panel,-1,_("Validity"));
  wxStaticBoxSizer *validitySizer = new wxStaticBoxSizer
    (validityBox, wxVERTICAL);
   
  wxString issue = _T("");
  //   issue += "\n";
  issue += _("From");
  issue += _T(": ");
  issue += std2wx(certif->getPrettyStartDate());
  issue += _T("\n");
  issue += _("To");
  issue += _T(": ");
  issue += std2wx(certif->getPrettyEndDate());
  // _("This certificate is valid");
   
  validitySizer->Add( new wxStaticText((*panel), -1, issue) , proportion,  wxEXPAND | wxALL, border );
  sizer->Add(validitySizer , 0  , wxEXPAND | wxALL, 3);
  (*panel)->SetSizer(sizer);
}

void CertificateViewer::createDetailsPage(wxWindow* parent, wxPanel** panel)
{
  wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
  (*panel) = new wxPanel(parent);
  int proportion = 0; 		// for the sizer->Add method
  int border = 2;		// for the sizer->Add method

  // other infos
  wxStaticBox *otherBox = new wxStaticBox(*panel,-1,_("Other information"));
  wxStaticBoxSizer *otherSizer = new wxStaticBoxSizer(otherBox, wxVERTICAL);
   
  // Display of the serial number
  wxString* serialNumber = new wxString(_("Serial Number: "));
  serialNumber->Append(std2wx(certif->getSerialNumber()));

  otherSizer->Add(new wxStaticText((*panel), -1, *serialNumber) , proportion,  wxEXPAND | wxALL, border    );

   
  // Address mail
  wxString* mail = new wxString(_("EMail: "));
  mail->Append(std2wx(certif->getEmailAddress()));
  otherSizer->Add(new wxStaticText((*panel), -1, *mail) , proportion,  wxEXPAND | wxALL, border  );


  // Hash of the certificate
  wxString* hash = new wxString(_("Hash: "));
  hash->Append(std2wx(certif->getHash()));
  otherSizer->Add( new wxStaticText((*panel), -1, *hash), proportion,  wxEXPAND | wxALL, border  );
	
  sizer->Add(otherSizer , 0  , wxEXPAND | wxALL, 3);

  //X509 v3 extensions
  wxStaticBox *extBox = new wxStaticBox(*panel,-1,_("X509 v3 extensions"));
  wxStaticBoxSizer *extSizer = new wxStaticBoxSizer(extBox, wxVERTICAL);
  std::vector<std::string> ext = certif->getV3ext();
   
  wxString extensions= _T("");
  for(std::vector<std::string>::iterator it = ext.begin() ; it != ext.end() ; it++){
			extensions += _T(" - ");
			extensions += std2wx(*it).c_str();
			extensions += _T("\n");
  }
   
  extSizer->Add( new wxStaticText((*panel), -1, extensions), proportion,  wxEXPAND | wxALL, border  );
  sizer->Add(extSizer , 0  , wxEXPAND | wxALL, 3);
  (*panel)->SetSizer(sizer);
}

void CertificateViewer::createCertificationPathPage(wxWindow* parent, wxPanel** panel)
{
  (*panel) = new wxPanel(parent);
    
  std::vector<Certificate>::iterator certIter;
  //std::vector<Certificate> *vect;
  wxTreeItemId  rootItem,subjectItemId;
  certificationTree = new wxTreeCtrl(*panel, CV_CERT_TREE_ID);
  Certificate *cert = NULL;

  //certifivate icon
  wxImageList *certImageList = new wxImageList( 16 , 16 , TRUE , 1 );
  certImageList->Add( wxBITMAP( cert ) ) ;
  certificationTree->SetImageList( certImageList );

  std::vector<Certificate> *certList = new std::vector<Certificate>;
    
  wxDir dir(wxGetCwd());
  wxArrayString filename;
    
  wxFileName CADir( std2wx(user->getCACertificatesDir()) );
  dir.GetAllFiles(CADir.GetFullPath(), &filename, wxEmptyString, wxDIR_FILES);
   
  if(certif != NULL) {
    for(unsigned int i = 0 ; i < filename.GetCount() ; i++) {
      cert = new Certificate();
      if(cert->load(wx2std(filename.Item(i)).c_str())==SUCCESS) {
#ifdef DEBUG	      
					std::cout<<filename.Item(i)<<std::endl;
#endif					
					certList->push_back(*cert);
      }
    }
      
    vect = certif->getPathToRoot(certList);
      
    int flag = 1;
    for(certIter = vect->begin(); certIter!= vect->end();certIter++){
      /* Subject */
				std::string dnValue = certIter->getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE, ' ');    
				if(flag) {
						certificationTree->AddRoot(std2wx(dnValue),0,-1, new CertificateTreeItem(*certIter));
						rootItem = certificationTree->GetRootItem();
						flag=0;
						subjectItemId=rootItem;
				} else {
	subjectItemId =certificationTree->AppendItem
			(rootItem,std2wx(dnValue),0,-1,
	   new CertificateTreeItem(*certIter));    
      }
      rootItem = subjectItemId;
	
      certificationTree->Expand(rootItem);	
    }
  }
    
  certificationTree->Expand(certificationTree->GetRootItem());	

  wxTreeItemId ex = certificationTree->GetRootItem();
  void *cookie = (void*)0xDEADBEEF;
  while(ex.IsOk()) {
    certificationTree->Expand(ex);
    ex = certificationTree->GetFirstChild(ex, cookie);
  }

  wxBoxSizer *sizerPanel = new wxBoxSizer(wxVERTICAL);
  sizerPanel->Add(certificationTree, 1, wxEXPAND | wxALL , 3);
   
  wxStaticBox *infoBox = new wxStaticBox(*panel ,-1, _("Selected Certificate Info"));
  wxStaticBoxSizer *infoSizer = new wxStaticBoxSizer(infoBox , wxVERTICAL);
   
  openViewerBtn = new wxButton(*panel , CV_VIEW_BTN_ID, _("Click here to view selected certificate"));
  infoSizer->Add(openViewerBtn, 0,  wxALL | wxALIGN_CENTER_HORIZONTAL , 15);
   
  sizerPanel->Add(infoSizer, 0 , wxEXPAND | wxALL , 3);
  openViewerBtn->Enable(certificationTree->GetLastChild(certificationTree->GetSelection()).IsOk());   
  (*panel)->SetSizer(sizerPanel);
}

wxPanel* CertificateViewer::createCRLPage(){
  wxPanel *panel = new wxPanel(tab);
  wxBoxSizer *msizer = new wxBoxSizer(wxVERTICAL);
    
  wxStaticBox *box = new wxStaticBox(panel , -1 , _("Certificate Revocation List"));
  wxStaticBoxSizer *crlSizer = new wxStaticBoxSizer(box , wxHORIZONTAL);
    

  crlList = new wxListCtrl(panel , CV_CRLLIST_ID , wxDefaultPosition, wxDefaultSize , wxLC_LIST);
  crlAdd = new wxButton(panel , CV_CRLADD_ID , _("Add a CRL"));
  crlDelete = new wxButton(panel , CV_CRLDEL_ID , _("Delete this CRL"));
  uriUpdate = new wxButton(panel , CV_URI_BTN_ID, _("Update from URL"));
  crlUri = new wxStaticText(panel , -1 , _T(""), wxDefaultPosition , wxSize(250,20));
  crlVersion = new wxStaticText(panel , -1 , _T(""));
  crlLastUpdate = new wxStaticText(panel , -1 , _T(""));
  crlNextUpdate = new wxStaticText(panel , -1 , _T(""));    

  fillCrlList();
  crlSizer->Add(crlList , 1 , wxEXPAND | wxALL , 5);
  wxBoxSizer *crlBtnSizer = new wxBoxSizer(wxHORIZONTAL);

  crlBtnSizer->Add(crlAdd, 1 , wxEXPAND | wxALL , 5);
  crlBtnSizer->Add(crlDelete, 1 , wxEXPAND | wxALL , 5);
  wxStaticBox *infobox = new wxStaticBox(panel , -1 , _("CRL's infos"));
  wxStaticBoxSizer *infoSizer = new wxStaticBoxSizer(infobox , wxHORIZONTAL);
  wxFlexGridSizer *gsizer = new  wxFlexGridSizer(2);
  gsizer->Add(new wxStaticText(panel , -1 , _("Version: ")) , 0 , wxEXPAND | wxALL , 5);
  gsizer->Add(crlVersion , 1 , wxEXPAND | wxALL , 5);

  gsizer->Add(new wxStaticText(panel , -1 , _("Last Update: ")), 0 , wxEXPAND | wxALL , 5);
  gsizer->Add(crlLastUpdate , 1 , wxEXPAND | wxALL , 5);

  gsizer->Add(new wxStaticText(panel , -1 , _("Next Update: ")), 0 , wxEXPAND | wxALL , 5);
  gsizer->Add(crlNextUpdate , 1 , wxEXPAND | wxALL , 5);

  gsizer->Add( uriUpdate, 0 , wxEXPAND | wxALL , 5);  

  gsizer->Add(crlUri , 1 , wxEXPAND | wxALL , 5);
    
  infoSizer->Add(gsizer, 1 , wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
  msizer->Add(crlSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
  msizer->Add(crlBtnSizer , 0 , wxEXPAND | wxALL , 2);
  msizer->Add(infoSizer,3, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
    
  panel->SetSizer(msizer);
  panel->SetAutoLayout( TRUE );
  msizer->Fit(panel);
  

  return panel;
}

void CertificateViewer::fillCrlList(){
    clearListData();
    crlList->DeleteAllItems();


#ifdef DISPLAY_CRL_IN_CA_TAB
    std::string crl_issuer_dn =  certif->getSubjectName().getValues
      (DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',');
#else
    std::string crl_issuer_dn =  certif->getIssuerName().getValues
      (DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',');
#endif

    if( user->authorities->getAuthority (crl_issuer_dn) != NULL ) {
	crlVector = user->authorities->getAuthority(crl_issuer_dn)
	  ->getAttributeValues( "CRL" );
	std::vector<std::string>::iterator vit;
	long i = 0;
	
	for(vit = crlVector.begin(); vit != crlVector.end() ; vit++) {
	    wxFileName crlFile(std2wx(*vit));
	    crlFile=wxMyPrepend(crlFile,std2wx(user->getCRLDir()));
	
	    Crl *c = new Crl();;
	    if(c->load(wx2std(crlFile.GetFullPath()).c_str())==SUCCESS){
		wxListItem item;
		item.SetId( i );
		item.SetColumn( 0 );
		item.SetState( wxLIST_STATE_SELECTED | wxLIST_STATE_FOCUSED | wxLIST_STATE_DROPHILITED );
		item.SetMask( wxLIST_MASK_TEXT | wxLIST_MASK_DATA | wxLIST_MASK_STATE );

		std::string *data = new std::string(*vit);
		item.SetData((void*)data);

		item.SetText(std2wx(c->getLastUpdate()));
		crlList->InsertItem( item );
		i++;
	    }
	    delete c;
	}
    }



    if( crlList->GetItemCount() >= 1 ){
	crlAdd->Disable();
	uriUpdate->Enable();
	crlDelete->Enable();


	crlVersion->Enable();
	crlLastUpdate->Enable();
	crlNextUpdate->Enable();

	wxListItem selectedItem;
	selectedItem.SetId(0);
	selectedItem.SetColumn(0);
	selectedItem.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);
	crlList->GetItem(selectedItem);
	std::string *name = (std::string*)selectedItem.GetData();
	if( name ) {
	    displayCrlInfo( std2wx(*name) );
	}
	
    } else {
	crlAdd->Enable();
	crlDelete->Disable();
	crlUri->SetLabel(_T(""));
	crlUri->Disable();
	uriUpdate->Disable();
	crlVersion->SetLabel(_T(""));
	crlVersion->Disable();
	crlLastUpdate->SetLabel(_T(""));
	crlLastUpdate->Disable();
	crlNextUpdate->SetLabel(_T(""));
	crlNextUpdate->Disable();
    }
    
}

void CertificateViewer::onAddCrl(wxCommandEvent &WXUNUSED(event))
{
  std::vector<std::string> dnVect = certif->getSubjectName().
    getValuesVect(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE, "=");

  // Reverse the 'dnVect' into 'dn'
  std::vector<std::string>::reverse_iterator itr;
  std::string dn = *dnVect.rbegin();
  for( itr = dnVect.rbegin()+1; itr != dnVect.rend(); itr++ ) { 
    dn += "," + *itr;
  }

#ifdef DISPLAY_CRL_IN_CA_TAB
  AddCrlDlg crlDlg(this, -1, _("Add a CRL"), std2wx(dn) ,  wxEmptyString );
#else
  AddCrlDlg crlDlg(this, -1, _("Add a CRL"), std2wx(dn) ,  std2wx(certif->extractCrlUri()) );
#endif

  if( crlDlg.showModal() == wxID_OK) {
			Crl *crl = new Crl();
			wxString uri = _T("none");
			
			if(crlDlg.isFile()) {
					if(crl->load(wx2std(crlDlg.getFile()).c_str())!=SUCCESS){
#ifdef DEBUG						
							std::cout << "Error while loading " << crlDlg.getFile() << std::endl;
#endif							
							delete crl;
							return;
					}
			}

    if( crlDlg.isURI() ) {
#ifdef DEBUG	    
      std::cout << crlDlg.getURI() << std::endl;
#endif      
      uri = crlDlg.getURI();
      wxString tmpFile = fetchCrl(uri);
	
      if(crl->load(wx2std(tmpFile).c_str())!=SUCCESS){
	delete crl;
#ifdef DEBUG	
	std::cout << "unable to load " << tmpFile << std::endl;
#endif	
	return;
      }
      wxRemoveFile(tmpFile);
    }

    if( crlDlg.isLDAP() ) {
	    
      wxArrayString* array = NULL;
      array = crlDlg.getLDAP();

      if( array != NULL && array->GetCount() == 4 ) {
	DirectoryService *ds;
	ds = ds->factory("ldapcache");
    
	std::string params[] = {
			wx2std(array->Item(0)),
			wx2std(array->Item(1)),
			wx2std(array->Item(2)),
			wx2std(array->Item(3)),
			"LDAP_SCOPE_SUBTREE",
			"" };
	// If there is no filter, set it to "objectClass=*"
	if( params[3] == "" ) params[3] = "objectClass=*";
		
	if( ! ds->read( params ) ) {
	  wxMessageDialog errorMsg
	    (this, _("Cannot connect to the LDAP server."),
	     _("Error"), wxOK | wxICON_ERROR);
	  errorMsg.ShowModal();
	  delete array;
	  delete ds;
	  return;
	}
		    
	if( ds->getNbEntry() == 0 ) {
	  wxMessageDialog errorMsg
	    (this, _("There is no authority found with the given "
		     "filter in the LDAP."), _("Error"),
	     wxOK | wxICON_ERROR);
	  errorMsg.ShowModal();
	  delete array;
	  delete ds;
	  return;
	}
		    
	if( ds->getNbEntry() > 1 ) {
	  wxMessageDialog errorMsg
	    (this, _("The given filter returned more than one "
		     "authority, please afine your search."),
	     _("Error"), wxOK | wxICON_ERROR);
	  errorMsg.ShowModal();
	  delete array;
	  delete ds;
	  return;
	}


	if( ds->getNbEntry() == 1 ) {
	  std::string crlField("");

	  if( ds->begin().second()->getAttributeFirstValue
	      ("certificateRevocationList;binary") != "" ) {
	    crlField = "certificateRevocationList;binary";
	  } else if( ( ds->begin().second()->getAttributeFirstValue
		       ("authorityRevocationList;binary") != "" ) ) {
	    crlField = "authorityRevocationList;binary";
	  } else {
	    wxMessageDialog errorMsg
	      (this, _("Cannot find any CRL for this authority."),
	       _("Error"), wxOK | wxICON_ERROR);
	    errorMsg.ShowModal();
	    delete array;
	    delete ds;
	    return;
	  }


	  // Store the CRL
	  wxFileName temp = wxFileName::CreateTempFileName(_T(""));
	  FILE *test = fopen(wx2std(temp.GetFullPath()).c_str(),"wb");
	  fwrite( ds->begin().second()->getAttributeFirstValue
		  (crlField).c_str(), sizeof(char), 
		  ds->begin().second()->getAttributeFirstValue
		  (crlField).size(), test );
	  fclose( test );
		    
	  if(crl->load(wx2std(temp.GetFullPath()).c_str()) != SUCCESS){
	    wxMessageDialog errorMsg
	      (this, _("Cannot load the CRL, maybe it is corrupted"
		       " or in an invalid format? "),
	       _("Error"), wxOK | wxICON_ERROR);
	    errorMsg.ShowModal();
	    wxRemoveFile(temp.GetFullPath());

	    delete crl;
	    delete ds;
	    delete array;
	    return;
	  }
		    
	  wxRemoveFile(temp.GetFullPath());
		    
	  // Build the URI
	  uri = _T("ldap://");
	  uri += (array->Item(0)); // Server
	  uri += _T(":");
	  uri += (array->Item(1)); // Port
	  uri += _T("/");
	  uri += (array->Item(2)); // Base DN
	  uri += _T("?");
	  uri += std2wx(crlField);       // Attribute
	  uri += _T("?sub?");                // Scope
	  uri += std2wx(params[3]);      // Filter

	  delete ds;
	  delete array;
	}
      } else {
#ifdef DEBUG	      
	std::cout << "Oops, parameters are invalid" << std::endl;
#endif	
      }
    }
    saveCrl(  crl , uri );

    fillCrlList();


  }
}

void CertificateViewer::onDelCrl(wxCommandEvent &WXUNUSED(event)){
    
    wxListItem selectedItem;
    selectedItem.SetId(0);
    selectedItem.SetColumn(0);
    selectedItem.SetMask(wxLIST_MASK_TEXT | wxLIST_MASK_DATA);
    
    crlList->GetItem(selectedItem);
    
    std::string *name = (std::string*)selectedItem.GetData();
    //std::cout << selectedItem.GetText() << std::endl;
    if( name ){
	AddCrlDlg::deleteCrl( name , *certif , user );
	crlList->DeleteItem(0);
	delete name;
	fillCrlList();  
    }
}


void CertificateViewer::displayCrlInfo( wxString crlFile ){

    wxFileName crlFilename(crlFile);
    crlFilename=wxMyPrepend(crlFilename,std2wx(user->getCRLDir()));
    
    Crl *c = new Crl();
    if ( c->load(wx2std(crlFilename.GetFullPath()).c_str()) == SUCCESS ){
	wxString version;
	version.Printf(_T("%d"),c->getVersion());
	crlVersion->SetLabel(version);
	crlLastUpdate->SetLabel(std2wx(c->getLastUpdate()));
	crlNextUpdate->SetLabel(std2wx(c->getNextUpdate()));


#ifdef DISPLAY_CRL_IN_CA_TAB
	std::string crl_issuer_dn =  certif->getSubjectName().getValues
	  (DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',');
#else
	std::string crl_issuer_dn =  certif->getIssuerName().getValues
	  (DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',');
#endif
  
	//finding uri index 
	if( user->authorities->getAuthority( crl_issuer_dn ))
	    {
		
		
		std::vector<std::string> crlValues = user->authorities->getAuthority
		    ( crl_issuer_dn )->getAttributeValues( "CRL" );
		std::vector<std::string>::iterator valuesIt =  crlValues.begin();
		int i=0;
		while(valuesIt != crlValues.end() && std2wx(*valuesIt) != crlFile){
		    i++;
		    valuesIt++;
		}
		std::vector<std::string> uriValues = user->authorities->getAuthority
		    ( crl_issuer_dn )->getAttributeValues( "URI" );
		std::vector<std::string>::iterator uriIt  =  uriValues.begin();
		int j=0;
		while(i!=j){
		    uriIt++;
		    j++;
		}
		
		if( *uriIt == "none") {
		    uriUpdate->Disable();
		    crlUri->Enable();
		    crlUri->SetLabel( _("This CRL was not fetched from an url") );

		} else {
		    crlUri->SetLabel(std2wx(*uriIt));
		    uriUpdate->Enable();
		    crlUri->Enable();
		}
		
	    }
    }
    
}



void CertificateViewer::onSelectCrl(wxListEvent &event)
{
    wxListItem item ;
    item.SetId(event.m_itemIndex);
    item.SetColumn(0);
    item.SetMask(wxLIST_MASK_DATA);
    
    crlList->GetItem(item);
    std::string *crlFile = (std::string*)item.GetData();
    if( crlFile )
				displayCrlInfo( std2wx(*crlFile) );

}

bool CertificateViewer::saveCrl(Crl *crl, wxString uri){
    int ret =  AddCrlDlg::saveCrl( uri , crl , *certif , user );
    saveCrlErrorHandler( ret );
    return ret;
}


void CertificateViewer::saveCrlErrorHandler( int error ){

    switch( error ){
	
    case ERROR_CRL_WRONG_ISSUER: {
	wxMessageDialog errorMsg(NULL, _("This CRL has not been issued for this certificate"), _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	break;
    }
	
    case ERROR_CRL_SAVE_FILE:{
	wxMessageDialog errorMsg(NULL, _("An error occured while saving the CRL."), _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	break;
    }
	
    case  ERROR_CRL_CONFIG_UPDATE:{
	wxMessageDialog errorMsg(NULL, _("An error occured while saving CRL config."), _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	break;
    }

    case  ERROR_CRL_NOT_UNIQUE:{
	wxMessageDialog errorMsg(this, _("This CRL is already up to date."), _("Info"), wxOK | wxICON_INFORMATION );
	errorMsg.ShowModal();
	break;
    }

    case ERROR_CRL_NO_CA_ISSUER:{
	wxMessageDialog errorMsg(this, _("Unable to find the CA which has issued this CRL."), _("Error"), wxOK | wxICON_INFORMATION );
	errorMsg.ShowModal();
	break;
    }

	
    }
    
}



bool CertificateViewer::deleteCrl(wxListItem selectedItem){
  crlList->GetItem(selectedItem);
  std::string *name = (std::string*)selectedItem.GetData();
  return AddCrlDlg::deleteCrl( name , *certif , user );
}

wxString CertificateViewer::fetchCrl(wxString uri){
    return AddCrlDlg::fetchCrl( uri );
}



void CertificateViewer::onUpdateCrl(wxCommandEvent &WXUNUSED(event)){
    if(crlUri->GetLabel().Trim() != _T("")) {
#ifdef DEBUG	    	    
	std::cout << "Update from "<< crlUri->GetLabel() << std::endl;
#endif
	wxString uri =  crlUri->GetLabel().Trim();
	
	int  ret =  AddCrlDlg::updateCrl( uri , *certif , user );
	saveCrlErrorHandler( ret  );
	
	switch( ret ){
	case ERROR_CRL_WRITE_FILE:{
	    wxMessageDialog errorMsg(this, _("An error occured while writing CRL on disk."), _("Info"), wxOK | wxICON_INFORMATION );
	    errorMsg.ShowModal();
	    break;
	}

	case ERROR_CRL_LOAD:{
	    wxMessageDialog errorMsg(this, _("An error occured while loading  CRL."), _("Info"), wxOK | wxICON_INFORMATION );
	    errorMsg.ShowModal();
	    break;
	}
	    
	}
	
	fillCrlList(); 
    }
}

void CertificateViewer::clearListData(){
  if(crlList != NULL){
    for( int i=0 ; i < crlList->GetItemCount() ; i++ ){
      std::string *data = (std::string *) crlList->GetItemData( i );
      if( data ){
	delete data;
      }
    }
  }
  crlVector.clear(); 

}


CertificateViewer::~CertificateViewer()
{
    clearListData();
}
  

void CertificateViewer::checkCert(wxTreeEvent &WXUNUSED(event))
{
  openViewerBtn->Enable(certificationTree->GetLastChild(certificationTree->GetSelection()).IsOk());
}

void CertificateViewer::viewCert(wxCommandEvent &WXUNUSED(event))
{
  if(certificationTree->GetLastChild(certificationTree->GetSelection()).IsOk()){
    wxTreeItemId id =   certificationTree->GetSelection();
    const Certificate d = ((CertificateTreeItem*) certificationTree->GetItemData(id))->getCert();
    CertificateViewer cv(d, user ,this, -1 , _("Certificate properties"));
    cv.showModal(wxSize(435,500) , _("Close"), false);
  }
}

void CertificateViewer::viewCert2(wxTreeEvent &WXUNUSED(event))
{
  if(certificationTree->GetLastChild(certificationTree->GetSelection()).IsOk()){
    wxTreeItemId id =   certificationTree->GetSelection();
    const Certificate d = ((CertificateTreeItem*) certificationTree->GetItemData(id))->getCert();
    CertificateViewer cv(d, user ,this, -1 , _("Certificate properties"));
    cv.showModal(wxSize(435,500) , _("Close"), false);
  }
}

CertificateTreeItem::CertificateTreeItem(const Certificate &cert) : 
  wxTreeItemData()
{
  c = cert;
}

Certificate &CertificateTreeItem::getCert()
{
  return c;
}



