#ifndef PKCS11_FIND_H
#define PKCS11_FIND_H

/*
 * Copyright (C) 2003 Mathias Brossard <mathias.brossard@idealx.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *  
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301,
 * USA.
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */


#ifndef WIN32
#include "unix.h"
#else
#include "win32.h"
#endif
#include "pkcs11.h"

#ifdef __cplusplus
extern "C" {
#endif

CK_RV pkcs11_find_by_class (CK_FUNCTION_LIST_PTR funcs,
			    CK_SESSION_HANDLE    h_session,
			    CK_OBJECT_CLASS      _class,
			    CK_OBJECT_HANDLE_PTR *objects,
			    CK_ULONG_PTR         count);

CK_RV pkcs11_find_matching(CK_FUNCTION_LIST_PTR funcs,
			   CK_SESSION_HANDLE    h_session,
			   CK_OBJECT_HANDLE     h_source,
			   CK_OBJECT_CLASS      _class,
			   CK_ATTRIBUTE_TYPE    type,
			   CK_OBJECT_HANDLE_PTR h_result,
			   CK_ULONG_PTR         found);

#ifdef HAVE_OPENSSL
#include <openssl/x509.h>

CK_RV pkcs11_get_certificate (CK_FUNCTION_LIST_PTR funcs,
			      CK_SESSION_HANDLE    h_session,
			      CK_OBJECT_HANDLE     h_cert,
			      X509                 **x509);

CK_RV pkcs11_list_keys (CK_FUNCTION_LIST_PTR funcs,
			CK_SESSION_HANDLE    h_session,
			CK_OBJECT_HANDLE_PTR *h_keys,
			X509                 ***x509,
			CK_ULONG_PTR         count);

CK_RV pkcs11_list_certificates(CK_FUNCTION_LIST_PTR funcs,
		CK_SESSION_HANDLE    h_session,
		CK_OBJECT_HANDLE_PTR *tab_hCerts,
		X509                 ***x509,
		CK_ULONG_PTR         count);
#endif

#ifdef __cplusplus
};
#endif

#endif
