# Author: Marcelo Huerta San Martin
# Contact: richieadler@users.sourceforge.net
# Revision: $Revision: 1.1 $
# Date: $Date: 2005/07/21 20:38:46 $
# Copyright: This module has been placed in the public domain.

# New language mappings are welcome.  Before doing a new translation, please
# read <http://docutils.sf.net/docs/howto/i18n.html>.  Two files must be
# translated for each language: one in docutils/languages, the other in
# docutils/parsers/rst/languages.

"""
Esperanto-language mappings for language-dependent features of
reStructuredText.
"""

__docformat__ = 'reStructuredText'


directives = {
      # language-dependent: fixed
      u'atentu': 'attention',
      u'zorgu': 'caution',
      u'dangxero': 'danger',
      u'dan\u011dero': 'danger',
      u'eraro': 'error',
      u'spuro': 'hint',
      u'grava': 'important',
      u'noto': 'note',
      u'helpeto': 'tip',
      u'averto': 'warning',
      u'admono': 'admonition',
      u'flankteksto': 'sidebar',
      u'temo': 'topic',
      u'linea-bloko': 'line-block',
      u'analizota-literalo': 'parsed-literal',
      u'rubriko': 'rubric',
      u'epigrafo': 'epigraph',
      u'elstarajxoj': 'highlights',
      u'elstara\u0135oj': 'highlights',
      u'ekstera-citajxo': 'pull-quote',
      u'ekstera-cita\u0135o': 'pull-quote',
      u'kombinajxo': 'compound',
      u'kombina\u0135o': 'compound',
      #'questions': 'questions',
      #'qa': 'questions',
      #'faq': 'questions',
      u'tabelo': 'table',
      u'tabelo-vdk': 'csv-table', # "valoroj disigitaj per komoj"
      u'tabelo-csv': 'csv-table',
      u'tabelo-lista': 'list-table',
      u'meta': 'meta',
      #'imagemap': 'imagemap',
      u'bildo': 'image',
      u'figuro': 'figure',
      u'inkludi': 'include',
      u'senanaliza': 'raw',
      u'anstatauxi': 'replace',
      u'anstata\u016di': 'replace',
      u'unicode': 'unicode',
      u'klaso': 'class',
      u'rolo': 'role',
      u'preterlasita-rolo': 'default-role',
      u'titolo': 'title',
      u'enhavo': 'contents',
      u'seknum': 'sectnum',
      u'sekcia-numerado': 'sectnum',
      u'kapsekcio': 'header',
      u'piedsekcio': 'footer',
      #'footnotes': 'footnotes',
      #'citations': 'citations',
      u'celaj-notoj': 'target-notes',
      u'restructuredtext-test-directive': 'restructuredtext-test-directive'}
"""Esperanto name to registered (in directives/__init__.py) directive name
mapping."""

roles = {
    # language-dependent: fixed
    u'mallongigo': 'abbreviation',
    u'mall': 'abbreviation',
    u'komenclitero': 'acronym',
    u'kl': 'acronym',
    u'indekso': 'index',
    u'i': 'index',
    u'subskribo': 'subscript',
    u'sub': 'subscript',
    u'supraskribo': 'superscript',
    u'sup': 'superscript',
    u'titola-referenco': 'title-reference',
    u'titolo': 'title-reference',
    u't': 'title-reference',
    u'pep-referenco': 'pep-reference',
    u'pep': 'pep-reference',
    u'rfc-referenco': 'rfc-reference',
    u'rfc': 'rfc-reference',
    u'emfazo': 'emphasis',
    u'forta': 'strong',
    u'litera': 'literal',
    u'nomita-referenco': 'named-reference',
    u'nenomita-referenco': 'anonymous-reference',
    u'piednota-referenco': 'footnote-reference',
    u'citajxo-referenco': 'citation-reference',
    u'cita\u0135o-referenco': 'citation-reference',
    u'anstatauxa-referenco': 'substitution-reference',
    u'anstata\u016da-referenco': 'substitution-reference',
    u'celo': 'target',
    u'uri-referenco': 'uri-reference',
    u'uri': 'uri-reference',
    u'url': 'uri-reference',
    u'senanaliza': 'raw',
}
"""Mapping of Esperanto role names to canonical role names for interpreted text.
"""
