# numbers.rb : Qt methods for numbers
# Copyright (C) 2006 Vincent Fourmond
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


module MetaBuilder

  # The module ParameterTypes should be used for all subclasses of
  # ParameterType, to keep the place clean and tidy.
  module ParameterTypes

    # An integer
    class IntegerParameter

      def qt4_create_input_widget(parent = nil, target = nil, style = nil)
        return Qt4MB::IntegerInputWidget.new(parent, self)
      end
    end

  end

  module Qt4MB
    
    # A spinbox to choose Integers.
    class IntegerInputWidget < Qt::SpinBox

      # Emitted when the value is changed. Connected to
      # editingFinished().
      signals 'value_changed()' 

      # Creates a Generic widget. +type+ is the ParameterType child
      # instance for whom we should do conversion.
      def initialize(parent, type)
        super(parent)
        @type = type
        connect(self, SIGNAL('valueChanged(int)'),
                SIGNAL('value_changed()'))
        set_range(-(2**30), 2**30)
      end

      def text
        return @type.type_to_string(value)
      end

      def text=(t)
        self.value=(@type.string_to_type(t))
      end

    end
  end

end
