#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

export CTIOGA="--xpdf --clean-all --math"

# Then, we try various styles:

ctioga -N -t 'Transparency and fills' \
    --fill y-axis --fill-transparency 0.6 'sin(x)' 'cos(x)'
ctioga -N -t 'Markers' \
    --marker auto 'sin(x)**2' 'cos(x)**2'
ctioga -N -t 'Dot clouds' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' '1 - x**2'
# Style manipulations
ctioga -N -t 'Reset override' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' '1 - x**2' \
    --reset-override '10 - x**2'
# And override manipulations
ctioga -N -t 'Override manipulations' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' \
    --save-override cloud --reset-override \
    '1 - x**2' '10 - x**2' --use-override cloud 'x**2 - 10'

