# theme/demo.rb, copyright (c) 2007 by Vincent Fourmond: 
# The "demo" theme, a theme that demonstrates some
# possibilities of the theme stuff.
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).


# This file is intended as a small display of the possibilities
# of the theme thing. Please have a look at this code and also
# make sure you understand how the classical (default) theme is
# working, and then play around with this file.
#
# bod_hook and cmdline_extra_args can both do similar things,
# although not completely equivalent. Moreover, I find it is
# always good to have several ways to do things.

require 'CTioga/themes/classical'

module CTioga
  
  module Themes
    
    class DemoTheme < ClassicalTheme
      
      def initialize
        super                   # We don't want to use more for now
      end

      # To understand the following code, I can only encourage
      # you to have a look at Tioga's rdoc documentation, which
      # can be generated on your tioga source tree or
      # browsed online at
      # 
      # http://tioga.rubyforge.org/doc/
      #
      # The _t_ argument is a Tioga::FigureMaker object that
      # is in charge of actually drawing the plots.
      def bod_hook(t)
        t.tex_fontfamily = 'sfdefault' # Sans serif fonts
        t.tex_xaxis_numeric_label = '$x = #1$'
        t.tex_yaxis_numeric_label = '$y = #1$'
      end

      # This function pushes back some arguments to the command
      # line. No further processing happens, so you need to
      # make sure that you did correct splitting: 
      # ['--marker auto'] is wrong: use ['--marker', 'auto'] instead.
      def cmdline_extra_args
        return ["--background", "Cornsilk"]
      end
    end

  end

end
