/*
          Copyright (C) 1993, 1994, RSNA and Washington University

          The software and supporting documentation for the Radiological
          Society of North America (RSNA) 1993, 1994 Digital Imaging and
          Communications in Medicine (DICOM) Demonstration were developed
          at the
                  Electronic Radiology Laboratory
                  Mallinckrodt Institute of Radiology
                  Washington University School of Medicine
                  510 S. Kingshighway Blvd.
                  St. Louis, MO 63110
          as part of the 1993, 1994 DICOM Central Test Node project for, and
          under contract with, the Radiological Society of North America.

          THIS SOFTWARE IS MADE AVAILABLE, AS IS, AND NEITHER RSNA NOR
          WASHINGTON UNIVERSITY MAKE ANY WARRANTY ABOUT THE SOFTWARE, ITS
          PERFORMANCE, ITS MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR
          USE, FREEDOM FROM ANY COMPUTER DISEASES OR ITS CONFORMITY TO ANY
          SPECIFICATION. THE ENTIRE RISK AS TO QUALITY AND PERFORMANCE OF
          THE SOFTWARE IS WITH THE USER.

          Copyright of the software and supporting documentation is
          jointly owned by RSNA and Washington University, and free access
          is hereby granted as a license to use this software, copy this
          software and prepare derivative works based upon this software.
          However, any distribution of this software source code or
          supporting documentation or derivative works (source code and
          supporting documentation) must include the three paragraphs of
          the copyright notice.
*/
/* Copyright marker.  Copyright will be inserted above.  Do not remove */

/*
**                              DICOM 93
**                   Electronic Radiology Laboratory
**                 Mallinckrodt Institute of Radiology
**              Washington University School of Medicine
**
** Module Name(s):	tables.h
** Author, Date:        Pei Weng, 2-June-93
** Intent:		Include file for the IE_facility which provides
**			component definition for the DICOM information
**			objects.
** Last Update:         $Author: smm $, $Date: 1997-04-11 22:05:54 $
** Source File:         $RCSfile: tables.h,v $
** Revision:            $Revision: 1.28 $
** Status:              $State: Exp $
*/

#ifdef  __cplusplus
extern "C" {
#endif

#define  DICOM_SOPCLASSUSMF  DICOM_SOPCLASSUSMULTIFRAMEIMAGE
#define  IE_K_USMFMODULE     IE_K_USMULTIFRAMEIMAGEMODULE

typedef enum {
    CR, CT, MR, NM, US, USMF, SC, ILLEGAL
}   SOP_CLASS;

typedef struct {
    DCM_TAG tag;
    IE_ATTRIBUTEREQUIREMENT requirement;
}   TAGS;

typedef struct {
    IE_IEREQUIREMENT requirement;
    IE_MODULETYPE type;
    char *mod_description;
    TAGS *tag_tbl;
    int size_tbl;
}   MOD_FIELDS;

typedef struct {
    IE_IEREQUIREMENT requirement;
    IE_IETYPE type;
    char *ie_description;
    MOD_FIELDS *mod_fields;
    int size_tbl;
}   IE_FIELDS;

typedef struct {
    SOP_CLASS SOPClass;
    char *classUID;
    char *obj_description;
    IE_FIELDS *fields;
    int size_tbl;
}   IMAGE_TBL;

typedef struct {
    char *classUID;
    char *key;
    SOP_CLASS SOPClass;
}   MODALITY_UNIT;

/* modality table */
/* This table is used to map SOP Classes to an enumerated value.
** It is also used to map the modality field to a SOP class, although
** that will be at best an educated guess.  There is no modality
** USMF or SecCap, but that is OK since we don't want to guess those
** anyway if the image object does not have a SOP Class UID present.
*/

static MODALITY_UNIT modality_tbl[] = {
    {DICOM_SOPCLASSCOMPUTEDRADIOGRAPHY, "CR", CR},
    {DICOM_SOPCLASSCT, "CT", CT},
    {DICOM_SOPCLASSMR, "MR", MR},
    {DICOM_SOPCLASSNM, "NM", NM},
    {DICOM_SOPCLASSUS, "US", US},
    {DICOM_SOPCLASSUSMF, "USMF", USMF},
    {DICOM_SOPCLASSSECONDARYCAPTURE, "SecCap", SC}
};

/*
 * The following are tag tables for modules, all the attributes
 * are listed.
 */

/* tag table for patient module */
static TAGS patient_tbl[] = {
    {DCM_PATNAME, IE_K_TYPE2},
    {DCM_PATID, IE_K_TYPE2},
    {DCM_PATBIRTHDATE, IE_K_TYPE2},
    {DCM_PATSEX, IE_K_TYPE2},
    {DCM_IDREFERENCEDPATIENTSEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C},
    {DCM_PATOTHERIDS, IE_K_TYPE3},
    {DCM_PATOTHERNAMES, IE_K_TYPE3},
    {DCM_PATRELIGIOUSPREFERENCE, IE_K_TYPE3},
    {DCM_IMGCOMMENTS, IE_K_TYPE3},
    {DCM_PATBIRTHTIME, IE_K_TYPE3}
};

/* tag table for general study module */
static TAGS Gstudy_tbl[] = {
    {DCM_RELSTUDYINSTANCEUID, IE_K_TYPE1},
    {DCM_IDSTUDYDATE, IE_K_TYPE2},
    {DCM_IDSTUDYTIME, IE_K_TYPE2},
    {DCM_IDREFERRINGPHYSICIAN, IE_K_TYPE2},
    {DCM_RELSTUDYID, IE_K_TYPE2},
    {DCM_IDACCESSIONNUMBER, IE_K_TYPE2},
    {DCM_IDSTUDYDESCRIPTION, IE_K_TYPE3},
    {DCM_IDPHYSREADINGSTUDY, IE_K_TYPE3},
    {DCM_IDREFERENCEDSTUDYSEQ, IE_K_TYPE3}
};

/* tag table for patient study */
static TAGS Pstudy_tbl[] = {
    {DCM_IDADMITTINGDIAGDESCR, IE_K_TYPE3},
    {DCM_PATAGE, IE_K_TYPE3},
    {DCM_PATSIZE, IE_K_TYPE3},
    {DCM_PATWEIGHT, IE_K_TYPE3},
    {DCM_PATOCCUPATION, IE_K_TYPE3},
    {DCM_PATADDITIONALPATHISTORY, IE_K_TYPE3},
};

/* tag table for general series module */
static TAGS Gseries_tbl[] = {
    {DCM_IDMODALITY, IE_K_TYPE1},
    {DCM_RELSERIESINSTANCEUID, IE_K_TYPE1},
    {DCM_RELSERIESNUMBER, IE_K_TYPE2},
    {DCM_RELLATERALITY, IE_K_TYPE2C},
    {DCM_IDSERIESDATE, IE_K_TYPE3},
    {DCM_IDSERIESTIME, IE_K_TYPE3},
    {DCM_ACQPROTOCOLNAME, IE_K_TYPE3},
    {DCM_IDSERIESDESCR, IE_K_TYPE3},
    {DCM_IDOPERATORNAME, IE_K_TYPE3},
    {DCM_ACQBODYPARTEXAMINED, IE_K_TYPE3},
    {DCM_ACQPATIENTPOSITION, IE_K_TYPE2C},
    {DCM_IMGSMALLESTPIXELVALUESERIES, IE_K_TYPE3},
    {DCM_IMGLARGESTPIXELVALUESERIES, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C}
};

/* tag table for CR series module */
static TAGS CRseries_tbl[] = {
    {DCM_ACQBODYPARTEXAMINED, IE_K_TYPE2},
    {DCM_ACQVIEWPOSITION, IE_K_TYPE2},
    {DCM_ACQFILTERTYPE, IE_K_TYPE3},
    {DCM_ACQCOLLIMATORGRIDNAME, IE_K_TYPE3},
    {DCM_ACQFOCALSPOT, IE_K_TYPE3},
    {DCM_ACQPLATETYPE, IE_K_TYPE3},
#if STANDARD_VERSION < VERSION_JUL1993
    {DCM_ACQPATIENTPOSITION, IE_K_TYPE3},
#endif
    {DCM_ACQPHOSPHORTYPE, IE_K_TYPE3}
};

#if STANDARD_VERSION < VERSION_APR1995
/* tag table for NM series module */
static TAGS NMseries_tbl[] = {
    {DCM_ACQRADIONUCLIDE, IE_K_TYPE2},
    {DCM_ACQRADIOPHARMACEUTICAL, IE_K_TYPE3},
    {DCM_ACQENERGYWCENTERLINE, IE_K_TYPE3},
    {DCM_ACQENERGYWTOTALWIDTH, IE_K_TYPE3},
    {DCM_ACQINTERVENTIONDRUGNAME, IE_K_TYPE3},
    {DCM_ACQINTERVENTIONDRUGSTART, IE_K_TYPE3},
    {DCM_ACQEFFECTIVESERIESDURATION, IE_K_TYPE3},
    {DCM_ACQSYRINGECOUNTS, IE_K_TYPE3},
    {DCM_ACQTRIGGERSRCTYPE, IE_K_TYPE3},
    {DCM_ACQRADIONUCLIDEROUTE, IE_K_TYPE3},
    {DCM_ACQRADIONUCLIDEVOLUME, IE_K_TYPE3},
    {DCM_ACQRADIONUCLIDESTARTTIME, IE_K_TYPE3},
    {DCM_ACQRADIONUCLIDESTOPTIME, IE_K_TYPE3},
    {DCM_ACQRADIONUCLIDETOTALDOSE, IE_K_TYPE3},
    {DCM_ACQSCANVELOCITY, IE_K_TYPE2C},
    {DCM_ACQWHOLEBODYTECHNIQUE, IE_K_TYPE2C},
    {DCM_ACQSCANLENGTH, IE_K_TYPE2C},
    {DCM_RELISOTOPENUMBER, IE_K_TYPE3},
    {DCM_ACQGANTRYTILT, IE_K_TYPE3},
    {DCM_IDNMSERIESTYPE, IE_K_TYPE2}

};
#else				/* as per draft June 30, 1995 */
static TAGS NMseries_tbl[] = {
    {DCM_NMIPATIENTORIENTATIONCODESEQ, IE_K_TYPE2},
    {DCM_NMIPATIENTORIENTATIONMODIFIERCODESEQ, IE_K_TYPE2C},
    {DCM_NMIPATIENTGANTRYRELATIONSHIPCODESEQ, IE_K_TYPE2}
};
#endif

#if STANDARD_VERSION < VERSION_APR1995
/* tag table for NM SPECT Acq Series module */
static TAGS NMSAseries_tbl[] = {
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1},
    {DCM_ACQSCANARC, IE_K_TYPE3},
    {DCM_ACQRECONSTRUCTIONDIAMETER, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTODETECTOR, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_ACQTABLETRAVERSE, IE_K_TYPE3},
    {DCM_ACQROTATIONDIRECTION, IE_K_TYPE3},
    {DCM_ACQANGULARPOSITION, IE_K_TYPE3},
    {DCM_ACQRADIALPOSITION, IE_K_TYPE3},
    {DCM_ACQROTATIONOFFSET, IE_K_TYPE3},
    {DCM_RELANGLENUMBER, IE_K_TYPE3},
    {DCM_IMGZOOMFACTOR, IE_K_TYPE2},
    {DCM_IMGZOOMCENTER, IE_K_TYPE3},
    {DCM_ACQANGULARSTEP, IE_K_TYPE1},
    {DCM_ACQSCANARC, IE_K_TYPE2C}
};				/* could not find (0018, 1144) required */

/* tag table for NM Multi-gated Acquisition series module, tableC.8.4.5 */
static TAGS NMMAseries_tbl[] = {
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1},
    {DCM_ACQTRIGGERSRCTYPE, IE_K_TYPE2},
    {DCM_ACQTRIGGERTIME, IE_K_TYPE3},
    {DCM_ACQNOMINALINTERVAL, IE_K_TYPE3},
    {DCM_ACQFRAMINGTYPE, IE_K_TYPE3},
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQLOWRRVALUE, IE_K_TYPE3},
    {DCM_ACQHIGHRRVALUE, IE_K_TYPE3},
    {DCM_ACQINTERVALSACQUIRED, IE_K_TYPE3},
    {DCM_ACQINTERVALSREJECTED, IE_K_TYPE3},
    {DCM_ACQPVCREJECTION, IE_K_TYPE3},
    {DCM_ACQSKIPBEATS, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_ACQFRAMETIME, IE_K_TYPE2},
#if STANDARD_VERSION < VERSION_AUG1993
    {DCM_ACQCARDIACNUMBERIMAGES, IE_K_TYPE3}
#endif

};				/* could not find (0018, 1063) */
#endif

/*tag table for Region Calibration Module */
#if STANDARD_VERSION < VERSION_JUL1993
static TAGS RC_tbl[] = {
    {DCM_ACQUSREGIONSEQUENCE, IE_K_TYPE1},
    {DCM_ACQREGIONSPATIALFORMAT, IE_K_TYPE1},
    {DCM_ACQREGIONDATATYPE, IE_K_TYPE1},
    {DCM_ACQREGIONFLAGS, IE_K_TYPE1},
    {DCM_ACQPIXELCOMPORGANIZATION, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPMASK, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPRANGESTART, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPRANGESTOP, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPPHYSUNITS, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPDATATYPE, IE_K_TYPE1C},
    {DCM_ACQNUMBERTABLEBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTABLEXBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTABLEYBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTRANSDUCERFREQUENCY, IE_K_TYPE3},
    {DCM_ACQPULSEREPETITIONFREQ, IE_K_TYPE3},
    {DCM_ACQDOPPLERCORRECTIONANGLE, IE_K_TYPE3},
    {DCM_ACQSTERRINGANGLE, IE_K_TYPE3},
    {DCM_ACQDOPPLERSAMPLEVOLXPOS, IE_K_TYPE3},
    {DCM_ACQDOPPLERSAMPLEVOLYPOS, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONX0, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONY0, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONX1, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONY1, IE_K_TYPE3}
};
#endif

#if STANDARD_VERSION >= VERSION_JUL1993
static TAGS RC_tbl[] = {
    {DCM_ACQUSREGIONSEQUENCE, IE_K_TYPE1},
    {DCM_ACQREGIONSPATIALFORMAT, IE_K_TYPE1},
    {DCM_ACQREGIONDATATYPE, IE_K_TYPE1},
    {DCM_ACQREGIONFLAGS, IE_K_TYPE1},
    {DCM_ACQPIXELCOMPORGANIZATION, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPMASK, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPRANGESTART, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPRANGESTOP, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPPHYSUNITS, IE_K_TYPE1C},
    {DCM_ACQPIXELCOMPDATATYPE, IE_K_TYPE1C},
    {DCM_ACQNUMBERTABLEBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTABLEXBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTABLEYBREAKPOINTS, IE_K_TYPE1C},
    {DCM_ACQTRANSDUCERFREQUENCY, IE_K_TYPE3},
    {DCM_ACQPULSEREPETITIONFREQ, IE_K_TYPE3},
    {DCM_ACQDOPPLERCORRECTIONANGLE, IE_K_TYPE3},
    {DCM_ACQSTERRINGANGLE, IE_K_TYPE3},
    {DCM_ACQDOPPLERSAMPLEVOLXPOS, IE_K_TYPE3},
    {DCM_ACQDOPPLERSAMPLEVOLYPOS, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONX0, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONY0, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONX1, IE_K_TYPE3},
    {DCM_ACQTMLINEPOSITIONY1, IE_K_TYPE3},
    {DCM_ACQREGIONLOCATIONMINX0, IE_K_TYPE1},
    {DCM_ACQREGIONLOCATIONMINY0, IE_K_TYPE1},
    {DCM_ACQREGIONLOCATIONMAXX1, IE_K_TYPE1},
    {DCM_ACQREGIONLOCATIONMAXY1, IE_K_TYPE1},
    {DCM_ACQPHYSICALUNITSXDIRECTION, IE_K_TYPE1},
    {DCM_ACQPHYSICALUNITSYDIRECTION, IE_K_TYPE1},
    {DCM_ACQPHYSICALDELTAX, IE_K_TYPE1},
    {DCM_ACQPHYSICALDELTAY, IE_K_TYPE1},
    {DCM_ACQREFERENCEPIXELX, IE_K_TYPE3},
    {DCM_ACQREFERENCEPIXELY, IE_K_TYPE3},
    {DCM_ACQREFPIXELPHYSICALVALUEX, IE_K_TYPE3},
    {DCM_ACQREFPIXELPHYSICALVALUEY, IE_K_TYPE3}
};
#endif

/* tag table for frame of reference module */
static TAGS FReference_tbl[] = {
    {DCM_RELFRAMEOFREFERENCEUID, IE_K_TYPE1},
    {DCM_RELPOSITIONREFINDICATOR, IE_K_TYPE2}
};

/* tag table for SOP module */
static TAGS SOP_tbl[] = {
    {DCM_IDSPECIFICCHARACTER, IE_K_TYPE1C},
    {DCM_IDSOPCLASSUID, IE_K_TYPE1},
    {DCM_IDSOPINSTANCEUID, IE_K_TYPE1},
    {DCM_IDINSTANCECREATEDATE, IE_K_TYPE3},
    {DCM_IDINSTANCECREATETIME, IE_K_TYPE3},
    {DCM_IDINSTANCECREATORUID, IE_K_TYPE3}
};

/* tag table for general equipment */
static TAGS Gequip_tbl[] = {
    {DCM_IDMANUFACTURER, IE_K_TYPE2},
    {DCM_IDINSTITUTIONNAME, IE_K_TYPE3},
    {DCM_IDINSTITUTIONADDR, IE_K_TYPE3},
    {DCM_IDSTATIONNAME, IE_K_TYPE3},
    {DCM_IDINSTITUTIONALDEPT, IE_K_TYPE3},
    {DCM_IDMANUFACTURERMODEL, IE_K_TYPE3},
    {DCM_ACQDEVICESERIALNUM, IE_K_TYPE3},
    {DCM_ACQSOFTWAREVERSION, IE_K_TYPE3},
    {DCM_ACQSPATIALRESOLUTION, IE_K_TYPE3},
    {DCM_RELNUMBERSTUDYRELATEDSERIES, IE_K_TYPE3},
    {DCM_IMGPIXELPADDINGVALUE, IE_K_TYPE3},
    {DCM_ACQDATELASTCALIBRATION, IE_K_TYPE3},
    {DCM_ACQTIMELASTCALIBRATION, IE_K_TYPE3}
};				/* could not find (0x0018, 0x1205). */

#if STANDARD_VERSION < VERSION_APR1995
/* tag table for NM equipment module */
static TAGS NMequip_tbl[] = {
    {DCM_ACQCENTERROTATIONOFFSET, IE_K_TYPE3},
    {DCM_ACQFIELDOFVIEWSHAPE, IE_K_TYPE3},
    {DCM_ACQFIELDOFVIEWDIMENSION, IE_K_TYPE3},
    {DCM_ACQCOLLIMATORGRIDNAME, IE_K_TYPE3},
    {DCM_ACQCOLLIMATORTYPE, IE_K_TYPE3},
    {DCM_ACQFOCALDISTANCE, IE_K_TYPE3},
    {DCM_ACQXFOCUSCENTER, IE_K_TYPE3},
    {DCM_ACQYFOCUSCENTER, IE_K_TYPE3}
};
#endif

/* tag table for Secondary Capture equipment table */
static TAGS SCequip_tbl[] = {
    {DCM_ACQSECONDARYCAPTSOFTWAREVERSION, IE_K_TYPE3},
    {DCM_IDCONVERSIONTYPE, IE_K_TYPE1},
    {DCM_IDMODALITY, IE_K_TYPE3},
    {DCM_ACQSECONDARYCAPTUREDEVID, IE_K_TYPE3},
    {DCM_ACQSECONDARYCAPTMANUFACTURER, IE_K_TYPE3},
    {DCM_ACQSECONDARYCAPTMODEL, IE_K_TYPE3},
    {DCM_ACQSECONDARYCAPTSOFTWAREVERSION, IE_K_TYPE3},
    {DCM_ACQVIDEOIMAGEFORMATACQ, IE_K_TYPE3},
    {DCM_ACQDIGITALIMAGEFORMATACQ, IE_K_TYPE3}
};

/* tag table for general image */
static TAGS Gimage_tbl[] = {
    {DCM_RELIMAGENUMBER, IE_K_TYPE2},
    {DCM_RELPATIENTORIENTATION, IE_K_TYPE2C},
    {DCM_IDIMAGEDATE, IE_K_TYPE2C},
    {DCM_IDIMAGETIME, IE_K_TYPE2C},
/*  Type 2C in the standard, maybe type 2 for NM
    {DCM_IDIMAGEDATE, IE_K_TYPE2},
    {DCM_IDIMAGETIME, IE_K_TYPE2},
*/
    {DCM_IDIMAGETYPE, IE_K_TYPE3},
    {DCM_RELACQUISITIONNUMBER, IE_K_TYPE3},
    {DCM_IDACQUISITIONDATE, IE_K_TYPE3},
    {DCM_IDACQUISITIONTIME, IE_K_TYPE3},
    {DCM_IDREFERENCEDIMAGESEQ, IE_K_TYPE3},
    {DCM_IDDERIVATIONDESCR, IE_K_TYPE3},
    {DCM_IDSOURCEIMAGESEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C},
    {DCM_RELIMAGESINACQUISITION, IE_K_TYPE3},
    {DCM_RELIMAGECOMMENTS, IE_K_TYPE3}
};

/* tag table for image plane module */
static TAGS imgPlane_tbl[] = {
    {DCM_IMGPIXELSPACING, IE_K_TYPE1},
    {DCM_RELIMAGEORIENTATIONPATIENT, IE_K_TYPE1},
    {DCM_RELIMAGEPOSITIONPATIENT, IE_K_TYPE1},
    {DCM_ACQSLICETHICKNESS, IE_K_TYPE2},
    {DCM_RELSLICELOCATION, IE_K_TYPE3}
};

/* tag table for image pixel module */
static TAGS imageP_tbl[] = {
    {DCM_IMGSAMPLESPERPIXEL, IE_K_TYPE1},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGPLANARCONFIGURATION, IE_K_TYPE1C},
    {DCM_IMGROWS, IE_K_TYPE1},
    {DCM_IMGCOLUMNS, IE_K_TYPE1},
    {DCM_IMGPIXELASPECTRATIO, IE_K_TYPE1C},
    {DCM_IMGBITSALLOCATED, IE_K_TYPE1},
    {DCM_IMGBITSSTORED, IE_K_TYPE1},
    {DCM_IMGHIGHBIT, IE_K_TYPE1},
    {DCM_IMGPIXELREPRESENTATION, IE_K_TYPE1},
    {DCM_PXLPIXELDATA, IE_K_TYPE1},
    {DCM_IMGSMALLESTIMAGEPIXELVALUE, IE_K_TYPE3},
    {DCM_IMGLARGESTIMAGEPIXELVALUE, IE_K_TYPE3},
    {DCM_IMGWINDOWCENTER, IE_K_TYPE3},
    {DCM_IMGWINDOWWIDTH, IE_K_TYPE3},
    {DCM_IMGWINDOWCWEXPLANATION, IE_K_TYPE3},
    {DCM_IMGLUTDESCRIPTRED, IE_K_TYPE3},
    {DCM_IMGLUTDESCRIPTBLUE, IE_K_TYPE3},
    {DCM_IMGLUTDESCRIPTGREEN, IE_K_TYPE3},
    {DCM_IMGLOOKUPDATARED, IE_K_TYPE3},
    {DCM_IMGLOOKUPDATABLUE, IE_K_TYPE3},
    {DCM_IMGLOOKUPDATAGREEN, IE_K_TYPE3},
};

/* tag table for Cine module */
static TAGS cine_tbl[] = {
    {DCM_IDSTARTTRIM, IE_K_TYPE3},
    {DCM_IDDISPLAYFRAMERATE, IE_K_TYPE3},
    {DCM_ACQCINERATE, IE_K_TYPE3},
    {DCM_ACQEFFECTIVESERIESDURATION, IE_K_TYPE3},
    {DCM_ACQACTUALFRAMEDURATION, IE_K_TYPE3},
    {DCM_IDSTOPTRIM, IE_K_TYPE3},
    {DCM_ACQFRAMETIME, IE_K_TYPE1C},
    {DCM_ACQFRAMETIMEVECTOR, IE_K_TYPE1C},
    {DCM_ACQFRAMEDELAY, IE_K_TYPE3}
};				/* could not find (0018, 1063), (0018, 1065),
				 * (0018, 2142), (0018, 1066) */

/* tag table for multi-frame module */
static TAGS MF_tbl[] = {
    {DCM_IMGNUMBEROFFRAMES, IE_K_TYPE1},
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1}
};

/* tag table for contrast/bolus module */
static TAGS contrast_tbl[] = {
    {DCM_ACQCONTRASTBOLUSAGENT, IE_K_TYPE2},
    {DCM_ACQCONTRASTBOLUSROUTE, IE_K_TYPE3},
    {DCM_ACQCONTRASTBOLUSVOL, IE_K_TYPE3},
    {DCM_ACQCONTRASTBOLUSTOTALDOSE, IE_K_TYPE3},
    {DCM_ACQCONTRASTBOLUSSTARTTIME, IE_K_TYPE3},
    {DCM_ACQCONTRASTBOLUSSTOPTIME, IE_K_TYPE3}
};				/* could not find (0018, 1047), (0018, 1049) */

/* tag table for CR image module */
static TAGS CRimage_tbl[] = {
    {DCM_ACQKVP, IE_K_TYPE3},
    {DCM_ACQPLATEID, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTODETECTOR, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTOPATIENT, IE_K_TYPE3},
    {DCM_ACQEXPOSURETIME, IE_K_TYPE3},
    {DCM_ACQXRAYTUBECURRENT, IE_K_TYPE3},
    {DCM_ACQEXPOSURE, IE_K_TYPE3},
    {DCM_ACQGENERATORPOWER, IE_K_TYPE3},
    {DCM_ACQDEVICEPROCESSINGDESCR, IE_K_TYPE3},
    {DCM_ACQDEVICEPROCESSINGCODE, IE_K_TYPE3},
    {DCM_ACQCASSETTEORIENTATION, IE_K_TYPE3},
    {DCM_ACQCASSETTESIZE, IE_K_TYPE3},
    {DCM_ACQEXPOSURESONPLATE, IE_K_TYPE3},
    {DCM_ACQRELATIVEXRAYEXPOSURE, IE_K_TYPE3},
    {DCM_ACQSENSITIVITY, IE_K_TYPE3}
};

/* tag table for CT image module */
static TAGS CTimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE1},
    {DCM_IMGSAMPLESPERPIXEL, IE_K_TYPE1},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGBITSALLOCATED, IE_K_TYPE1},
    {DCM_IMGBITSSTORED, IE_K_TYPE1},
    {DCM_IMGHIGHBIT, IE_K_TYPE1},
    {DCM_IMGRESCALEINTERCEPT, IE_K_TYPE1},
    {DCM_IMGRESCALESLOPE, IE_K_TYPE1},
    {DCM_ACQKVP, IE_K_TYPE2},
    {DCM_RELACQUISITIONNUMBER, IE_K_TYPE2},
    {DCM_ACQSCANOPTIONS, IE_K_TYPE3},
    {DCM_ACQDATACOLLECTIONDIAMETER, IE_K_TYPE3},
    {DCM_ACQRECONSTRUCTIONDIAMETER, IE_K_TYPE3},
    {DCM_ACQGANTRYTILT, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_ACQROTATIONDIRECTION, IE_K_TYPE3},
    {DCM_ACQEXPOSURETIME, IE_K_TYPE3},
    {DCM_ACQXRAYTUBECURRENT, IE_K_TYPE3},
    {DCM_ACQEXPOSURE, IE_K_TYPE3},
    {DCM_ACQFILTERTYPE, IE_K_TYPE3},
    {DCM_ACQGENERATORPOWER, IE_K_TYPE3},
#if STANDARD_VERSION >= VERSION_JUL1993
    {DCM_ACQCONVOLUTIONKERNEL, IE_K_TYPE3},
#endif
    {DCM_ACQFOCALSPOT, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTODETECTOR, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTOPATIENT, IE_K_TYPE3}
};

/* tag table for MR image module */
static TAGS MRimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE1},
    {DCM_IMGSAMPLESPERPIXEL, IE_K_TYPE1},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGBITSALLOCATED, IE_K_TYPE1},
    {DCM_ACQSCANNINGSEQUENCE, IE_K_TYPE1},
    {DCM_ACQSEQUENCEVARIANT, IE_K_TYPE1},
    {DCM_ACQSCANOPTIONS, IE_K_TYPE2},
    {DCM_ACQMRACQUISITIONTYPE, IE_K_TYPE2},
    {DCM_ACQSEQUENCENAME, IE_K_TYPE3},
    {DCM_ACQANGIOFLAG, IE_K_TYPE3},
    {DCM_ACQREPETITIONTIME, IE_K_TYPE2C},
    {DCM_ACQECHOTIME, IE_K_TYPE2},
    {DCM_ACQINVERSIONTIME, IE_K_TYPE2C},
    {DCM_ACQIMAGINGFREQUENCY, IE_K_TYPE3},
    {DCM_ACQIMAGEDNUCLEUS, IE_K_TYPE3},
    {DCM_ACQECHONUMBER, IE_K_TYPE3},
    {DCM_ACQMAGNETICFIELDSTRENGTH, IE_K_TYPE3},
    {DCM_ACQSLICESPACING, IE_K_TYPE3},
    {DCM_ACQPHASEENCODINGSTEPS, IE_K_TYPE3},
    {DCM_ACQECHOTRAINLENGTH, IE_K_TYPE2},
#if STANDARD_VERSION <= VERSION_JUL1993
    {DCM_ACQNUMBERSIGNALAVERAGES, IE_K_TYPE3},
#endif
    {DCM_ACQTRIGGERTIME, IE_K_TYPE2C},
    {DCM_ACQNOMINALINTERVAL, IE_K_TYPE3},
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQLOWRRVALUE, IE_K_TYPE3},
    {DCM_ACQHIGHRRVALUE, IE_K_TYPE3},
    {DCM_ACQINTERVALSACQUIRED, IE_K_TYPE3},
    {DCM_ACQINTERVALSREJECTED, IE_K_TYPE3},
    {DCM_ACQPVCREJECTION, IE_K_TYPE3},
    {DCM_ACQSKIPBEATS, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_ACQTRIGGERWINDOW, IE_K_TYPE3},
    {DCM_ACQRECEIVINGCOIL, IE_K_TYPE3},
    {DCM_ACQTRANSMITTINGCOIL, IE_K_TYPE3},
    {DCM_ACQACQUISITIONMATRIX, IE_K_TYPE3},
    {DCM_ACQPHASEENCODINGDIRECTION, IE_K_TYPE3},
    {DCM_ACQFLIPANGLE, IE_K_TYPE3},
    {DCM_ACQSAR, IE_K_TYPE3},
    {DCM_ACQDBDT, IE_K_TYPE3},
    {DCM_RELTEMPORALPOSITIONID, IE_K_TYPE3},
    {DCM_RELNUMBERTEMPORALPOSITIONS, IE_K_TYPE3},
    {DCM_RELTEMPORALRESOLUTION, IE_K_TYPE3},
    {DCM_ACQPERCENTSAMPLING, IE_K_TYPE3},
    {DCM_ACQPERCENTPHASEFIELDVIEW, IE_K_TYPE3},
    {DCM_ACQPIXELBANDWIDTH, IE_K_TYPE3},
    {DCM_ACQRECONSTRUCTIONDIAMETER, IE_K_TYPE3},
    {DCM_ACQVARIABLEFLIPANGLE, IE_K_TYPE3}
};				/* could not find (0018, 1315), (0018, 0095),
				 * (0018, 0094), (0018, 0093) */

#if STANDARD_VERSION < VERSION_APR1995
/* tag table for NM image module */
static TAGS NMimage_tbl[] = {
#if STANDARD_VERSION < VERSION_JUL1993
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1},
#endif
#if STANDARD_VERSION >= VERSION_JUL1993
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1C},
#endif
    {DCM_ACQCOUNTSACCUMULATED, IE_K_TYPE2},
    {DCM_ACQTERMINATIONCONDITION, IE_K_TYPE3},
    {DCM_ACQDISTANCESRCTODETECTOR, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_ACQTABLETRAVERSE, IE_K_TYPE3},
    {DCM_ACQANGULARPOSITION, IE_K_TYPE3},
    {DCM_ACQRADIALPOSITION, IE_K_TYPE3},
    {DCM_ACQCONVOLUTIONKERNEL, IE_K_TYPE3},
    {DCM_ACQACTUALFRAMEDURATION, IE_K_TYPE3},
    {DCM_ACQCOUNTRATE, IE_K_TYPE3},
    {DCM_ACQPREPROCESSINGFUNCTION, IE_K_TYPE3},
    {DCM_ACQPOSTPROCESSINGFUNCTION, IE_K_TYPE3},
    {DCM_RELPHASENUMBER, IE_K_TYPE3},
    {DCM_RELINTERVALNUMBER, IE_K_TYPE3},
    {DCM_RELTIMESLOTNUMBER, IE_K_TYPE3},
    {DCM_RELANGLENUMBER, IE_K_TYPE3},
    {DCM_IMGZOOMFACTOR, IE_K_TYPE2},
    {DCM_IMGZOOMCENTER, IE_K_TYPE3},
#if STANDARD_VERSION >= VERSION_JUL1993
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C},
#endif
    {DCM_IMGCORRECTEDIMAGE, IE_K_TYPE3}
};
#else				/* New NM image (draft JUNE 95) */
static TAGS NMimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE1},
    {DCM_NMIIMAGEID, IE_K_TYPE3},
    {DCM_IMGLOSSYIMAGECOMPRESSION, IE_K_TYPE1C},
    {DCM_ACQCOUNTSACCUMULATED, IE_K_TYPE2},
    {DCM_ACQTERMINATIONCONDITION, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_ACQTABLETRAVERSE, IE_K_TYPE3},
    {DCM_ACQACTUALFRAMEDURATION, IE_K_TYPE1C},
    {DCM_ACQCOUNTRATE, IE_K_TYPE3},
    {DCM_ACQPROCESSINGFUNCTION, IE_K_TYPE3},
    {DCM_IMGCORRECTEDIMAGE, IE_K_TYPE3},
    {DCM_ACQWHOLEBODYTECHNIQUE, IE_K_TYPE3},
    {DCM_ACQSCANVELOCITY, IE_K_TYPE2C},
    {DCM_ACQSCANLENGTH, IE_K_TYPE2C},
    {DCM_IDREFERENCEDOVERLAYSEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDCURVESEQ, IE_K_TYPE3},
    {DCM_ACQTRIGGERSRCTYPE, IE_K_TYPE3},
    {DCM_IDANATOMICREGIONSEQUENCE, IE_K_TYPE3},
    {DCM_IDPRIMARYANATOMICSTRUCTURESEQ, IE_K_TYPE3}
};
#endif

/* tag table for US image module */
#if STANDARD_VERSION < VERSION_JUL1993
static TAGS USimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE1},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGPIXELREPRESENTATION, IE_K_TYPE1},
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1C},
    {DCM_IDNUMBEROFSTAGES, IE_K_TYPE2C},
    {DCM_IDNUMBERVIEWSINSTAGE, IE_K_TYPE2C},
    {DCM_IDSTAGENAME, IE_K_TYPE3},
    {DCM_IDSTAGENUMBER, IE_K_TYPE3},
    {DCM_IDVIEWNUMBER, IE_K_TYPE3},
    {DCM_IDEVENTELAPSEDTIME, IE_K_TYPE3},
    {DCM_IDEVENTTIMERNAME, IE_K_TYPE3},
    {DCM_ACQTRIGGERTIME, IE_K_TYPE3},
    {DCM_ACQNOMINALINTERVAL, IE_K_TYPE3},
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQLOWRRVALUE, IE_K_TYPE3},
    {DCM_ACQHIGHRRVALUE, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_ACQOUTPUTPOWER, IE_K_TYPE3},
    {DCM_ACQTRANSDUCERDATA, IE_K_TYPE3},
    {DCM_ACQFOCUSDEPTH, IE_K_TYPE3},
    {DCM_ACQPREPROCESSINGFUNCTION, IE_K_TYPE3},
    {DCM_ACQPOSTPROCESSINGFUNCTION, IE_K_TYPE3},
    {DCM_ACQMECHANICALINDEX, IE_K_TYPE3},
    {DCM_ACQTHERMALINDEX, IE_K_TYPE3},
    {DCM_ACQDYNAMICRANGE, IE_K_TYPE3},
    {DCM_ACQTOTALGAIN, IE_K_TYPE3},
    {DCM_ACQDEPTHOFSCANFIELD, IE_K_TYPE3},
    {DCM_ACQDOPPLERSAMPVOLLOCNAME, IE_K_TYPE3}
};				/* could not find (0008, 2129), (0008, 2200),
				 * (0008, 2204) (0008, 2208), (0018, 520A),
				 * (0018, 5208), (0018, 5206), (0018, 5204)
				 * (0018, 5202), (0018, 5200).  */
#endif

#if STANDARD_VERSION >= VERSION_JUL1993
static TAGS USimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE2},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGPIXELREPRESENTATION, IE_K_TYPE1},
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1C},
    {DCM_IDNUMBEROFSTAGES, IE_K_TYPE2C},
    {DCM_IDNUMBERVIEWSINSTAGE, IE_K_TYPE2C},
    {DCM_IDSTAGENAME, IE_K_TYPE3},
    {DCM_IDSTAGENUMBER, IE_K_TYPE3},
    {DCM_IDVIEWNUMBER, IE_K_TYPE3},
    {DCM_IDEVENTELAPSEDTIME, IE_K_TYPE3},
    {DCM_IDEVENTTIMERNAME, IE_K_TYPE3},
    {DCM_ACQTRIGGERTIME, IE_K_TYPE3},
    {DCM_ACQNOMINALINTERVAL, IE_K_TYPE3},
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQLOWRRVALUE, IE_K_TYPE3},
    {DCM_ACQHIGHRRVALUE, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_ACQOUTPUTPOWER, IE_K_TYPE3},
    {DCM_ACQTRANSDUCERDATA, IE_K_TYPE3},
    {DCM_ACQFOCUSDEPTH, IE_K_TYPE3},
#if STANDARD_VERSION < VERSION_APR1995
    {DCM_ACQPREPROCESSINGFUNCTION, IE_K_TYPE3},
#else
    {DCM_ACQPROCESSINGFUNCTION, IE_K_TYPE3},
#endif
    {DCM_ACQMECHANICALINDEX, IE_K_TYPE3},
    {DCM_ACQTHERMALINDEX, IE_K_TYPE3},
    {DCM_ACQDEPTHOFSCANFIELD, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDOVERLAYSEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDCURVESEQ, IE_K_TYPE3},
    {DCM_IDTRANSDUCERPOSITION, IE_K_TYPE3},
    {DCM_IDANATOMICSTRUCTURE, IE_K_TYPE3},
    {DCM_IDTRANSDUCERORIENTATION, IE_K_TYPE3}
};				/* Some attributes not defined */
#endif



static TAGS USMFimage_tbl[] = {
    {DCM_IDIMAGETYPE, IE_K_TYPE2},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGPIXELREPRESENTATION, IE_K_TYPE1},
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1},
    {DCM_IDNUMBEROFSTAGES, IE_K_TYPE2C},
    {DCM_IDNUMBERVIEWSINSTAGE, IE_K_TYPE2C},
    {DCM_IDSTAGENAME, IE_K_TYPE3},
    {DCM_IDSTAGENUMBER, IE_K_TYPE3},
    {DCM_IDVIEWNUMBER, IE_K_TYPE3},
    {DCM_IDEVENTELAPSEDTIME, IE_K_TYPE3},
    {DCM_IDEVENTTIMERNAME, IE_K_TYPE3},
    {DCM_ACQTRIGGERTIME, IE_K_TYPE3},
    {DCM_ACQNOMINALINTERVAL, IE_K_TYPE3},
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQLOWRRVALUE, IE_K_TYPE3},
    {DCM_ACQHIGHRRVALUE, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_ACQOUTPUTPOWER, IE_K_TYPE3},
    {DCM_ACQTRANSDUCERDATA, IE_K_TYPE3},
    {DCM_ACQFOCUSDEPTH, IE_K_TYPE3},
#if STANDARD_VERSION < VERSION_APR1995
    {DCM_ACQPREPROCESSINGFUNCTION, IE_K_TYPE3},
#else
    {DCM_ACQPROCESSINGFUNCTION, IE_K_TYPE3},
#endif
    {DCM_ACQMECHANICALINDEX, IE_K_TYPE3},
    {DCM_ACQTHERMALINDEX, IE_K_TYPE3},
    {DCM_ACQDEPTHOFSCANFIELD, IE_K_TYPE3},
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDOVERLAYSEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDCURVESEQ, IE_K_TYPE3},
    {DCM_IDTRANSDUCERPOSITION, IE_K_TYPE3},
    {DCM_IDANATOMICSTRUCTURE, IE_K_TYPE3},
    {DCM_IDTRANSDUCERORIENTATION, IE_K_TYPE3}
};				/* Some attributes not defined */




/* tag table for SC image module */
static TAGS SCimage_tbl[] = {
    {DCM_IMGRESCALEINTERCEPT, IE_K_TYPE3},
    {DCM_IMGRESCALESLOPE, IE_K_TYPE3},
    {DCM_ACQDATESECONDARYCAPTURE, IE_K_TYPE3},
    {DCM_ACQTIMESECONDARYCAPTURE, IE_K_TYPE3}
};

/* tag table for Overlay Identification module */
static TAGS overlayID_tbl[] = {
    {DCM_RELOVERLAYNUMBER, IE_K_TYPE2},
    {DCM_IDOVERLAYDATE, IE_K_TYPE3},
    {DCM_IDOVERLAYTIME, IE_K_TYPE3},
    {DCM_IDREFERENCEDIMAGESEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C}
};

/* tag table for Curve Identification module */
static TAGS curveID_tbl[] = {
    {DCM_RELCURVENUMBER, IE_K_TYPE2},
    {DCM_IDCURVEDATE, IE_K_TYPE3},
    {DCM_IDCURVETIME, IE_K_TYPE3},
    {DCM_IDREFERENCEDIMAGESEQ, IE_K_TYPE3},
#if STANDARD_VERSION < VERSION_APR1995
    {DCM_ACQTABLEHEIGHT, IE_K_TYPE3},
    {DCM_IDREFERENCEDSOPCLASSUID, IE_K_TYPE1C},
    {DCM_IDREFERENCEDSOPINSTUID, IE_K_TYPE1C}
#else
    {DCM_IDREFERENCEDOVERLAYSEQ, IE_K_TYPE3},
    {DCM_IDREFERENCEDCURVESEQ, IE_K_TYPE3}
#endif
};

/*
 * Note: tag table for overlay plane, and lookup table not implemented.
 */


#if STANDARD_VERSION >= VERSION_APR1995
static TAGS NMimagePixel_tbl[] = {
    {DCM_IMGSAMPLESPERPIXEL, IE_K_TYPE1},
    {DCM_IMGPHOTOMETRICINTERP, IE_K_TYPE1},
    {DCM_IMGBITSALLOCATED, IE_K_TYPE1},
    {DCM_IMGBITSSTORED, IE_K_TYPE1},
    {DCM_IMGHIGHBIT, IE_K_TYPE1},
    {DCM_IMGPIXELSPACING, IE_K_TYPE2}
};

static TAGS NMmultiframe_tbl[] = {
    {DCM_IMGFRAMEINCREMENTPOINTER, IE_K_TYPE1},
    {DCM_NMIENERGYWINDOWVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFENERGYWINDOWS, IE_K_TYPE1},
    {DCM_NMIDETECTORVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFDETECTORS, IE_K_TYPE1},
    {DCM_NMIPHASEVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFPHASES, IE_K_TYPE1C},
    {DCM_NMIROTATIONVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFROTATIONS, IE_K_TYPE1C},
    {DCM_NMIRRINTERVALVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFRRINTERVALS, IE_K_TYPE1C},
    {DCM_NMITIMESLOTVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFTIMESLOTS, IE_K_TYPE1C},
    {DCM_NMISLICEVECTOR, IE_K_TYPE1C},
    {DCM_NMINUMBEROFSLICES, IE_K_TYPE1C},
    {DCM_NMIANGULARVIEWVECTOR, IE_K_TYPE1C},
    {DCM_NMITIMESLICEVECTOR, IE_K_TYPE1C}
};

static TAGS NMisotope_tbl[] = {
    {DCM_NMIENERGYWINDOWINFOSEQ, IE_K_TYPE2},
    {DCM_NMIRADIOPHARMINFOSEQ, IE_K_TYPE2},
    {DCM_ACQINTERVENTIONDRUGINFOSEQ, IE_K_TYPE3},
};

static TAGS NMdetector_tbl[] = {
    {DCM_NMIDETECTORINFOSEQUENCE, IE_K_TYPE2}
};

static TAGS NMtomoAcq_tbl[] = {
    {DCM_NMIROTATIONINFOSEQUENCE, IE_K_TYPE2},
    {DCM_NMITYPEOFDETECTORMOTION, IE_K_TYPE3}
};

static TAGS NMmultigatedAcq_tbl[] = {
    {DCM_ACQBEATREJECTIONFLAG, IE_K_TYPE3},
    {DCM_ACQPVCREJECTION, IE_K_TYPE3},
    {DCM_ACQSKIPBEATS, IE_K_TYPE3},
    {DCM_ACQHEARTRATE, IE_K_TYPE3},
    {DCM_NMIGATEDINFOSEQUENCE, IE_K_TYPE2C}
};

static TAGS NMphase_tbl[] = {
    {DCM_NMIPHASEINFOSEQUENCE, IE_K_TYPE2C}
};

static TAGS NMreconstruction_tbl[] = {
    {DCM_ACQSLICESPACING, IE_K_TYPE2},
    {DCM_ACQRECONSTRUCTIONDIAMETER, IE_K_TYPE3},
    {DCM_ACQCONVOLUTIONKERNEL, IE_K_TYPE3},
    {DCM_ACQSLICETHICKNESS, IE_K_TYPE2},
    {DCM_RELSLICELOCATION, IE_K_TYPE3}
};

static TAGS OverlayPlane_tbl[] = {
    {DCM_OLYROWS, IE_K_TYPE1},
    {DCM_OLYCOLUMNS, IE_K_TYPE1},
    {DCM_OLYTYPE, IE_K_TYPE1},
    {DCM_OLYORIGIN, IE_K_TYPE1},
    {DCM_OLYBITSALLOCATED, IE_K_TYPE1},
    {DCM_OLYBITPOSITION, IE_K_TYPE1},
    {DCM_OLYDATA, IE_K_TYPE1C},
    {DCM_OLYROIAREA, IE_K_TYPE3},
    {DCM_OLYROIMEAN, IE_K_TYPE3},
    {DCM_OLYROISTANDARDDEVIATION, IE_K_TYPE3},
    {DCM_OLYDESCRIPTORGRAY, IE_K_TYPE3},
    {DCM_OLYDESCRIPTORRED, IE_K_TYPE3},
    {DCM_OLYDESCRIPTORGREEN, IE_K_TYPE3},
    {DCM_OLYDESCRIPTORBLUE, IE_K_TYPE3},
    {DCM_OLYGRAY, IE_K_TYPE3},
    {DCM_OLYRED, IE_K_TYPE3},
    {DCM_OLYGREEN, IE_K_TYPE3},
    {DCM_OLYBLUE, IE_K_TYPE3},
};

static TAGS MultiframeOverlayPlane_tbl[] = {
    {DCM_OLYNUMBEROFFRAMESINOVERLAY, IE_K_TYPE1}
};

static TAGS Curve_tbl[] = {
    {DCM_CURVEDIMENSIONS, IE_K_TYPE1},
    {DCM_CURVENUMBEROFPOINTS, IE_K_TYPE1},
    {DCM_CURVETYPEOFDATA, IE_K_TYPE1},
    {DCM_CURVEDATAVALUEREPRESENTATION, IE_K_TYPE1},
    {DCM_CURVEDATA, IE_K_TYPE1},
    {DCM_CURVEDESCRIPTION, IE_K_TYPE3},
    {DCM_CURVEAXISUNITS, IE_K_TYPE3},
    {DCM_CURVEAXISLABELS, IE_K_TYPE3},
    {DCM_CURVEMINCOORDINATEVALUE, IE_K_TYPE3},
    {DCM_CURVEMAXCOORDINATEVALUE, IE_K_TYPE3},
    {DCM_CURVERANGE, IE_K_TYPE3},
    {DCM_CURVEDATADESCRIPTOR, IE_K_TYPE1C},
    {DCM_CURVECOORDINATESTARTVALUE, IE_K_TYPE1C},
    {DCM_CURVECOORDINATESTEPVALUE, IE_K_TYPE1C}
};

static TAGS VOILUT_tbl[] = {
    {DCM_IMGVOILUTSEQUENCE, IE_K_TYPE3},
    {DCM_IMGWINDOWCENTER, IE_K_TYPE3},
    {DCM_IMGWINDOWWIDTH, IE_K_TYPE1C},
    {DCM_IMGWINDOWCWEXPLANATION, IE_K_TYPE3}
};
#endif
/* the following are module tables for patient IE */
static MOD_FIELDS CR_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS CT_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS MR_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS NM_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS US_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS USMF_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

static MOD_FIELDS SC_patient[] = {
    {IE_K_REQUIRED, IE_K_PATIENTMODULE, "PatientModule",
    patient_tbl, (int) DIM_OF(patient_tbl)}
};

/* the following are module tables for study IE */
static MOD_FIELDS CR_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS CT_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS MR_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS NM_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS US_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS USMF_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

static MOD_FIELDS SC_study[] = {
    {IE_K_REQUIRED, IE_K_GENERALSTUDYMODULE, "GeneralStudyModule",
    Gstudy_tbl, (int) DIM_OF(Gstudy_tbl)},
    {IE_K_OPTIONAL, IE_K_PATIENTSTUDYMODULE, "PatientStudyModule",
    Pstudy_tbl, (int) DIM_OF(Pstudy_tbl)}
};

/* the following are module tables for series IE */
static MOD_FIELDS CR_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)},
    {IE_K_REQUIRED, IE_K_CRSERIESMODULE, "CRseriesModule",
    CRseries_tbl, (int) DIM_OF(CRseries_tbl)}
};

static MOD_FIELDS CT_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)}
};

static MOD_FIELDS MR_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)}
};

static MOD_FIELDS NM_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)},
    {IE_K_REQUIRED, IE_K_NMSERIESMODULE, "NMseriesModule",
    NMseries_tbl, (int) DIM_OF(NMseries_tbl)},
#if STANDARD_VERSION < VERSION_APR1995
    {IE_K_OPTIONAL, IE_K_NMMULTIACQSERIESMODULE, "NMSPECTAcqSeriesModule",
    NMSAseries_tbl, (int) DIM_OF(NMSAseries_tbl)},
    {IE_K_OPTIONAL, IE_K_NMMULTIACQSERIESMODULE, "NMMulti-gatedAcqSeriesModule",
    NMMAseries_tbl, (int) DIM_OF(NMMAseries_tbl)}
#endif
};

/* could not find the modules */
/*
static MOD_FIELDS US_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE,    "GeneralSeriesModule",
     Gseries_tbl, (int)DIM_OF(Gseries_tbl)},
    {IE_K_REQUIRED, IE_K_USSERIESMODULE,         "USseriesModule",
     USseries_tbl, (int)DIM_OF(USseries_tbl)},
    {IE_K_OPTIONAL, IE_K_USLOOPSERIESMODULE,     "USLoopSeriesModule",
     USLseries_tbl, (int)DIM_OF(USLseries_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE,"RegionCalibrationModule",
     RC_tbl, (int)DIM_OF(RC_tbl)}
};
*/

/* just for testing */
static MOD_FIELDS US_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE, "RegionCalibrationModule",
    RC_tbl, (int) DIM_OF(RC_tbl)}
};

static MOD_FIELDS USMF_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE, "RegionCalibrationModule",
    RC_tbl, (int) DIM_OF(RC_tbl)}
};

static MOD_FIELDS SC_series[] = {
    {IE_K_REQUIRED, IE_K_GENERALSERIESMODULE, "GeneralSeriesModule",
    Gseries_tbl, (int) DIM_OF(Gseries_tbl)}
};

/* the following are module tables for Frame of Reference IE. */
static MOD_FIELDS CT_FOR[] = {
    {IE_K_REQUIRED, IE_K_FRAMEOFREFERENCEMODULE, "FrameOfReferenceModule",
    FReference_tbl, (int) DIM_OF(FReference_tbl)}
};

static MOD_FIELDS MR_FOR[] = {
    {IE_K_REQUIRED, IE_K_FRAMEOFREFERENCEMODULE, "FrameOfReferenceModule",
    FReference_tbl, (int) DIM_OF(FReference_tbl)}
};

static MOD_FIELDS NM_FOR[] = {
    {IE_K_OPTIONAL, IE_K_FRAMEOFREFERENCEMODULE, "FrameOfReferenceModule",
    FReference_tbl, (int) DIM_OF(FReference_tbl)}
};

/* the following are module tables for Equipment IE */
static MOD_FIELDS CR_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)}
};

static MOD_FIELDS CT_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)}
};

static MOD_FIELDS MR_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)}
};

static MOD_FIELDS NM_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)},
#if STANDARD_VERSION < VERSION_APR1995
    {IE_K_OPTIONAL, IE_K_NMEQUIPMENTMODULE, "NMEquipmentModule",
    NMequip_tbl, (int) DIM_OF(NMequip_tbl)}
#endif
};

static MOD_FIELDS US_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)}
};
static MOD_FIELDS USMF_equip[] = {
    {IE_K_REQUIRED, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)}
};

static MOD_FIELDS SC_equip[] = {
    {IE_K_OPTIONAL, IE_K_GENERALEQUIPMENTMODULE, "GeneralEquipmentModule",
    Gequip_tbl, (int) DIM_OF(Gequip_tbl)},
    {IE_K_REQUIRED, IE_K_SCEQUIPMENTMODULE, "SCEquipmentModule",
    SCequip_tbl, (int) DIM_OF(SCequip_tbl)}
};

/* the following are module tables for Image IE */
static MOD_FIELDS CR_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_REQUIRED, IE_K_CRIMAGEMODULE, "CRImageModule",
    CRimage_tbl, (int) DIM_OF(CRimage_tbl)}
};

static MOD_FIELDS CT_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPLANEMODULE, "ImagePlaneModule",
    imgPlane_tbl, (int) DIM_OF(imgPlane_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_REQUIRED, IE_K_CTIMAGEMODULE, "CTImageModule",
    CTimage_tbl, (int) DIM_OF(CTimage_tbl)}
};

static MOD_FIELDS MR_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPLANEMODULE, "ImagePlaneModule",
    imgPlane_tbl, (int) DIM_OF(imgPlane_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_REQUIRED, IE_K_MRIMAGEMODULE, "MRImageModule",
    MRimage_tbl, (int) DIM_OF(MRimage_tbl)}
};

static MOD_FIELDS NM_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
#if STANDARD_VERSION < VERSION_APR1995
    {IE_K_OPTIONAL, IE_K_IMAGEPLANEMODULE, "ImagePlaneModule",
    imgPlane_tbl, (int) DIM_OF(imgPlane_tbl)},
#endif
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
#if STANDARD_VERSION < VERSION_APR1995
    {IE_K_OPTIONAL, IE_K_CINEMODULE, "CineModule",
    cine_tbl, (int) DIM_OF(cine_tbl)},
    {IE_K_OPTIONAL, IE_K_MULTIFRAMEMODULE, "Multi-FrameModule",
    MF_tbl, (int) DIM_OF(MF_tbl)},
#else
    {IE_K_REQUIRED, IE_K_MULTIFRAMEMODULE, "Multi-FrameModule",
    MF_tbl, (int) DIM_OF(MF_tbl)},
#endif
    {IE_K_REQUIRED, IE_K_NMIMAGEMODULE, "NMImageModule",
    NMimage_tbl, (int) DIM_OF(NMimage_tbl)},
#if STANDARD_VERSION >= VERSION_APR1995
    {IE_K_REQUIRED, IE_K_NMIMAGEPIXELMODULE, "NMImagePixelModule",
    NMimagePixel_tbl, (int) DIM_OF(NMimagePixel_tbl)},
    {IE_K_REQUIRED, IE_K_NMMULTIFRAMEIMAGEMODULE, "NMMultiframeImageModule",
    NMmultiframe_tbl, (int) DIM_OF(NMmultiframe_tbl)},
    {IE_K_REQUIRED, IE_K_NMISOTOPEIMAGEMODULE, "NMIsotopeImageModule",
    NMisotope_tbl, (int) DIM_OF(NMisotope_tbl)},
    {IE_K_REQUIRED, IE_K_NMDETECTORIMAGEMODULE, "NMDetectorImageModule",
    NMdetector_tbl, (int) DIM_OF(NMdetector_tbl)},
    {IE_K_OPTIONAL, IE_K_NMTOMOACQIMAGEMODULE, "NMTomoAcquisitionImageModule",
    NMtomoAcq_tbl, (int) DIM_OF(NMtomoAcq_tbl)},
    {IE_K_OPTIONAL, IE_K_NMMULTIGATEDACQIMAGEMODULE,
	"NMMultigatedAcqImageModule", NMmultigatedAcq_tbl,
    (int) DIM_OF(NMmultigatedAcq_tbl)},
    {IE_K_OPTIONAL, IE_K_NMPHASEIMAGEMODULE, "NMPhaseImageModule",
    NMphase_tbl, (int) DIM_OF(NMphase_tbl)},
    {IE_K_OPTIONAL, IE_K_NMRECONSTRUCTIONIMAGEMODULE,
	"NMReconstructionImageModule", NMreconstruction_tbl,
    (int) DIM_OF(NMreconstruction_tbl)},
    {IE_K_OPTIONAL, IE_K_OVERLAYPLANEMODULE, "NMOverlayPlaneImageModule",
    OverlayPlane_tbl, (int) DIM_OF(OverlayPlane_tbl)},
    {IE_K_OPTIONAL, IE_K_MULTIFRAMEOVERLAYPLANEMODULE,
	"NMMultiFrameOverlayPlaneImageModule",
    MultiframeOverlayPlane_tbl, (int) DIM_OF(MultiframeOverlayPlane_tbl)},
    {IE_K_OPTIONAL, IE_K_CURVEMODULE, "NMCurveImageModule",
    Curve_tbl, (int) DIM_OF(Curve_tbl)},
    {IE_K_OPTIONAL, IE_K_VOILUTIMAGEMODULE, "NMVOILUTImageModule",
    VOILUT_tbl, (int) DIM_OF(VOILUT_tbl)},
#endif
};

#if STANDARD_VERSION < VERSION_JUL1993
static MOD_FIELDS US_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_OPTIONAL, IE_K_IMAGEPLANEMODULE, "ImagePlaneModule",
    imgPlane_tbl, (int) DIM_OF(imgPlane_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_OPTIONAL, IE_K_CINEMODULE, "CineModule",
    cine_tbl, (int) DIM_OF(cine_tbl)},
    {IE_K_OPTIONAL, IE_K_MULTIFRAMEMODULE, "Multi-FrameModule",
    MF_tbl, (int) DIM_OF(MF_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE, "RegionCalibrationModule",
    RC_tbl, (int) DIM_OF(RC_tbl)},
    {IE_K_REQUIRED, IE_K_USIMAGEMODULE, "USImageModule",
    USimage_tbl, (int) DIM_OF(USimage_tbl)}
};
#endif

#if STANDARD_VERSION >= VERSION_JUL1993
static MOD_FIELDS US_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE, "RegionCalibrationModule",
    RC_tbl, (int) DIM_OF(RC_tbl)},
    {IE_K_OPTIONAL, IE_K_MULTIFRAMEMODULE, "Multi-FrameModule",
    MF_tbl, (int) DIM_OF(MF_tbl)},
    {IE_K_REQUIRED, IE_K_USIMAGEMODULE, "USImageModule",
    USimage_tbl, (int) DIM_OF(USimage_tbl)}
};
#endif

static MOD_FIELDS USMF_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_OPTIONAL, IE_K_CONTRASTMODULE, "Contrast/BolusModule",
    contrast_tbl, (int) DIM_OF(contrast_tbl)},
    {IE_K_OPTIONAL, IE_K_REGIONCALIBRATIONMODULE, "RegionCalibrationModule",
    RC_tbl, (int) DIM_OF(RC_tbl)},
    {IE_K_REQUIRED, IE_K_MULTIFRAMEMODULE, "Multi-FrameModule",
    MF_tbl, (int) DIM_OF(MF_tbl)},
    {IE_K_REQUIRED, IE_K_USMFMODULE, "USMFImageModule",
    USMFimage_tbl, (int) DIM_OF(USMFimage_tbl)}
};


static MOD_FIELDS SC_image[] = {
    {IE_K_REQUIRED, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_REQUIRED, IE_K_GENERALIMAGEMODULE, "GeneralImageModule",
    Gimage_tbl, (int) DIM_OF(Gimage_tbl)},
    {IE_K_REQUIRED, IE_K_IMAGEPIXELMODULE, "ImagePixelModule",
    imageP_tbl, (int) DIM_OF(imageP_tbl)},
    {IE_K_REQUIRED, IE_K_SCIMAGEMODULE, "SCImageModule",
    SCimage_tbl, (int) DIM_OF(SCimage_tbl)}
};

/* The following are module tables for Overlay IE */
static MOD_FIELDS NM_overlay[] = {
    {IE_K_OPTIONAL, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_OPTIONAL, IE_K_OVERLAYIDENTIFICATIONMODULE, "OverlayIDModule",
    overlayID_tbl, (int) DIM_OF(overlayID_tbl)}
};				/* missing the Overlay Plane module */

static MOD_FIELDS SC_overlay[] = {
    {IE_K_OPTIONAL, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_OPTIONAL, IE_K_OVERLAYIDENTIFICATIONMODULE, "OverlayIDModule",
    overlayID_tbl, (int) DIM_OF(overlayID_tbl)}
};				/* missing the Overlay Plane module */

/* The following are module tables for Curve IE */
static MOD_FIELDS NM_curve[] = {
    {IE_K_OPTIONAL, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_OPTIONAL, IE_K_CURVEIDENTIFICATIONMODULE, "CurveIDModule",
    curveID_tbl, (int) DIM_OF(curveID_tbl)}
};				/* missing the Curve Plane Module */

static MOD_FIELDS US_curve[] = {
    {IE_K_OPTIONAL, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_OPTIONAL, IE_K_CURVEIDENTIFICATIONMODULE, "CurveIDModule",
    curveID_tbl, (int) DIM_OF(curveID_tbl)}
};
static MOD_FIELDS USMF_curve[] = {
    {IE_K_OPTIONAL, IE_K_SOPCOMMONMODULE, "SOPCommonModule",
    SOP_tbl, (int) DIM_OF(SOP_tbl)},
    {IE_K_OPTIONAL, IE_K_CURVEIDENTIFICATIONMODULE, "CurveIDModule",
    curveID_tbl, (int) DIM_OF(curveID_tbl)}
};
/*
 * this table contains all IEs for CR image, each memeber
 * of the table contains the Requirement, Type, module tag
 * table, and MOD_FIELDS table for a particular IE.
 */
static IE_FIELDS CR_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    CR_patient, (int) DIM_OF(CR_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    CR_study, (int) DIM_OF(CR_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    CR_series, (int) DIM_OF(CR_series)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    CR_equip, (int) DIM_OF(CR_equip)},
    {IE_K_REQUIRED, IE_K_IMAGEIE, "ImageIE",
    CR_image, (int) DIM_OF(CR_image)}
};

static IE_FIELDS CT_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    CT_patient, (int) DIM_OF(CT_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    CT_study, (int) DIM_OF(CT_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    CT_series, (int) DIM_OF(CT_series)},
    {IE_K_REQUIRED, IE_K_FRAMEOFREFERENCEIE, "FrameOfReferenceIE",
    CT_FOR, (int) DIM_OF(CT_FOR)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    CT_equip, (int) DIM_OF(CT_equip)},
    {IE_K_REQUIRED, IE_K_IMAGEIE, "ImageIE",
    CT_image, (int) DIM_OF(CT_image)}
};

static IE_FIELDS MR_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    MR_patient, (int) DIM_OF(MR_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    MR_study, (int) DIM_OF(MR_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    MR_series, (int) DIM_OF(MR_series)},
    {IE_K_REQUIRED, IE_K_FRAMEOFREFERENCEIE, "FrameOfReferenceIE",
    MR_FOR, (int) DIM_OF(MR_FOR)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    MR_equip, (int) DIM_OF(MR_equip)},
    {IE_K_REQUIRED, IE_K_IMAGEIE, "ImageIE",
    MR_image, (int) DIM_OF(MR_image)}
};

static IE_FIELDS NM_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    NM_patient, (int) DIM_OF(NM_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    NM_study, (int) DIM_OF(NM_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    NM_series, (int) DIM_OF(NM_series)},
    {IE_K_OPTIONAL, IE_K_FRAMEOFREFERENCEIE, "FrameOfReferenceIE",
    NM_FOR, (int) DIM_OF(NM_FOR)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    NM_equip, (int) DIM_OF(NM_equip)},
#if STANDARD_VERSION < VERSION_APR1995
    {IE_K_OPTIONAL, IE_K_IMAGEIE, "ImageIE",
    NM_image, (int) DIM_OF(NM_image)},
    {IE_K_OPTIONAL, IE_K_OVERLAYIE, "OverlayIE",
    NM_overlay, (int) DIM_OF(NM_overlay)},
    {IE_K_OPTIONAL, IE_K_CURVEIE, "CurveIE",
    NM_curve, (int) DIM_OF(NM_curve)}
#else				/* newer NM IOD */
    {IE_K_REQUIRED, IE_K_IMAGEIE, "ImageIE",
    NM_image, (int) DIM_OF(NM_image)}
#endif
};

static IE_FIELDS US_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    US_patient, (int) DIM_OF(US_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    US_study, (int) DIM_OF(US_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    US_series, (int) DIM_OF(US_series)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    US_equip, (int) DIM_OF(US_equip)},
    {IE_K_OPTIONAL, IE_K_IMAGEIE, "ImageIE",
    US_image, (int) DIM_OF(US_image)},
    {IE_K_OPTIONAL, IE_K_CURVEIE, "CurveIE",
    US_curve, (int) DIM_OF(US_curve)}
};

static IE_FIELDS USMF_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    USMF_patient, (int) DIM_OF(USMF_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    USMF_study, (int) DIM_OF(USMF_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    USMF_series, (int) DIM_OF(USMF_series)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    USMF_equip, (int) DIM_OF(USMF_equip)},
    {IE_K_OPTIONAL, IE_K_IMAGEIE, "ImageIE",
    USMF_image, (int) DIM_OF(USMF_image)},
    {IE_K_OPTIONAL, IE_K_CURVEIE, "CurveIE",
    USMF_curve, (int) DIM_OF(USMF_curve)}
};

static IE_FIELDS SC_tbl[] = {
    {IE_K_REQUIRED, IE_K_PATIENTIE, "PatientIE",
    SC_patient, (int) DIM_OF(SC_patient)},
    {IE_K_REQUIRED, IE_K_STUDYIE, "StudyIE",
    SC_study, (int) DIM_OF(SC_study)},
    {IE_K_REQUIRED, IE_K_SERIESIE, "SeriesIE",
    SC_series, (int) DIM_OF(SC_series)},
    {IE_K_REQUIRED, IE_K_EQUIPMENTIE, "EquipmentIE",
    SC_equip, (int) DIM_OF(SC_equip)},
    {IE_K_REQUIRED, IE_K_IMAGEIE, "ImageIE",
    SC_image, (int) DIM_OF(SC_image)},
    {IE_K_OPTIONAL, IE_K_OVERLAYIE, "OverlayIE",
    SC_overlay, (int) DIM_OF(SC_overlay)}
};

/*
 * Each member of the following table contains a modality and its
 * corresponding IE_FIELDS table.
 */
static IMAGE_TBL Images[] = {
    {CR, DICOM_SOPCLASSCOMPUTEDRADIOGRAPHY, "CR imageFile",
    CR_tbl, (int) DIM_OF(CR_tbl)},
    {CT, DICOM_SOPCLASSCT, "CT image file",
    CT_tbl, (int) DIM_OF(CT_tbl)},
    {MR, DICOM_SOPCLASSMR, "MR image file",
    MR_tbl, (int) DIM_OF(MR_tbl)},
    {NM, DICOM_SOPCLASSNM, "NM image file",
    NM_tbl, (int) DIM_OF(NM_tbl)},
    {US, DICOM_SOPCLASSUS, "US image file",
    US_tbl, (int) DIM_OF(US_tbl)},
    {USMF, DICOM_SOPCLASSUSMF, "USMF image file",
    USMF_tbl, (int) DIM_OF(USMF_tbl)},
    {SC, DICOM_SOPCLASSSECONDARYCAPTURE, "SC image file",
    SC_tbl, (int) DIM_OF(SC_tbl)}
};

#ifdef  __cplusplus
}
#endif
