/* cups-pdf.h -- CUPS Backend Header File (version  1.3.1, 11/29/2003)
   16.05.2003, Volker C. Behr
   Exp. Physik V, Uni Wuerzburg 
   vrbehr@cip.physik.uni-wuerzburg.de
   http://cip.physik.uni-wuerzburg.de/~vrbehr/cups-pdf


   This code may be freely distributed as long as this header 
   is preserved. Changes to the code should be clearly indicated.   

   This code is distributed under the GPL.
   (http://www.gnu.org/copyleft/gpl.html)

   For more detailed licensing information see cups-pdf.c in the 
   corresponding version number.			             */


/* User-customizable settings - if unsure leave the default values 
/  they are reasonable for most systems.			     */

/* location of GhostScript binary (gs) */
#define CPGHOSTSCRIPT "/usr/bin/gs"

/* PDF version to be created - can be "1.4", "1.3" or "1.2" */
#define CPPDFVER "1.4"

/* CUPS-PDF spool directory */
#define CPSPOOL "/var/spool/cups/tmp"

/* CUPS-PDF output directory 
   special qualifier: "$HOME" will set output directory dynamically
	   to the user's home directory (also true for an anonymous 
           user - make sure the home directory exists and is accessible!)
   in case CPOUT is an NFS export make sure it is exported without
   root_squash! 						         */
#define CPOUT "/var/spool/cups-pdf"

/* CUPS-PDF subdirectory for output in a user's home directory
   only required if CPOUT is set to "$HOME" 
   can be "" or a single relative directory name	        */
#define CPHOMESUB "cups-pdf"

/* removing file name extensions before appending .pdf to output
   extensions will only be removed if _both_ the following criteria are met:
    - the extension (w/o the dot) is not longer than CPOUT characters
    - the remaining filename has a minimal length of 1 character
   set CPCUT to -1 in order to disable cutting
   recommended values: pure UNIX environment : -1
                       mixed environments    :  3			    */
#define CPCUT 3

/* some installations require a domain prefix added to the user name
   (special characters must be masked, e.g. \\ for a backslash) 
   leave blank for no prefix 						*/
#define CPUSERPREFIX ""

/* if a prefix was defined above this switch toggels whether to include
   the prefix in the output directory's name (if not $HOME) or not
   0: do not include, 1: include					*/
#define CPDIRPREFIX 0

/* CUPS-PDF log directory 
/  set to "" (empty string) to disable all logging */
#define CPLOG "/var/log/cups"

/* log-mode 
/  1: errors
/  2: status (i.e. activity)
/  4: debug - this will generate a lot of log-output!
/  add up values to combine options
/  if logging is disabled these setting have no effect */
#define CPLOGTYPE 3

/* user for anonymous PDF creation (this might be a security issue)
/  set to "" (empty string) to disable anonymous			*/
#define CPANONUSER "nobody"

/* directoryname for anonymously created PDF files
/  if anonymous access is disabled this setting has no effect */
#define CPANONDIRNAME "ANONYMOUS"
