/* cups-pdf.h -- CUPS Backend Header File (version  1.7.1, 2005-06-16)
   16.05.2003, Volker C. Behr
   Exp. Physik V, Uni Wuerzburg 
   vrbehr@cip.physik.uni-wuerzburg.de
   http://cip.physik.uni-wuerzburg.de/~vrbehr/cups-pdf


   This code may be freely distributed as long as this header 
   is preserved. Changes to the code should be clearly indicated.   

   This code is distributed under the GPL.
   (http://www.gnu.org/copyleft/gpl.html)

   For more detailed licensing information see cups-pdf.c in the 
   corresponding version number.			             */


/* User-customizable settings - if unsure leave the default values 
/  they are reasonable for most systems.			     */

/* location of GhostScript binary (gs) */
#define CPGHOSTSCRIPT "/usr/bin/gs"

/* location of temporary files during GhostScript operation 
   this must be user-writable like /var/tmp or /tmp !   	*/
#define CPGSTMP "/var/tmp"

/* command line for calling GhostScript */
#define CPGSCALL "%s -q -dCompatibilityLevel=%s -dNOPAUSE -dBATCH -dSAFER \
	-sDEVICE=pdfwrite -sOutputFile=\"%s\" -dAutoRotatePages=/PageByPage \
	-dAutoFilterColorImages=false -dColorImageFilter=/FlateEncode \
	-dPDFSETTINGS=/prepress -c save pop -f %s"

/* PDF version to be created - can be "1.5", "1.4", "1.3" or "1.2" */
#define CPPDFVER "1.4"

/* CUPS-PDF spool directory - make sure there is no user 'SPOOL' on your
   system or change the path						*/
#define CPSPOOL "/var/spool/cups-pdf/SPOOL"

/* CUPS-PDF output directory 
   special qualifier: "$HOME" will set output directory dynamically
	   to the user's home directory (also true for an anonymous 
           user - make sure the home directory exists and is accessible!)
   in case CPOUT is an NFS export make sure it is exported without
   root_squash! 						         */
#define CPOUT "/var/spool/cups-pdf"

/* CUPS-PDF subdirectory for output in a user's home directory
   only required if CPOUT is set to "$HOME" 
   can be "" or a single relative directory name	        */
#define CPHOMESUB "cups-pdf"

/* This options allows to check user names given to CUPS-PDF additionally 
   against their lower case variants. This is necessary since in some 
   Windows environments only upper case user names are passed. Usually UNIX
   user names are all lower case and it is save to use this option  
   but be aware that it can lead to mis-identifications in case
   you have user names that differ only in upper/lower case.
      check only against user name as passed to CUPS  : 0
      check additionally against lower case user name : 1                  */
#define CPLOWERCASE 1

/* removing file name extensions before appending .pdf to output
   extensions will only be removed if _both_ the following criteria are met:
    - the extension (w/o the dot) is not longer than CPOUT characters
    - the remaining filename has a minimal length of 1 character
   set CPCUT to -1 in order to disable cutting
   recommended values: pure UNIX environment : -1
                       mixed environments    :  3			    */
#define CPCUT 3

/* label all jobs with a unique job-id in order to avoid overwriting old
   files in case new ones with identical names are created; always true for
   untitled documents
   0: label untitled documents only, 1: label all documents                 */
#define CPLABEL 0

/* some installations require a domain prefix added to the user name
   (special characters must be masked, e.g. \\ for a backslash) 
   leave blank for no prefix 						*/
#define CPUSERPREFIX ""

/* if a prefix was defined above this switch toggels whether to include
   the prefix in the output directory's name (if not $HOME) or not
   0: do not include, 1: include					*/
#define CPDIRPREFIX 0

/* CUPS-PDF log directory 
/  set to "" (empty string) to disable all logging */
#define CPLOG "/var/log/cups"

/* log-mode 
/  1: errors
/  2: status (i.e. activity)
/  4: debug - this will generate a lot of log-output!
/  add up values to combine options, i.e. 7 is full logging
/  if logging is disabled these setting have no effect       */
#define CPLOGTYPE 3

/* user for anonymous PDF creation (this might be a security issue)
/  set to "" (empty string) to disable anonymous			*/
#define CPANONUSER "nobody"

/* directoryname for anonymously created PDF files
/  if anonymous access is disabled this setting has no effect */
#define CPANONDIRNAME "ANONYMOUS"

/* umask for anonymous output
   these are the _inverse_ permissions to be granted */
#define CPANONUMASK 0000

/* umask for user output of known users
   changing this can introduce security leaks if confidential
   information is processed! */
#define CPUSERUMASK 0077

/* group cups-pdf is supposed to run as - this will also be the gid for all
   created directories and log files */
#define CPGRP "lp"
