
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cmdmenu.m,v 1.33 2002/06/15 19:19:30 stes Exp $
 */

#include <curses.h>
#include <menu.h>
#include <form.h>
#include <stdio.h>
#include <stdlib.h>

#include <Object.h>
#include <ocstring.h>
#include <ordcltn.h>
#include <sortcltn.h>
#include <set.h>
#include "var.h"
#include "frame.h"
#include "menufram.h"
#include "formfram.h"
#include "cmdmenu.h"
#include "item.h"
#include "cursel.h"
#include "assert.h"

id cmdmenu;
id frmmgmtmenu;

id runframe(id frame)
{
  id w = activeframe;
  [w deactivate];
  [frame activate];
  [frame display];
  [frame setslk];
  refresh();
  return nil;
}

id runlistframe(void)
{
  id c;
  int i,n;
  char buf[256];
  id f = [Menu new];

  [f setmenu:mkdesc("Open Frames")];
  [f setbegrow:mkdesc("center")];
  [f setbegcol:mkdesc("center")];
  [f setcyclic:mkdesc("true")];
  [f setlifetime:mkdesc("shortterm")];
  
  c = [OrdCltn new];
  for(i=0,n=[framelist size];i<n;i++) {
    id f = [framelist at:i];
    sprintf(buf,"open %i",[f num]);
    [c add:mkitem(mkdesc([f name]),mkdesc(buf),nil,nil)];
  }
  [f items:c];
  
  return runframe(f);
}

id gettokens(id cmd) /* destructive */
{
  id c;
  char *t;
  char *delim = " \t";

  c = [OrdCltn new];

  t = strtok([cmd str],delim);if (!t) return nil;
  [c add:[String str:t]];

  while ((t=strtok(NULL,delim))) {
    [c add:[String str:t]];
  }
  
  return c;
}

id evalcmd(id cmd)
{
  id c;
  char *t;
 
  dbg("eval %p %s\n",curframe,[cmd str]);
  c = gettokens([cmd copy]);

  if ([c size] == 0) { beep(); return nil; }
  
  t = [[c at:0] str];

  if (!strcmp(t,"nop")) { return nil; } 
  if (!strcmp(t,"help")) { return [activeframe help]; } 
  if (!strcmp(t,"update")) { return [curframe update]; } 
  if (!strcmp(t,"refresh")) { return [curframe refresh]; } 
  if (!strcmp(t,"chg-keys")) return [activeframe chgkeys];
  if (!strcmp(t,"frm-mgmt")) return runframe(frmmgmtmenu);
  if (!strcmp(t,"cmd-menu")) return runframe(cmdmenu);
  if (!strcmp(t,"exit")) { endwin();exit(0); } 
  if (!strcmp(t,"cancel")) return [curframe cancel];
  if (!strcmp(t,"save")) return [curframe save];
  if (!strcmp(t,"choices")) return [curframe choices];
  if (!strcmp(t,"mark")) return [curframe mark];
  if (!strcmp(t,"close")) return [curframe close];
  if (!strcmp(t,"list")) return runlistframe();
  if (!strcmp(t,"move")) return [curframe move];
  if (!strcmp(t,"reshape")) return [curframe reshape];
  if (!strcmp(t,"unix")) { dounixsystem();return; } 
  if (!strcmp(t,"unix-system")) { dounixsystem();return; } 
  if (!strcmp(t,"enter")) { [curframe enter];return; } 
  if (!strcmp(t,"run")) { doruncommand(c);return; } 

  if (!strcmp(t,"next-frm")) return [curframe nextframe]; 
  if (!strcmp(t,"prev-frm")) return [curframe prevframe];
  if (!strcmp(t,"next-page")) return [curframe pagedown]; 
  if (!strcmp(t,"prev-page")) return [curframe pageup];

  if (!strcmp(t,"open")) { doopencommand(c);return; }

  /* unknown cmd */
  beep();
}

@implementation CmdMenu

- iscmdmenu:(BOOL)x
{
  iscmdmenu=x;
  return self;
}

- ischoicemenu:(BOOL)x
{
  ischoicemenu=x;
  return self;
}

static id cmdmenuitems(void)
{
  id c = [OrdCltn new];
  [c add:mkitem(mkdesc("cancel"),mkdesc("cancel"),nil,nil)];
  [c add:mkitem(mkdesc("cleanup"),mkdesc("cleanup"),nil,nil)];
  [c add:mkitem(mkdesc("exit"),mkdesc("exit"),nil,nil)];
  [c add:mkitem(mkdesc("frm-mgmt"),mkdesc("frm-mgmt"),nil,nil)];
  [c add:mkitem(mkdesc("goto"),mkdesc("goto"),nil,nil)];
  [c add:mkitem(mkdesc("help"),mkdesc("help"),nil,nil)];
  [c add:mkitem(mkdesc("next-frm"),mkdesc("next-frm"),nil,nil)];
  [c add:mkitem(mkdesc("prev-frm"),mkdesc("prev-frm"),nil,nil)];
  [c add:mkitem(mkdesc("refresh"),mkdesc("refresh"),nil,nil)];
  if (!isnobang()) { 
    [c add:mkitem(mkdesc("unix-system"),mkdesc("unix-system"),nil,nil)];
  }
  [c add:mkitem(mkdesc("update"),mkdesc("update"),nil,nil)];
  return c;
}

static id frmmgmtitems(void)
{
  id c = [OrdCltn new];
  [c add:mkitem(mkdesc("list"),mkdesc("list"),nil,nil)];
  [c add:mkitem(mkdesc("move"),mkdesc("move"),nil,nil)];
  [c add:mkitem(mkdesc("reshape"),mkdesc("reshape"),nil,nil)];
  return c;
}

static id choiceitems(id d)
{
  int i,n;
  id c = [OrdCltn new];
  for(i=0,n=[d size];i<n;i++) {
    [c add:mkitem(mkdesc([[d at:i] str]),nil,nil,nil)];
  }
  return c;
}

+ new
{
  if (cmdmenu) {
    return cmdmenu;
  } else {
    cmdmenu = [super new];
    [cmdmenu setmenu:mkdesc("Command Menu")];
    [cmdmenu setbegrow:mkdesc("center")];
    [cmdmenu setcolumns:mkdesc("2")];
    [cmdmenu setbegcol:mkdesc("center")];
    [cmdmenu setcyclic:mkdesc("true")];
    [cmdmenu setlifetime:mkdesc("shortterm")];
    [cmdmenu items:cmdmenuitems()];
    return [cmdmenu iscmdmenu:YES];
  }
}

+ newfrmmgmtmenu
{
  if (frmmgmtmenu) {
    return frmmgmtmenu;
  } else {
    frmmgmtmenu = [super new];
    [frmmgmtmenu setmenu:mkdesc("Frame Management")];
    [frmmgmtmenu setbegrow:mkdesc("center")];
    [frmmgmtmenu setbegcol:mkdesc("center")];
    [frmmgmtmenu setcyclic:mkdesc("true")];
    [frmmgmtmenu setlifetime:mkdesc("shortterm")];
    [frmmgmtmenu items:frmmgmtitems()];
    return [frmmgmtmenu  iscmdmenu:YES];
  }
}

+ newchoice:c
{
  id m = [super new];
  [m setmenu:mkdesc("Choices")];
  [m setcyclic:mkdesc("true")];
  [m setlifetime:mkdesc("shortterm")];
  [m items:choiceitems(c)];
  return [m ischoicemenu:YES];
}

- additems:x
{
  int i,n;
  id c,sorted,unique;

  unique = [[[Set new] addAll:x] addAll:items];
  sorted = [[SortedCollection new] addAll:unique];
  c = [[OrdCltn new] addAll:sorted];

  /* FMLI states that NOP actions be removed from the cmdmenu */
  n=[c size];while (n--) {
    if ([[c at:n] isnop]) [c removeAt:n];
  }

  items=[OrdCltn new];
  for(i=0,n=[c size];i<n/2;i++) {
    [items add:[c at:i]];
    [items add:[c at:n/2+i]];
  }
  if(n&1) [items add:[c at:n-1]];

  return self;
}

- setchoice
{
  id i,v;
  i = [self curitem];
  v = [i e_name]; 
  dbg("setchoice %s\n",[v str]);
  [Var define:"Form_Choice" as:v];
  [curframe setcurfield:v];
  return self;
}

@end
 
