
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cursel.h,v 1.35 2002/06/15 19:34:30 stes Exp $
 */

#define VERSION "0.2.1"
#define BINSH "/bin/sh"
#define USRBINCLEAR "/usr/bin/clear"

#define YYSTYPE id

#define CP_BANNER 1
#define CP_TEXT 2
#define CP_SLK 3
#define CP_MENU 4
#define CP_FRAME 5
#define CP_TITLE 6
#define CP_CURFRAME 7
#define CP_CURTITLE 8
#define CP_MAX 9

#ifndef HAVE_COLOR
#if NCURSES_VERSION_MAJOR == 5
#define HAVE_COLOR 1
#else
#define HAVE_COLOR 0
#endif
#endif

#ifndef NCURSES_VERSION
#define NO_RESIZE 1
#endif

extern int DISPLAYH;
extern int DISPLAYW;
extern id s_center;
extern id pathaliases;
extern char* transientmsg;
extern int running;
extern int needcheckworld;
extern int colorpairs[CP_MAX];

id mkdesc(char*s);
id mkintdesc(int s);
id expandstr(id c);
int findcolor(char*s);
id chomp(id buffer);
void introductory(void);
id strfromfd(id buffer,int fd);
int expandint(id c,int def);
BOOL expandbool(id c,BOOL def);
int sfwrite(int fd,char *s);
void alarmhandler(int signo);

void dobanner(void);
void doworking(BOOL flag);
void showbanner(char *s);
void showworking(BOOL flag,char *s);
void refreshbanner(void);
void showmessage(char *s);
void drawmessage(void);
void showframemessage(void);
void showtransientmessage(char *s);
void refreshmessage(void);
void fatal(char *fmt,...);
id openmenu(char* s);
id openform(char* s);
id opentext(char* s);
id openfile(char* s);
id findframe(char *s);
void redrawall(void);
void displayall(void);
void dounixsystem(void);
void doopencommand(id c);
id splitwords(id c);
int doruncommand(id args);
int isnobang(void);

/* SIGINT handler */

extern BOOL u_interrupt;
extern id u_oninterrupt;
extern void siginthandler(int signo);

/* Global Settings */

extern id g_slk;
extern id g_columns; /* introductory frame */
extern id g_rows; /* introductory frame */
extern id g_text; /* text of introductory frame */
extern id g_title; /* title of introductory frame */
extern id g_bancol; /* center or integer, column in banner */
extern id g_banner; /* banner text */
extern id g_banner_text; /* banner text color */
extern id g_working; /* working test */
extern id g_active_border; /* color of frame border when current */
extern id g_active_title_bar; /* color of title background when current */
extern id g_active_title_text; /* color of title text when current */
extern id g_active_banner_text; /* color of text in banner */
extern id g_highlight_bar; /* color menu selector bar */
extern id g_highlight_bar_text; /* color foreground highlight_bar */
extern id g_inactive_border; /* color frame non-current */
extern id g_inactive_title_bar; /* color of title background non-current */
extern id g_inactive_title_text; /* color of title text when non-current */
extern id g_screen; /* color of screen (screen background) */ 
extern id g_slk_bar; /* color of background of slk_text */
extern id g_slk_text; /* color of screen-labeled function key text */
extern id g_window_text; /* color of text in a frame */  
extern id g_interrupt; /* boolean, whether actions can be interrupted */
extern id g_nobang; /* if set, no shell escapes */
extern id g_oninterrupt; /* action on interrupt */
extern id g_permanentmsg; /* message line text */
extern id g_slk_layout; /* 4-4 or 3-2-3 */
extern id g_toggle; /* always, integer, or never */

