#!/bin/sh
src=`pwd`
tmp=$src/tests-tmp
rm -rf $tmp
mkdir -p $tmp
PATH="$src:/bin:/usr/bin:/usr/local/bin"
tests_failed=0
tests_count=0
CVM_PWFILE_PATH=$tmp/pwfile
export CVM_PWFILE_PATH
make_pwfile()
{
  (
    echo 'pwfuser:testpass:123:456:Gecos,xyz:/home/ftp:/bin/false'
    echo 'cryptuser:tpzv1IkcX9.fE:234:567:Crypt:/home/crypt:/bin/true'
  ) >$CVM_PWFILE_PATH
}

run_compare_test() {
  local name=$1
  shift
  sed -e "s:@SOURCE@:$src:g" >$tmp/expected
  ( runtest "$@" ) 2>&1 >$tmp/actual-raw
  cat -v $tmp/actual-raw >$tmp/actual
  if ! cmp $tmp/expected $tmp/actual >/dev/null 2>&1
  then
    echo "Test $name $@ failed:"
	( cd $tmp; diff -u9999 expected actual )
	let tests_failed=tests_failed+1
  fi
  rm -f $tmp/expected $tmp/actual
  let tests_count=tests_count+1
}

##### Test tests/command-bad-username #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pxfuser '' testpass
}
run_compare_test tests/command-bad-username  <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS


##### Test tests/command-bad-password #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpassx
}
run_compare_test tests/command-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS


##### Test tests/command-no-prefix #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/command-no-prefix  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/pwfile-crypt #####

runtest() {
make_pwfile
CVM_PWFILE_PWCMP=crypt export CVM_PWFILE_PWCMP
./cvm-testclient ./cvm-pwfile cryptuser '' testpass
}
run_compare_test tests/pwfile-crypt  <<END_OF_TEST_RESULTS
user name:        cryptuser
user ID:          234
group ID:         567
real name:        Crypt
directory:        /home/crypt
shell:            /bin/true
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/pwfile #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/pwfile  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/command-case #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile PWFUser '' testpass
}
run_compare_test tests/command-case  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/command-prefix #####

runtest() {
make_pwfile
./cvm-testclient cvm-command:./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/command-prefix  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/start-pwfile-udp #####

runtest() {
./cvm-pwfile cvm-udp:127.1.2.3:12345 >$tmp/log &
echo $! >$tmp/pid
sleep 1
cat $tmp/log
}
run_compare_test tests/start-pwfile-udp  <<END_OF_TEST_RESULTS
Starting.
END_OF_TEST_RESULTS


##### Test tests/pwfile-udp-bad-password #####

runtest() {
make_pwfile
./cvm-testclient cvm-udp:127.1.2.3:12345 pwfuser '' testpaxx
tail -1 $tmp/log
}
run_compare_test tests/pwfile-udp-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
- pwfuser@
END_OF_TEST_RESULTS


##### Test tests/pwfile-udp #####

runtest() {
make_pwfile
./cvm-testclient cvm-udp:127.1.2.3:12345 pwfuser '' testpass
tail -1 $tmp/log
}
run_compare_test tests/pwfile-udp  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
+ pwfuser@
END_OF_TEST_RESULTS


##### Test tests/stop-pwfile-udp #####

runtest() {
kill `cat $tmp/pid`
rm -f $tmp/pid
sleep 1
tail -1 $tmp/log
echo `cat $tmp/log | wc`
rm -f $tmp/log
}
run_compare_test tests/stop-pwfile-udp  <<END_OF_TEST_RESULTS
Stopping.
4 6 42
END_OF_TEST_RESULTS


##### Test tests/start-pwfile-local #####

runtest() {
./cvm-pwfile cvm-local:$tmp/socket >$tmp/log &
echo $! >$tmp/pid
sleep 1
cat $tmp/log
}
run_compare_test tests/start-pwfile-local  <<END_OF_TEST_RESULTS
Starting.
END_OF_TEST_RESULTS


##### Test tests/pwfile-local #####

runtest() {
make_pwfile
./cvm-testclient cvm-local:$tmp/socket pwfuser '' testpass
tail -1 $tmp/log
}
run_compare_test tests/pwfile-local  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
+ pwfuser@
END_OF_TEST_RESULTS


##### Test tests/pwfile-local-bad-password #####

runtest() {
make_pwfile
./cvm-testclient cvm-local:$tmp/socket pwfuser '' testpaxx
tail -1 $tmp/log
}
run_compare_test tests/pwfile-local-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
- pwfuser@
END_OF_TEST_RESULTS


##### Test tests/stop-pwfile-local #####

runtest() {
kill `cat $tmp/pid`
rm -f $tmp/pid
sleep 1
tail -1 $tmp/log
echo `cat $tmp/log | wc`
rm -f $tmp/log
test -e $tmp/socket || echo Socket was removed.
}
run_compare_test tests/stop-pwfile-local  <<END_OF_TEST_RESULTS
Stopping.
4 6 42
Socket was removed.
END_OF_TEST_RESULTS


rm -rf $tmp
echo $tests_count tests executed, $tests_failed failures
if [ $tests_failed != 0 ]; then exit 1; fi
