#!/bin/sh
exec ruby -w -x $0 ${1+"$@"} # -*- ruby -*-
#!ruby -w

# $Id: cvsdeltarun.rb,v 1.9 2004/02/17 02:33:01 jeugenepace Exp $

# cvsdelta: summarizes CVS changes and executes the appropriate commands

require './cvsdeltaopt'
require './cvsdelta'

$stdout.sync = true             # unbuffer output
$stderr.sync = true             # unbuffer output
$stdin.sync  = true             # unbuffer input

$PACKAGE = "cvsdelta"
$VERSION = "1.6.9"

begin
  options = CVSDeltaOptions.new($PACKAGE, $VERSION)
  options.run

  Log.verbose = options.verbose
  # Log.output = "/tmp/cvsdelta.log." + Process.pid.to_s
  Log.set_widths(15, -5, -35)

  # we should be running this from a CVS'ed directory
  unless File.exists?("CVS")
    $stderr.print "this directory does not appear to be part of a CVS project\n"
  end

  delta = CVSDelta.new(options, ARGV)
  delta.run
  delta.print_change_summary

  if options.execute
    exec = CVSExecute.new(delta.added, delta.deleted)
    exec.confirm = options.confirm
    exec.run
  end
rescue => e
  # show only the message, not the stack trace:
  $stderr.puts "error: #{e}"
end
