/*	cvsnt control panel
    Copyright (C) 2004-5 Tony Hoyle and March-Hare Software Ltd

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License version 2.1 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
// cvsnt1.cpp: implementation of the CcvsntCPL class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cvsnt.h"
#include "cvsnt1.h"
#include "serverPage.h"
#include "RepositoryPage.h"
#include "SettingsPage.h"
#include "CompatibiltyPage.h"
#include "AdvancedPage.h"
#include "ProtocolsPage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CcvsntCPL::CcvsntCPL()
{
	CoInitialize(NULL);
}

CcvsntCPL::~CcvsntCPL()
{
}

BOOL CcvsntCPL::DoubleClick(UINT uAppNum, LONG lData)
{
	WSADATA wsa = {0};
	WSAStartup(MAKEWORD(2,0),&wsa);

	CPropertySheet sheet(_T("CVSNT"));

	sheet.m_psh.hIcon = AfxGetApp()->LoadIcon(IDI_ICON1);
	sheet.m_psh.dwFlags |= PSH_USEHICON;

	sheet.AddPage(new CserverPage);
	sheet.AddPage(new CRepositoryPage);
	sheet.AddPage(new CSettingsPage);
	sheet.AddPage(new CCompatibiltyPage);
	sheet.AddPage(new CProtocolsPage);
	sheet.AddPage(new CAdvancedPage);
	sheet.DoModal();
	return TRUE;
}

BOOL CcvsntCPL::Exit()
{
	return TRUE;
}

LONG CcvsntCPL::GetCount()
{
	return 1;
}

BOOL CcvsntCPL::Init()
{
	return TRUE;
}

BOOL CcvsntCPL::Inquire(UINT uAppNum, LPCPLINFO lpcpli)
{
	lpcpli->idIcon=IDI_ICON1;
	lpcpli->idInfo=IDS_DESCRIPTION;
	lpcpli->idName=IDS_NAME;
	return TRUE;
}

BOOL CcvsntCPL::NewInquire(UINT uAppNum, LPNEWCPLINFO lpcpli)
{
	return FALSE;
}

BOOL CcvsntCPL::Stop(UINT uAppNum, LONG lData)
{
	return TRUE;
}

/* Generic SHBrowseForFolder callback */
int CALLBACK BrowseValid(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	switch(uMsg)
	{
	case BFFM_INITIALIZED:
		return 0;
	case BFFM_SELCHANGED:
		{
			TCHAR fn[MAX_PATH];
			TCHAR shortfn[4];
			LPITEMIDLIST idl = (LPITEMIDLIST)lParam;
			BOOL bOk = SHGetPathFromIDList(idl,fn);
			_tcsncpy(shortfn,fn,3);
			shortfn[3]='\0';
			if(bOk && (!_tcsnicmp(fn,_T("\\\\"),2) || !_tcsnicmp(fn,_T("//"),2)))
			{
				bOk=FALSE;
				SendMessage(hWnd,BFFM_SETSTATUSTEXT,NULL,(LPARAM)"UNC Paths are not allowed");
			}
			if(bOk && GetDriveType(shortfn)==DRIVE_REMOTE)
			{
				bOk=FALSE;
				SendMessage(hWnd,BFFM_SETSTATUSTEXT,NULL,(LPARAM)"Network drives are not allowed");
			}
			SendMessage(hWnd,BFFM_ENABLEOK,NULL,bOk);
		}
		return 0;
	case BFFM_VALIDATEFAILED:
		return -1;
	}
	return 0;
}
