#ifndef XDIFF__H
#define XDIFF__H

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*xdiff_function_t)(const char *name, const char *file1, const char *file2, const char *label1, const char *label2, int argc, const char *const*argv, int (*output_fn)(const char *,size_t));

#ifdef _WIN32
#ifndef XDIFF_EXPORT
#define XDIFF_EXPORT __declspec(dllexport)
#endif
#else
#define XDIFF_EXPORT
#endif

/* Every xdiff DLL should export this function */
/* label1 and label2 are labels as passed to gnu diff in the default implementation */
/* file1 and file2 may be temporary filenames - the file type should be derived from name only */
int XDIFF_EXPORT xdiff_function(const char *name, const char *file1, const char *file2, const char *label1, const char *label2, int argc, const char *const*argv, int (*output_fn)(const char *,size_t));

#ifdef __cplusplus
}
#endif

#endif
