"""
Convex optimization solvers.

conelp:  solves cone programs.
cp:      solves nonlinear convex problems.
lp:      solves linear programs.
gp:      solves geometric programs.
nlcp:    solves nonlinear convex problems specified via functions.
qp:      solves quadratic programs.
sdp:     solves semidefinite programs.
socp:    solves second-order cone programs.
options: dictionary with customizable algorithm parameters.
"""

# Copyright 2004-2007 J. Dahl and L. Vandenberghe.
# 
# This file is part of CVXOPT version 0.9.
#
# CVXOPT is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# CVXOPT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cvxopt
from cvxopt.cvxprog import cp, qp, gp, nlcp
from cvxopt.coneprog import conelp, lp, sdp, socp
solvecp, solveqp, solvegp, solvelp, solvesdp = cp, qp, gp, lp, sdp
options = {}
cvxopt.cvxprog.options = options
cvxopt.coneprog.options = options
__all__ = ['conelp', 'cp', 'lp', 'gp', 'nlcp', 'qp', 'sdp', 'socp']
