if version < 600
	syntax clear
elseif exists("b:current_syntax")
	finish
endif

syn match cwcdrTrack "^[0-9]*" nextgroup=cwcdrTrackSep
syn match cwcdrTrackSep contained "|" nextgroup=cwcdrArtist

syn match cwcdrArtist contained "[^|]\+" contains=cwcdrError nextgroup=cwcdrArtistSep
syn match cwcdrArtistSep contained "|" nextgroup=cwcdrAlbum

syn match cwcdrAlbum contained "[^|]\+" contains=cwcdrError nextgroup=cwcdrAlbumSep
syn match cwcdrAlbumSep contained "|" nextgroup=cwcdrYear

syn match cwcdrYear contained "[0-9]*" nextgroup=cwcdrYearSep
syn match cwcdrYearSep contained "|" nextgroup=cwcdrTitle

syn match cwcdrTitle contained "[^|]\+" contains=cwcdrError nextgroup=cwcdrTitleSep
syn match cwcdrTitleSep contained "|" nextgroup=cwcdrOrig

syn match cwcdrOrig contained "[^|]\+"

syn match cwcdrError contained "[^']\<[a-z]\|[[:space:]]\{2,}\|[[:space:]]\+$"



"syn match line "^.*$" contains=track,trackSep,artist,artistSep,album,albumSep,year,yearSep,title

if version >= 508 || !exists("did_bc_syn_inits")
	if version < 508
		let did_bc_syn_inits = 1
		command -nargs=+ HiLink hi link <args>
	else
		command -nargs=+ HiLink hi def link <args>
	endif
	HiLink cwcdrTrack	Number
	HiLink cwcdrArtist	Statement
	HiLink cwcdrAlbum	Ignore
	HiLink cwcdrYear	Number
	HiLink cwcdrTitle	Type
	HiLink cwcdrTitle	Boolean
	HiLink cwcdrOrig	PreProc
	HiLink cwcdrError	Error
	delcommand HiLink
endif

let b:current_syntax = "cwcdr"
