/* InfoDisplayController.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002, 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef InfoDisplayController_H
#define InfoDisplayController_H

@class NSImageView;
@class NSObject;
@class NSTextField;

@class Song;

@interface InfoDisplayController : NSObject
{
  NSImageView *splashImage;

  NSTextField *songArtistField;
  NSTextField *songAlbumField;
  NSTextField *songNumberField;
  NSTextField *songTimerField;
  NSTextField *songTitleField;
#ifdef __MACOSX__
  NSButton *songTimerBtn;
#endif

  BOOL reverseTimer;
  unsigned int totalTime;
}

- (void) show;
- (void) hide;

- (void) updateInfoFieldsFromSong: (Song *) aSong;

- (void) setTimerFromSeconds: (unsigned int) seconds;
- (void) setTimerFromTotalSeconds: (unsigned int) seconds;
- (void) changeTimeDisplay: (id) sender;
- (BOOL) timerIsReversed;

- (void) resetTimerField;

@end

#endif /* InfoDisplayController_H */
