// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#ifndef ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H
#define ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H

#include <Atlas/Objects/Root.h>


namespace Atlas { namespace Objects { namespace Operation { 

/** Base operation for all operators

This is base operation for all other
    operations and defines basic attributes. You can use this as
    starting point for browsing whole operation hiearchy. refno refers
    to operation this is reply for. In examples all attributes that
    are just as examples (and thus world specific) are started with 'e_'.

*/
class RootOperation : public Root
{
public:
    /// Construct a RootOperation class definition.
    RootOperation();
  protected:
    RootOperation(const std::string&,const std::string&);
  public:
    /// Default destructor.
    virtual ~RootOperation();

    /// Create a new instance of RootOperation.
    static RootOperation Instantiate();

    /// Check whether the attribute "name" exists.
    virtual bool HasAttr(const std::string& name)const;
    /// Retrieve the attribute "name". Throws NoSuchAttrException if it does
    /// not exist.
    virtual Atlas::Message::Object GetAttr(const std::string& name)
            const throw (NoSuchAttrException);
    /// Set the attribute "name" to the value given by"attr"
    virtual void SetAttr(const std::string& name,
                         const Atlas::Message::Object& attr);
    /// Remove the attribute "name". This will not work for static attributes.
    virtual void RemoveAttr(const std::string& name);

    /// Send the contents of this object to a Bridge.
    virtual void SendContents(Atlas::Bridge* b) const;

    /// Convert this object to a Message::Object.
    virtual Atlas::Message::Object AsObject() const;

    /// Convert this object to a Message::Object::MapType.
    virtual Atlas::Message::Object::MapType AsMap() const;

    /// Set the "serialno" attribute.
    inline void SetSerialno(long val);
    /// Set the "refno" attribute.
    inline void SetRefno(long val);
    /// Set the "from" attribute.
    inline void SetFrom(const std::string& val);
    /// Set the "to" attribute.
    inline void SetTo(const std::string& val);
    /// Set the "seconds" attribute.
    inline void SetSeconds(double val);
    /// Set the "future_seconds" attribute.
    inline void SetFutureSeconds(double val);
    /// Set the "time_string" attribute.
    inline void SetTimeString(const std::string& val);
    /// Set the "args" attribute.
    inline void SetArgs(const Atlas::Message::Object::ListType& val);

    /// Retrieve the "serialno" attribute.
    inline long GetSerialno() const;
    /// Retrieve the "serialno" attribute as a non-const reference.
    inline long& GetSerialno();
    /// Retrieve the "refno" attribute.
    inline long GetRefno() const;
    /// Retrieve the "refno" attribute as a non-const reference.
    inline long& GetRefno();
    /// Retrieve the "from" attribute.
    inline const std::string& GetFrom() const;
    /// Retrieve the "from" attribute as a non-const reference.
    inline std::string& GetFrom();
    /// Retrieve the "to" attribute.
    inline const std::string& GetTo() const;
    /// Retrieve the "to" attribute as a non-const reference.
    inline std::string& GetTo();
    /// Retrieve the "seconds" attribute.
    inline double GetSeconds() const;
    /// Retrieve the "seconds" attribute as a non-const reference.
    inline double& GetSeconds();
    /// Retrieve the "future_seconds" attribute.
    inline double GetFutureSeconds() const;
    /// Retrieve the "future_seconds" attribute as a non-const reference.
    inline double& GetFutureSeconds();
    /// Retrieve the "time_string" attribute.
    inline const std::string& GetTimeString() const;
    /// Retrieve the "time_string" attribute as a non-const reference.
    inline std::string& GetTimeString();
    /// Retrieve the "args" attribute.
    inline const Atlas::Message::Object::ListType& GetArgs() const;
    /// Retrieve the "args" attribute as a non-const reference.
    inline Atlas::Message::Object::ListType& GetArgs();

protected:
    long attr_serialno;
    long attr_refno;
    std::string attr_from;
    std::string attr_to;
    double attr_seconds;
    double attr_future_seconds;
    std::string attr_time_string;
    Atlas::Message::Object::ListType attr_args;

    inline void SendSerialno(Atlas::Bridge*) const;
    inline void SendRefno(Atlas::Bridge*) const;
    inline void SendFrom(Atlas::Bridge*) const;
    inline void SendTo(Atlas::Bridge*) const;
    inline void SendSeconds(Atlas::Bridge*) const;
    inline void SendFutureSeconds(Atlas::Bridge*) const;
    inline void SendTimeString(Atlas::Bridge*) const;
    inline void SendArgs(Atlas::Bridge*) const;

};

//
// Inlined member functions follow.
//

void RootOperation::SetSerialno(long val)
{
    attr_serialno = val;
}

void RootOperation::SetRefno(long val)
{
    attr_refno = val;
}

void RootOperation::SetFrom(const std::string& val)
{
    attr_from = val;
}

void RootOperation::SetTo(const std::string& val)
{
    attr_to = val;
}

void RootOperation::SetSeconds(double val)
{
    attr_seconds = val;
}

void RootOperation::SetFutureSeconds(double val)
{
    attr_future_seconds = val;
}

void RootOperation::SetTimeString(const std::string& val)
{
    attr_time_string = val;
}

void RootOperation::SetArgs(const Atlas::Message::Object::ListType& val)
{
    attr_args = val;
}

long RootOperation::GetSerialno() const
{
    return attr_serialno;
}

long& RootOperation::GetSerialno()
{
    return attr_serialno;
}

long RootOperation::GetRefno() const
{
    return attr_refno;
}

long& RootOperation::GetRefno()
{
    return attr_refno;
}

const std::string& RootOperation::GetFrom() const
{
    return attr_from;
}

std::string& RootOperation::GetFrom()
{
    return attr_from;
}

const std::string& RootOperation::GetTo() const
{
    return attr_to;
}

std::string& RootOperation::GetTo()
{
    return attr_to;
}

double RootOperation::GetSeconds() const
{
    return attr_seconds;
}

double& RootOperation::GetSeconds()
{
    return attr_seconds;
}

double RootOperation::GetFutureSeconds() const
{
    return attr_future_seconds;
}

double& RootOperation::GetFutureSeconds()
{
    return attr_future_seconds;
}

const std::string& RootOperation::GetTimeString() const
{
    return attr_time_string;
}

std::string& RootOperation::GetTimeString()
{
    return attr_time_string;
}

const Atlas::Message::Object::ListType& RootOperation::GetArgs() const
{
    return attr_args;
}

Atlas::Message::Object::ListType& RootOperation::GetArgs()
{
    return attr_args;
}


} } } // namespace Atlas::Objects::Operation

#endif // ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H
