DACS_AUTH_TRANSFER(8)      DACS Web Services Manual      DACS_AUTH_TRANSFER(8)



[1mNAME[0m
       dacs_auth_transfer - transfer credentials between federations

[1mSYNOPSIS[0m
       [1mdacs_auth_transfer [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_auth_transfer [22mservice securely exports credentials (which
       represent an identity) from one [1mDACS [22mfederation to another (or from
       [1mDACS [22mto a different identity management system), or securely imports an
       identity from one [1mDACS [22mfederation to another (or from a different
       identity management system to [1mDACS[22m). This ability to [4mtransfer[0m
       credentials (i.e., import or export them) lets a [1mDACS [22mfederation
       federate with another system, creating a "super federation" with single
       sign-on capability.  [1mDACS [22mcalls such federations affiliated
       federations.

       A [1mDACS [22mfederation can use [1mdacs_auth_transfer [22mto leverage authentication
       mechanisms not available to it, other systems can use it to leverage
       [1mDACS[22m, and users can potentially access any access-controlled resource
       located in any of the cooperating federations.

           [1mIn a Nutshell[0m
           For two [1mDACS [22mfederations, here is how the service is typically
           used. A user authenticates somewhere in Federation A, obtaining
           credentials understood only in that federation. One or more
           jurisdictions in Federation A will provide a link labelled
           "Transfer Login To Federation B" (or similar). Alternatively, or
           additionally, one or more jurisdictions in Federation B may provide
           a link labelled "Transfer Login From Federation A". Later, when the
           user decides to access resources in Federation B, he follows one of
           the links. Assuming all access control constraints are satisfied,
           new credentials will be returned to him that are understood in
           Federation B. His existing Federation A credentials continue to
           exist.

           The user is now recognized by both federations. If the user is
           known as FedA::J1:bobo in Federation A, then he will also be known
           by that name in Federation B. If Federation B happens to have a
           jurisdiction named J1 and a user at that jurisdiction named bobo,
           that user (FedB::J1:bobo) is separate and distinct as far as [1mDACS[0m
           is concerned.

           Note that, in general, it is not correct in the scenario above for
           Federation B to automatically initiate a credential transfer if an
           unauthenticated user (with respect to Federation B) is denied
           access. This is because Federation B cannot tell with which
           federation it should be initiated (if there is more than one) or
           even if this is something that the user wants done (perhaps the
           user needs to authenticate in the usual way at Federation A).
           Therefore, except perhaps in special circumstances, explicit user
           interaction is necessary.

       For [1mDACS[22m, the complete protocol is implemented by one program,
       [1mdacs_auth_transfer[22m. It provides the importing, exporting, and
       server-to-server stages of the protocol and it can also optionally
       assist middleware with the initial presentation stage of the protocol.
       The protocol is described below.

       If an identity needs to be imported to a non-[1mDACS [22msystem, that system
       must implement the identity transfer protocol described here, or a
       subset of it. If a non-[1mDACS [22monly needs to export an identity to a [1mDACS[0m
       federation, it may only need a small amount of middleware to initiate
       the transfer.

           [1mSecurity[0m
            1. A small degree of cooperation is required between [1mDACS[0m
               administrators at two affiliated federations so that they each
               know how to configure the feature. The two federations remain
               autonomous, however.

            2. Transferring credentials [4mto[24m a [1mDACS [22mfederation neither creates a
               new account nor creates a new identity. It merely converts
               credentials that were obtained in one federation into [1mDACS[0m
               credentials that are recognized within another federation.
               Because a [1mDACS [22muser identity includes a federation name, among
               federated [1mDACS [22msystems a user's identity is unique. After
               transfer to a different federation, the original credentials
               continue to exist and are unaltered.

            3. Exporting credentials to another federation and later
               transferring them back to the initial [1mDACS [22mfederation (or
               exporting credentials within a federation) will replace the
               initial credentials with new ones for the same identity. The
               two sets of credentials will not be identical, however, and the
               imported ones may be less complete and therefore "weaker" than
               the original credentials with respect to authorization
               processing.

            4. System administrators should ensure that [1mdacs_auth_transfer [22mis
               configured so that it is impossible to import credentials to a
               federation from which they were exported, otherwise it may be
               possible for users to defeat the expiry of credentials by
               repeatedly regenerating them.

            5. The identity transfer protocol includes a server-to-server
               operation that must use SSL. The identity of the server issuing
               the request must be verified, either through its X.509 (SSL)
               client certificate, [1mDACS [22mcredentials, or perhaps its IP
               address.

            6. As an additional security measure, a jurisdiction will only
               accept credentials for an identity outside of its federation if
               enabled by [34m[1mACCEPT_ALIEN_CREDENTIALS[0m[1m[22m[2].

            7. While this document talks in terms of a [1mDACS [4m[22mfederation[0m
               importing credentials, importation actually takes place at a
               [1mDACS [4m[22mjurisdiction[24m, just as authentication does. That target
               jurisdiction is similarly responsible for the resulting
               credentials and is identified within the new credentials for
               access control testing and audit purposes.

            8. Any appropriately configured jurisdiction is capable of
               exporting or importing credentials. Some federations might
               choose to create "administrative jurisdictions" solely for this
               purpose (e.g., export.example.com and import.example.com),
               however, just as a federation might be structured to limit
               authentication services to a designated jurisdiction.

   [1mThe Identity Transfer Protocol[0m
       [1mOverview[0m
           The ability to transfer credentials from one identity management
           system to another is a feature that can be beneficial to both users
           and system administrators. For users, it can provide the
           convenience of single sign-on; a user need only be authenticated by
           one federation to be able to access resources within a different
           federated system. For a system administrator, it means that fewer
           user identities need to be created and managed.

           The systems being federated might exist within a single
           organization or be associated with different, autonomous
           organizations that have a trust relationship, very much as [1mDACS[0m
           jurisdictions do. The transfer of credentials need not be
           reciprocal; that is, Federation A may allow identities to be
           imported from Federation B but not [4mvice[24m [4mversa[24m.

           The architecture of the transfer mechanism is primarily constrained
           by the typical browser-oriented usage of [1mDACS[22m, where credentials
           are encapsulated within an HTTP cookie, thereby dictating how
           credentials are set in an off-the-shelf browser and when
           credentials will be sent by the browser. The approach is
           complicated somewhat because a [1mDACS [22muser may have multiple
           concurrent credentials or may be unauthenticated. Also, a [1mDACS[0m
           federation may wish to federate with more than one foreign
           federation. Therefore, interaction with the user will sometimes be
           necessary so that she can select the particular identity to be
           transferred and a [4mtarget[24m [4mfederation[24m to which that identity is to be
           transferred. A jurisdiction or federation must be able to customize
           this interaction for appropriate web site integration (i.e., look
           and feel), but a bare-bones capability must still be provided by
           [1mdacs_auth_transfer[22m.

           The design tries to balance security, usability, performance,
           availability, configuration complexity, implementation effort,
           administrative needs, generality, and extensibility, all within the
           constraints of the [1mDACS [22marchitecture and requirements.

           Though it is assumed that SSL is used to secure all network
           communication and identify the communicating hosts where necessary,
           some major potential threats against a transfer capability must be
           addressed by the design:

            1. [4mReplay[24m: the system must prevent the malicious or accidental use
               of expired credentials, reuse of authentication material by a
               different browser user (such as through browser history or a
               bookmark), use of authentication material discovered in a log
               file, and so on

            2. [4mForgery[24m [4mand[24m [4mTampering[24m: the system must prevent a malicious user
               from changing authentication material to get different or
               "better" credentials using the transfer protocol

       Replay is addressed in the transfer protocol by restricting the
       exposure of authentication and protocol material and by limiting its
       validity period. Injection of copied material is also made difficult.
       Forgery and tampering are addressed through cryptographic means; using
       well-established techniques, it is thought to be practically impossible
       to create forged authentication material or modify it undetectably.

           [1mSecurity[0m
           Importation of identities has federation-wide ramifications but it
           is the responsibility of each jurisdiction to decide whether it
           will allow its [1mdacs_auth_transfer [22mservice to import an identity or
           its rules to honour an identity imported by another jurisdiction
           within the federation. A jurisdiction may independently allow
           identities to be imported from an external system, just as it may
           unilaterally decide whether it will authenticate users and how it
           will do so. On the other hand, a jurisdiction is free to reject
           imported identities, just as it is free to reject an identity
           vouched for by another jurisdiction in its federation. Federation
           members may wish to establish guidelines and procedures for
           importing identities.

       [1mProtocol Operation[0m
           The purpose of the protocol is to transfer an identity understood
           by the initial federation to the [4mtarget[24m [4mfederation[24m. The initial
           federation [4mexports[24m an identity; the target federation [4mimports[24m the
           identity.

           The four stages (operations) of the protocol are now described, in
           the order in which they are used. In all cases, "the user" can be a
           browser or middleware.



            1. The PRESENTATION operation, which is performed in the initial
               federation and is optional, is used for prompting the user to
               select the credentials to be transferred and identify the
               target federation. The purpose of the PRESENTATION operation is
               simply to make it easier for a user or middleware to invoke the
               EXPORT operation; the EXPORT operation can be invoked directly
               without engaging in this step of the protocol, however.

            2. The EXPORT operation is invoked at the initial federation by a
               user to request that the initial federation initiate the
               transfer of credentials representing a given identity to a
               given federation. After receiving and validating its arguments,
               the EXPORT operation invokes the TOKEN operation at the target
               federation. If the target federation tentatively approves the
               importation of the identity, it returns a URL to which the
               EXPORT stage redirects the user. If the target federation
               rejects the request (or the request fails), the EXPORT stage
               returns an error indication that should be reflected back to
               the user and terminates the protocol.

            3. The TOKEN operation is the heart of the protocol. By invoking
               it at the target federation, the initial federation vouches for
               the identity to be transferred and requests that the target
               federation honour the user's request for credentials valid
               within the target federation; the latter is free to reject the
               request for any reason. To accomplish the transfer, the initial
               federation requests a token from the target federation.

               A token is cryptographically protected, opaque information
               encapsulated within a URL as its query component; the token is
               meaningful only to the target federation (i.e., its meaning is
               unspecified by the protocol). It could contain a database key
               for the transaction, a nonce, or a self-contained description
               of the transaction. All that is required by the protocol is
               that it be kept secret among the communicating parties for as
               long as it is valid, that its validity period be no longer than
               what is required to complete the last stage of identity
               transfer, that it be difficult to forge, and that it be
               tamper-resistant.

               If the request for a token is granted, the target federation
               returns a URL that encapsulates it, otherwise an error
               indication is returned to the initial federation which in turn
               returns an error indication to the user and terminates the
               protocol.

            4. The IMPORT request is sent by the user to the target
               federation. A complete URL containing the IMPORT request will
               typically be created by the target federation, returned to the
               initial federation, and forwarded to the user as a browser
               redirect by the EXPORT stage. Upon successfully validating the
               request, which includes an examination of the token and
               checking for revocation of the identity (see [34m[1mdacs.acls(5)[0m[1m[22m[3]
               for a description of how authentication/access revocation
               works), the target federation returns credentials (as an HTTP
               cookie) that are returned to the user in the final step of the
               IMPORT operation - this is the end-goal of the protocol - and
               the user is redirected by the target federation to an
               appropriate "success" URL as a convenience to the user. If the
               transfer fails, no new credentials are returned and the user is
               redirected to an appropriate "failure" URL by the target
               federation.


       [1mImplementation[0m
           The [1mdacs_auth_transfer [22mservice implements all of the stages as
           separate operations of a single web service; a different
           implementation might create separate services for each stage or
           operation, or implement a subset of the functionality (e.g., it
           might only support exporting identities).

           Each of the federating systems must be assigned a unique name (for
           [1mDACS[22m, through the FEDERATION_NAME directive) so that identities can
           be globally unique.  [4mThe[24m [4mfederating[24m [4msystems[24m [4mneed[24m [4mnot[24m [4mshare[24m [4ma[24m [4mcommon[0m
           [4mdomain[24m [4mname[24m [4msuffix[24m.

               [1mNote[0m
               In the current implementation of [1mdacs_auth_transfer[22m,
               configuration information associated with target federations is
               not automatically distributed by [1mDACS [22mto a federation's
               jurisdictions. This means that only those jurisdictions that
               have been specifically configured to import identities will be
               able to do so; a jurisdiction will not automatically understand
               how to interact with a given target federation that is
               configured at a different jurisdiction. Each jurisdiction's
               administrator wanting to provide this service must configure
               his site's [1mdacs_auth_transfer [22mservice appropriately.

           Details of the [1mdacs_auth_transfer [22mimplementation and configuration
           requirements are now presented. A different implementation of the
           protocol could look very different.

           PRESENTATION

               [1mdacs_auth_transfer [22mcan emit an HTML document to prompt the user
               (by default, using the style sheet [34m[1mdacs_auth_transfer.css[0m[1m[22m[4]).
               The user selects an identity and target federation and submits
               a form. Alternatively, the information necessary to construct
               prompts can be returned within an XML document that conforms to
               [34m[1mdacs_auth_transfer.dtd[0m[1m[22m[5]. A site is also free to implement its
               own presentation stage.

               The list of known target federation names from which a user can
               select is obtained from mappings that have been configured at
               this jurisdiction (see below).

               When emitting HTML, the web page generated by
               [1mdacs_auth_transfer [22mcan be customized through the auth_transfer
               VFS item type. The following items are emitted if they exist:

               +o   header: Initial HTML to emit instead of the default.

               +o   prologue: HTML to emit immediately after the header.

               +o   instructions: HTML to emit immediately after the prologue
                   and before the form.

               +o   form: Additional HTML to emit within the form. A likely use
                   of this is to specify a hidden [4mTRANSFER_SUCCESS_URL[0m
                   argument.

               +o   epilogue: HTML to emit immediately after the form.

               +o   trailer: Final HTML to emit instead of the default.
                   For example, consider the configuration directive:

                       VFS "[auth_transfer]dacs-fs:${Conf::DACS_HOME}/auth_transfer"

                   If files named header and trailer exist in the directory
                   ${Conf::DACS_HOME}/auth_transfer, they are expected to
                   contain the initial and final HTML content, respectively.
                   Note that these files consist of text and HTML markup but
                   are not complete HTML documents.

                   Customization of the HTML form is possible using
                   configuration variables:

                   +o   [4mtransfer_export_uri[24m: the URL of the program to which
                       the form should be submitted. By default, the URL is
                       created from the one used to invoke the presentation
                       stage, which will usually be that of
                       [1mdacs_auth_transfer[22m.

                   +o   [4mtransfer_submit_label[24m: the text label to put in the
                       form's submit button.

                   +o   [4mtransfer_submit_method[24m: the HTTP method to use to
                       submit the form (GET is the default).
                       For example, the submit button's text can be specified
                       using the directive:

                           EVAL ${Conf::transfer_submit_label} = "Execute the transfer!"


                   EXPORT
                       The identity to be transferred and the name of the
                       target federation are submitted to [1mdacs_auth_transfer[0m
                       as arguments of the EXPORT operation. The request must
                       be accompanied by [1mDACS [22mcredentials that match this
                       identity and the target federation must be recognized
                       by the receiving jurisdiction.

                       For example, this URL asks the jurisdiction associated
                       with example.com to export the identity EXAMPLE:bobo to
                       the target federation DSS:

                           https://example.com/dacs/dacs_auth_transfer?OPERATION=EXPORT\
                               &TARGET_FEDERATION=DSS\
                               &DACS_IDENTITY=EXAMPLE:bobo

                       For the request to succeed, credentials for
                       EXAMPLE:bobo must be sent with the request, permission
                       must be granted (by example.com) to export the
                       identity, example.com must be configured with an
                       appropriate mapping, described below, such that it
                       knows how to submit a TOKEN request to a service
                       associated with federation DSS, and that service must
                       allow importation of the identity.

                       The mappings of federation identifiers to URLs for
                       export purposes are provided through the
                       [34m[1mAUTH_TRANSFER_EXPORT[0m[1m[22m[6] directive. That is, these
                       mappings indicate which target federations have been
                       configured at this jurisdiction and associate a target
                       federation identifier (a short, descriptive keyword)
                       with a URL of a web service that implements the TOKEN
                       operation for the target federation. It is from these
                       mappings that the list of selectable target federations
                       is obtained.

                           [1mNote[0m
                           Unless jurisdictions coordinate mappings with each
                           other, the same jurisdiction must perform both the
                           PRESENTATION and EXPORT operations.
                       For example, dacs.conf might include the directive:

                           AUTH_TRANSFER_EXPORT "DSS https://dacs.dss.ca/cgi-bin/dacs/dacs_auth_transfer"

                       This directive specifies one target federation,
                       identified by the name DSS, and associates it with the
                       URL of a service implementing the TOKEN operation.

                           [1mSecurity[0m
                           The TOKEN operation must be performed over a secure
                           communication channel, typically using SSL. URLs
                           appearing in these mappings should therefore
                           specify https. The issuer of the TOKEN operation
                           may identify itself using an SSL client
                           certificate; if [34m[1mSSL_PROG_CLIENT_CRT[0m[1m[22m[7] is
                           configured, that certificate will automatically be
                           used.

                           If the issuer of the TOKEN operation possesses [1mDACS[0m
                           credentials obtained offline from the target
                           federation (e.g., using [34m[1mdacscookie(1)[0m[1m[22m[8]), it can
                           specify that they be sent with the request by
                           putting them in an object named [4mFEDNAME[24m.cookies
                           relative to the auth_transfer item type. directory
                           ${Conf::DACS_HOME}/auth_transfer, one cookie per
                           line. The [4mFEDNAME[24m filename suffix is the federation
                           identifier for the importing federation.

                           For instance, given the AUTH_TRANSFER_EXPORT
                           directive and the VFS directive for auth_transfer
                           above, all cookies found in a file named
                           /usr/local/dacs/auth_transfer/DSS.cookies would be
                           sent with the TOKEN operation to identify the
                           initial federation. These cookies would have been
                           obtained from federation DSS over a secure
                           communication channel.

                   TOKEN
                       The syntax and semantics of a token are meaningful only
                       to the target federation and can be changed without
                       affecting any initial federation. In the current
                       implementation, the token is comprised of information
                       such as the identity to be transferred, the current
                       date at the transfer federation, the client's IP
                       address, and (optionally) the client's role string,
                       which is encrypted using the target federation's
                       federation-wide key and base-64 encoded.

                           [1mNote[0m
                           The identity to be transferred must be a
                           syntactically valid [1mDACS [22musername.
                       The period during which a token is valid is determined
                       solely by the target federation. Its lifetime will
                       ordinarily be just a few seconds, after which it will
                       be treated as invalid by the IMPORT stage. The
                       [34m[1mAUTH_TRANSFER_TOKEN_LIFETIME_SECS[0m[1m[22m[9] directive
                       specifies this value for [1mdacs_auth_transfer[22m; if not
                       given, a compile-time default is used.

                       A jurisdiction within the target federation that
                       provides identity importation must must configure at
                       least one Transfer clause. The transfer directives are
                       largely analogous to the authentication and roles
                       directives. Each Transfer element must have an id
                       attribute. Its value is merely a label (an alphabetic
                       followed by zero or more alphanumerics, hyphens, and
                       underscores) that allows the clause to be referenced.
                       The id attribute values must be unique
                       (case-sensitively) within the clause's Jurisdiction
                       section.

                           [1mSecurity[0m
                           +o   An access control rule must be in place to
                               ensure that this operation can only be executed
                               by a legitimate server belonging to a
                               recognized initial federation.

                           +o   The caller may not have supplied [1mDACS[0m
                               credentials to identify itself and therefore
                               the [34m[1muser()[0m[1m[22m[10] function may not be of use.

                       [1mTransfer Clause Directives Index:[0m

                        1. CREDENTIALS_LIFETIME_SECS (Optional1)

                        2. ERROR_URL (Optional1)

                        3. EXIT* (Optional1)

                        4. IMPORT_FROM (Required)

                        5. IMPORT_ROLES (Optional1)

                        6. IMPORT_URL (Optional1)

                        7. PREDICATE (Optional1)

                        8. REFEDERATE (Optional1)

                        9. ROLES* (Optional1)

                       10. SUCCESS_URL (Optional1)

                       IMPORT_FROM (Required)
                           This directive, which may be repeated, names an
                           initial federation, as identified by the
                           [4mINITIAL_FEDERATION[24m argument, to which this clause
                           applies. It must be a syntactically valid
                           federation name. These names are case-sensitive.

                       REFEDERATE (Optional1)
                           If "yes" (case insensitive), the federation and
                           jurisdiction of the imported identity (i.e., the
                           [4mDACS_IDENTITY[24m argument) are changed to that of the
                           target jurisdiction. If this directive is
                           unspecified or has another value, the original
                           identity is retained.

                           For example, if the TOKEN operation at jurisdiction
                           ALPHA of federation FED2 is passed [4mDACS_IDENTITY[0m
                           with a value of FED1::BETA:bobo and REFEDERATE is
                           enabled, then the imported identity will be
                           FED2::ALPHA:bobo .

                               [1mSecurity[0m
                               This directive is useful in certain
                               circumstances in that it can prevent a
                               particular individual from being known by
                               multiple names, which may complicate access
                               control rules. It must be used with care,
                               however.

                               Say Bobo is naturally known as ALPHA:bobo
                               within federation FED2. If she authenticates as
                               FED1::BETA:bobo and uses [1mdacs_auth_transfer [22mto
                               obtain credentials in FED2, then by default her
                               new credentials will be for the name
                               FED1::BETA:bobo; i.e., her [1mDACS [22midentity is
                               retained.

                               Access control rules in FED2 may need to handle
                               both names, however, which can lead to
                               problems. Some [1mDACS [22madministrators in FED2 may
                               not even be aware of FED1, and so access to
                               FED1::BETA:bobo may be denied while access to
                               the same resource may be granted to
                               FED2::ALPHA:bobo.

                               If no two distinct identities in FED1 can be
                               mapped to the same identity in FED2 (i.e., the
                               same [4musername[24m component is not associated with
                               more than one jurisdiction that can export the
                               identity to FED2), then the administrator at
                               the initial federation can advise the
                               administrator at the target federation that the
                               REFEDERATE directive should be enabled.
                               Transferred identities will then be modified to
                               appear to have been authenticated by
                               FED2::ALPHA. When this feature is configured,
                               although Bobo authenticates as FED1::BETA:bobo,
                               her imported identity will be FED2::ALPHA:bobo.

                               If enabling this directive would cause two or
                               more distinct identities to be mapped to the
                               same [1mDACS [22midentity, the directive should not be
                               used because different individuals may be
                               assigned the same [1mDACS [22mname in the target
                               federation.

                       PREDICATE (Optional1)
                           The value of this directive is an expression. If
                           the expression does not evaluate to [1mTrue[22m,
                           importation will not be permitted.

                       CREDENTIALS_LIFETIME_SECS (Optional1)
                           This directive is used to override the value of the
                           [34m[1mAUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS[0m[1m[22m[11]
                           directive or the default.

                       IMPORT_ROLES (Optional1)
                           If "yes" (case insensitive), any roles in the
                           existing credentials will be copied to the new
                           credentials. The roles must be syntactically valid
                           at the target jurisdiction. Within the context of
                           the clause, the variable [4m${Auth::IMPORTED_ROLES}[24m is
                           assigned the roles string. The default is "no".

                       IMPORT_URL (Optional1)
                           This is the URL of the IMPORT stage of the
                           protocol. By default, this is the same as that of
                           the TOKEN stage, which is correct for
                           [1mdacs_auth_transfer [22msince it implements all stages
                           of the protocol.

                       SUCCESS_URL (Optional1)
                           If the transfer is successful and the user has not
                           specified another URL via the [4mTRANSFER_SUCCESS_URL[0m
                           argument, the user will be redirected to
                           SUCCESS_URL. This directive is used by
                           [1mdacs_auth_transfer [22min the IMPORT stage.

                       ERROR_URL (Optional1)
                           If the transfer fails and the user has not
                           specified another URL via the [4mTRANSFER_ERROR_URL[0m
                           argument, the user will be redirected to ERROR_URL.
                           This directive is used by [1mdacs_auth_transfer [22min the
                           IMPORT stage.

                       ROLES* (Optional1)
                           The value of this directive is an expression that
                           is evaluated at run-time. Provided an error does
                           not occur, the resulting string becomes the role
                           string for the new credentials. The new role string
                           must be syntactically valid at the target
                           jurisdiction. The variable [4m${Auth::IMPORTED_ROLES}[0m
                           is initialized to the role string (if any - see
                           IMPORT_ROLES) from the existing credentials and is
                           assigned the value of the expression.

                           For example, to add fed1 to those found in the
                           existing credentials:

                               IMPORT_ROLES "yes"
                               ROLES* '${Auth::IMPORTED_ROLES} . ",fed1"'


                       EXIT* (Optional1)
                           The value of this directive is an expression that
                           is evaluated at run-time. Provided an error does
                           not occur, side effects from the evaluation may
                           alter the final result of the clause. The variable
                           [4m${Auth::IMPORTED_ROLES}[24m is initialized to the role
                           string (if any - see IMPORT_ROLES) from the
                           existing credentials and [4m${Auth::IMPORTED_USERNAME}[0m
                           is assigned the (tentative) imported username
                           component from the imported credentials. Either
                           variable may be modified by the expression. The new
                           role string must be syntactically valid at the
                           target jurisdiction. The new username must be
                           syntactically valid.

                           This directive maps all imported usernames to
                           guest, relative to the target jurisdiction:

                               EXIT* '${Auth::IMPORTED_USERNAME} = "guest"'


                   IMPORT
                       An IMPORT request is validated before being accepted,
                       which includes examining the token and checking for
                       revocation of the identity. There is no guarantee that
                       if the TOKEN operation succeeds the IMPORT operation
                       will also.

                       [1mDACS [22mcredentials imported by [1mdacs_auth_transfer [22mare
                       marked as being alien and imported, the jurisdiction
                       that executed the importation is recorded, and the IP
                       address associated with the user's initial credentials
                       are associated with the new credentials; these
                       characteristics can be tested using the
                       [34m[1mdacs.exprs(5)[0m[1m[22m[10] function.

                           [1mSecurity[0m
                           An access control rule must be in place to ensure
                           that this operation can only be executed by
                           appropriate users. Access might well be granted to
                           any user but might reasonably be restricted based
                           on IP address, etc.

                   To recap, assuming [1mdacs_auth_transfer [22mis used to transfer
                   credentials between two [1mDACS [22mfederations (which we will
                   call [4mFederation[24m [4mA[24m and [4mFederation[24m [4mB[24m) and no errors occur,
                   the flow of control will typically be as follows:

                    1. The user follows a link that invokes [1mdacs_auth_transfer[0m
                       at some jurisdiction within [4mFederation[24m [4mA[24m.

                    2. [1mdacs_auth_transfer [22mgenerates an HTML document that is
                       displayed on the user's browser. The user selects a
                       target federation ([4mFederation[24m [4mB[24m) and credentials to
                       transfer from those presented within an HTML form and
                       submits it, invoking [1mdacs_auth_transfer [22mat [4mFederation[24m [4mA[0m
                       again, but this time to perform the EXPORT operation.
                       The list of credentials from which the user can choose
                       depends on the user's current credentials in [4mFederation[0m
                       [4mA[24m. The list of target federations depends on those
                       known to the jurisdiction that processes the request.

                    3. The [1mdacs_auth_transfer [22mat [4mFederation[24m [4mA[24m processes the
                       EXPORT operation and invokes the TOKEN operation at
                       [4mFederation[24m [4mB[24m. This action is transparent to the user.
                       The response from [4mFederation[24m [4mB[24m is a URL that represents
                       a complete IMPORT operation directed at [4mFederation[24m [4mB[24m.
                       The EXPORT operation redirects the user's browser to
                       that URL.

                    4. Upon receiving the redirect, the user's browser invokes
                       the IMPORT operation at [4mFederation[24m [4mB[24m.  [4mFederation[24m [4mB[0m
                       returns new credentials and redirects the user's
                       browser to a configured or requested URL.


               To interoperate with [1mdacs_auth_transfer [22mto import [1mDACS[0m
               credentials, a program must implement the TOKEN operation. It
               must also provide functionality similar to that of the IMPORT
               operation. Because the TOKEN operation returns a URL
               encapsulating an IMPORT request to which the client is
               redirected, however, the IMPORT operation can be
               implementation-dependent and does need to interoperate with
               [1mdacs_auth_transfer[22m.

               To interoperate with [1mdacs_auth_transfer [22mto export credentials
               to a [1mDACS [22mfederation, a program must be capable of invoking
               [1mdacs_auth_transfer [22mwith the TOKEN operation and its arguments,
               and redirect the client to the URL provided by
               [1mdacs_auth_transfer[22m.

   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[12], [1mdacs_auth_agent[0m
       understands a variety of arguments that depend on the operation being
       requested. The descriptions of the arguments that follow are therefore
       grouped by operation.

       The additional arguments accepted by [1mdacs_auth_transfer [22mfollow.

       [1mPresentation[0m
           For this stage, the value of the [4mOPERATION[24m argument is PRESENTATION
           (case insensitive).

           The [4mFORMAT[24m argument (see [34m[1mdacs(1)[0m[1m[22m[13]) determines the type of
           output, with the default being HTML.

           Additional arguments:

           [4mREDIRECT_DEFAULT[0m
               If "yes" and there is exactly one set of credentials and one
               target federation (i.e., there is nothing for the client to
               select), then automatically redirect the client to a URL
               representing the EXPORT stage of the protocol. Though the
               client will not be required to submit a form, he will not have
               the opportunity to see which identity is being transferred or
               the name of the target federation.

       [1mExport[0m
           For this stage, the value of the [4mOPERATION[24m argument is EXPORT (case
           insensitive).

           Additional arguments:

           [4mDACS_IDENTITY[0m
               This is the identity corresponding to the credentials to be
               exported, expressed as a full [1mDACS [22muser identity (see
               [34m[1mdacs(1)[0m[1m[22m[14]).

           [4mTARGET_FEDERATION[0m
               This is the jurisdiction's identifier for the federation to
               which the selected credentials are to be transferred. The user
               will typically select this identifier from a list produced by
               the same jurisdiction that performs the PRESENTATION operation.

           [4mTRANSFER_SUCCESS_URL[0m
               If the transfer operation is successful, the user will be
               redirected to this URL.

           [4mTRANSFER_ERROR_URL[0m
               If the transfer operation fails, the user will be redirected to
               this URL. If unspecified, the AUTH_TRANSFER_ERROR_URL will be
               used if configured, otherwise a message will be emitted.

           [4mDACS_DEBUG[0m
               If "yes", operate in a debugging mode.

       [1mToken[0m
           For this stage, the value of the [4mOPERATION[24m argument is TOKEN (case
           insensitive).

           Additional arguments:

           [4mDACS_IDENTITY[0m
               The value of this argument is identical to the argument of the
               same name that is passed to the EXPORT stage. If the transfer
               succeeds, this is the identity for which new credentials will
               be issued.

           [4mINITIAL_FEDERATION[0m
               This is the identifier for the federation that received the
               EXPORT request. The target federation must have a mapping for
               this identifier.

           [4mCLIENT_ADDR[0m
               The IP address from which the EXPORT request was issued.

           [4mTRANSFER_SUCCESS_URL[0m
               If the transfer operation is successful, the user wants to be
               redirected to this URL. If unspecified, a default URL will be
               used.

           [4mTRANSFER_ERROR_URL[0m
               If the transfer operation fails, the user will be redirected to
               this URL. If unspecified, a default URL will be used.

           [4mDACS_DEBUG[0m
               If "yes", operate in a debugging mode.

       [1mImport[0m
           For this stage, the value of the [4mOPERATION[24m argument is IMPORT (case
           insensitive).

           Additional arguments:

           [4mTOKEN[0m
               This is the value of the token returned by a previous call to
               the TOKEN stage of the protocol.

           [4mTRANSFER_SUCCESS_URL[0m
               If the transfer operation is successful, the user wants to be
               redirected to this URL. If unspecified, a default URL
               configured at the target federation using the
               [34m[1mAUTH_TRANSFER_SUCCESS_URL[0m[1m[22m[15] directive will be used.

           [4mTRANSFER_ERROR_URL[0m
               If the transfer operation fails, the user wants to be
               redirected to this URL. If unspecified, a default URL
               configured at the target federation using the
               [34m[1mAUTH_TRANSFER_ERROR_URL[0m[1m[22m[16] will be used.

           [4mDACS_DEBUG[0m
               If "yes", operate in a debugging mode.

[1mEXAMPLE[0m
       The following example describes step-by-step how to configure two [1mDACS[0m
       federations, FED_EX1 (example.com) and FED_EX2 (example.net), to enable
       credentials to be transferred [4mfrom[24m FED_EX1 [4mto[24m FED_EX2. For FED_EX1, the
       jurisdiction J1 (j1.example.com) will be configured to export
       credentials and for FED_EX2, J2 (j2.example.net) will be configured to
       import credentials. The example assumes that these two jurisdictions
       have already installed and configured [1mDACS [22mand that it is possible to
       authenticate (obtain credentials) somewhere within FED_EX1.

           [1mNote[0m
           This example will not actually work without changing the domain
           names, URLs, and identities that it uses for demonstration purposes
           to those configured for your federations and jurisdictions. Having
           successfully reproduced this example functionality on your systems,
           it should be apparent how to extend it for additional jurisdictions
           and federations, and how to make credential transfer bidirectional.

        1. At J1, add a jurisdiction-specific access control rule that allows
           [1mdacs_auth_transfer [22mto be used to export an identity:

               <acl_rule status="enabled">
                <services>
                 <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_auth_transfer"'/>
                </services>

                <rule order="allow,deny" pass_credentials="all">
                 <allow>
                   user("auth") and (${Args::OPERATION} eq "PRESENTATION"
                     or ${Args::OPERATION} eq "EXPORT")
                 </allow>
                </rule>
               </acl_rule>

           At J2, add a jurisdiction-specific access control rule that allows
           [1mdacs_auth_transfer [22mto be used to import an identity:

               <acl_rule status="enabled">
                <services>
                 <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_auth_transfer"'/>
                </services>

                <rule order="allow,deny" pass_credentials="all">
                 <allow>
                   (from("j1.example.com") and ${Args::OPERATION} eq "TOKEN")
                     or ${Args::OPERATION} eq "IMPORT"
                 </allow>
                </rule>
               </acl_rule>


               [1mSecurity[0m
               In particular, the rule at the target federation must restrict
               access based on the identity, or possibly the IP address,
               associated with the request. If the cookie-based authentication
               method is used, the rule would test for that specific identity.

        2. At J1, configure [1mdacs_auth_transfer [22mto know how to invoke the TOKEN
           operation so that it can export credentials to FED_EX2. Add this
           directive to dacs.conf:

               AUTH_TRANSFER_EXPORT \
                 "FED_EX2 https://j2.example.net/cgi-bin/dacs/dacs_auth_transfer"

           Note that this is the only required additional configuration at J1.

        3. At J2, configure [1mdacs_auth_transfer [22mso that it will import
           credentials from FED_EX1. Add a Transfer clause to dacs.conf:

               ACCEPT_ALIEN_CREDENTIALS "yes"

               <Transfer id="fed_ex1">
               IMPORT_FROM "FED_EX1"
               SUCCESS_URL \
                 "https://j2.example.net/cgi-bin/dacs/dacs_current_credentials"
               </Transfer>

           This configuration allows credentials to be imported from
           federation FED_EX1. As the default, after successful importation
           users will be redirected to a page that lists their identities in
           federation FED_EX2. In practice this might point to the site's home
           page, for example. The jurisdiction must be told to recognize
           credentials imported from FED_EX2 using the
           ACCEPT_ALIEN_CREDENTIALS directive.

        4. The configuration can now be tested. First, authenticate somewhere
           within FED_EX1 using your browser. Let's assume that you
           authenticated as the identity FED_EX1::J1:bob so that this example
           can refer to a specific name. Invoke this URL from the browser:


               https://j1.example.com/cgi-bin/dacs/dacs_auth_transfer?OPERATION=PRESENTATION

           You should be presented with a web page that displays the identity
           FED_EX1::J1:bob (and any others that happen to be in effect) and
           the target federation name FED_EX2 (and any other federations
           specified by a AUTH_TRANSFER_EXPORT directive). It might be
           instructive to view the source for the HTML page if you are still
           not clear about what the PRESENTATION operation does. Click on the
           Transfer button (if necessary, first selecting an identity and
           target federation).

           One can bypass the PRESENTATION operation by directly invoking the
           URL:

               https://j1.example.com/cgi-bin/dacs/dacs_auth_transfer?\
               OPERATION=EXPORT&DACS_IDENTITY=FED_EX1::J1:bob

           If the transfer is successful, your browser should now possess the
           original credentials for the identity FED_EX1::J1:bob, valid within
           FED_EX1, and credentials for the identity FED_EX1::J1:bob that are
           valid within FED_EX2; [1mdacs_current_credentials[22m, where your browser
           should be redirected to in this example, should display the latter.
           Note that though issued by different sites, the two cookies have
           the same cookie name.

       The following example illustrates how an identity might be transferred
       from a non-[1mDACS [22mfederation (SOME_FED) to a [1mDACS [22mfederation (again,
       FED_EX2 via its jurisdiction J2). We will assume that an appropriate
       access control rule has been configured at J2.

       As in the previous example, at J2, configure [1mdacs_auth_transfer [22mso that
       it will import credentials from SOME_FED by adding a Transfer clause to
       dacs.conf:

           ACCEPT_ALIEN_CREDENTIALS "yes"

           <Transfer id="some_fed">
           IMPORT_FROM  "SOME_FED"
           REFEDERATE   "YES"
           IMPORT_ROLES "NO"
           </Transfer>

       This configuration allows credentials to be imported from federation
       SOME_FED.

       A system administrator must write a small program, run somewhere within
       SOME_FED, that will invoke [1mdacs_auth_transfer [22mat J2 with appropriate
       arguments. The program might be run automatically as part of the login
       procedure at SOME_FED or explicitly by providing a link that a user can
       follow (e.g., labelled "Transfer Login To FED_EX2", or similar). The
       program simply invokes the TOKEN operation at J2 and, if successful,
       redirects the user to the URL that is returned to it by
       [1mdacs_auth_transfer [22m(which represents an IMPORT operation). If the
       IMPORT operation succeeds, the user will be issued an HTTP cookie
       bearing the [1mDACS [22mcredentials. If desired, the URL that the user should
       visit after a successful transfer can be specified through the
       [4mTRANSFER_SUCCESS_URL[24m argument.

       The program might initiate the transfer by constructing and invoking a
       URL (via the POST method) much like this:

           import_url=`http -p INITIAL_FEDERATION "SOME_FED" \
             -p DACS_IDENTITY "FED_EX2::J2:bobo" \
             -p CLIENT_ADDR 127.0.0.1 \
             -p TRANSFER_SUCCESS_URL \
               "https://j2.example.net/cgi-bin/dacs/dacs_current_credentials" \
             -p OPERATION TOKEN \
             'https://j2.example.net/cgi-bin/dacs/dacs_auth_transfer'`

       Here, the requested [1mDACS [22midentity is FED_EX2::J2:bobo. If the response
       looks like a URL, then the TOKEN operation succeeded; to continue the
       transfer, the program must redirect the user to the URL. In this
       example, if credentials are returned to the user, the user will be
       redirected to [1mdacs_current_credentials [22mby [1mDACS [22m(which is useful for
       testing but unlikely in actual use).

[1mFILES[0m
       [34m[1mdacs_auth_transfer.css[0m[1m[22m[4]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[17], [34m[1mdacs_auth_agent(8)[0m[1m[22m[18], [34m[1mdacs.conf(5)[0m[1m[22m[19]

[1mBUGS[0m
       The jurisdictional meta information should be extended to identify
       importing and exporting jurisdictions (e.g., as reported by
       [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[20]).

       It should be possible to optionally perform comparative checks on the
       IP address from which the EXPORT request was issued and the IP address
       from which the IMPORT request was issued. At present, if they are not
       identical a warning message is logged but importation is allowed.

       The current implementation is stateless on the server side. By
       including a nonce in the token, the possibility of replay could be
       further reduced.

       A mechanism for mapping imported names may be needed.

       Although the credential's [1mDACS [22mrole string is passed to the target
       federation, a flexible mechanism for optionally including them in the
       imported credentials should be added.

       The protocol should be improved with respect to peer identification for
       the TOKEN operation.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[21])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[22] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. ACCEPT_ALIEN_CREDENTIALS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACCEPT_ALIEN_CREDENTIALS

        3. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        4. dacs_auth_transfer.css
           http://dacs.dss.ca/man//css/dacs_auth_transfer.css

        5. dacs_auth_transfer.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_transfer.dtd

        6. AUTH_TRANSFER_EXPORT
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_EXPORT

        7. SSL_PROG_CLIENT_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CLIENT_CRT

        8. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

        9. AUTH_TRANSFER_TOKEN_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_TOKEN_LIFETIME_SECS

       10. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       11. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       14. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       15. AUTH_TRANSFER_SUCCESS_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_SUCCESS_URL

       16. AUTH_TRANSFER_ERROR_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_TRANSFER_ERROR_URL

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       19. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       20. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012             DACS_AUTH_TRANSFER(8)
