/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "configuration_node.hpp"

#include "visitor.hpp"
#include "const_visitor.hpp"

namespace dammit {

configuration_node::configuration_node(configuration_node const &c) :
	nodes(),
	platform(c.platform),
	output_dir(c.output_dir),
	temporary_dir(c.temporary_dir)
{
	return;
}

intrusive_ptr<node> configuration_node::apply(visitor &v)
{
	return v.visit(*this);
}

void configuration_node::apply(const_visitor &v) const
{
	v.visit(*this);
}

}
