/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_configuration_node_hpp_
#define dammit_configuration_node_hpp_ 1

#include "node.hpp"

#include "intrusive_ptr_list.hpp"

namespace dammit {

class configuration_node :
	public node
{
public:
	configuration_node(void) { }

	configuration_node(configuration_node const &);

	bool operator!=(configuration_node const &rhs) const
	{
		return (platform != rhs.platform);
	}

	virtual ~configuration_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	typedef intrusive_ptr_list<node> node_list;
	typedef node_list::iterator node_iterator;
	typedef node_list::const_iterator node_const_iterator;

	node_list nodes;

	std::string platform;

	path output_dir;
	path temporary_dir;
};

}

#endif
