/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "exceptions.hpp"

namespace dammit {

build_failed::build_failed(void) : std::logic_error("build failed")
{
	return;
}

invalid_tree_state::invalid_tree_state(std::string const &msg) :
	std::logic_error("invalid tree state: " + msg)
{
	return;
}

}
