/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_node_hpp_
#define dammit_node_hpp_ 1

#include <dammit/path.hpp>

#include "intrusive_ptr.hpp"

#include <list>

namespace dammit {

class visitor;
class const_visitor;

class node;

void intrusive_ptr_add_ref(node *n);
void intrusive_ptr_release(node *n);

class node
{
public:
	inline node(void) throw() { refcount = 0; }
	virtual ~node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &) = 0;
	virtual void apply(const_visitor &) const = 0;

	std::list<path> object_files;

private:
	unsigned int refcount;
	friend void intrusive_ptr_add_ref(node *n);
	friend void intrusive_ptr_release(node *n);
};

inline
void intrusive_ptr_add_ref(node *n)
{
	++n->refcount;
}

inline
void intrusive_ptr_release(node *n)
{
	if(--n->refcount)
		return;
	delete n;
}

}

#endif
